/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.lb.common.conf.structure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.lb.common.conf.structure.Node;

public class NodeBuilder {
    private static final Log log = LogFactory.getLog(NodeBuilder.class);

    public static Node buildNode(Node aNode, String content) {
        if (content == null || content.isEmpty()) {
            return aNode;
        }
        String[] lines = content.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.startsWith("#")) continue;
            if (line.contains("#")) {
                line = line.substring(0, line.indexOf("#"));
            }
            if (line.contains("{") && !line.contains("${")) {
                try {
                    Node childNode = new Node();
                    childNode.setName(line.substring(0, line.indexOf("{")).trim());
                    StringBuilder sb = new StringBuilder();
                    int matchingBraceTracker = 1;
                    while (!(line.contains("}") && matchingBraceTracker == 0 || ++i == lines.length)) {
                        line = lines[i];
                        if (line.contains("{")) {
                            ++matchingBraceTracker;
                        }
                        if (line.contains("}")) {
                            --matchingBraceTracker;
                        }
                        sb.append(line + "\n");
                    }
                    childNode = NodeBuilder.buildNode(childNode, sb.toString());
                    if (aNode == null) {
                        aNode = childNode;
                        continue;
                    }
                    aNode.appendChild(childNode);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Malformatted element is defined in the configuration file. [" + i + "] \n";
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg + line, e);
                }
            }
            if (line.isEmpty() || "}".equals(line)) continue;
            String[] prop = line.split("[\\s]+");
            String value = line.substring(prop[0].length(), line.indexOf(";")).trim();
            try {
                aNode.addProperty(prop[0], value);
                continue;
            }
            catch (Exception e) {
                String msg = "Malformatted property is defined in the configuration file. [" + i + "] \n";
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg + line, e);
            }
        }
        return aNode;
    }

    public static Node buildNode(String content) {
        return NodeBuilder.buildNode(null, content);
    }
}

