/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.IUserService;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUserService
implements IUserService {
    private static final String TEAM = "team";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String DISPLAYNAME = "displayName";
    private static final String EMAILADDRESS = "emailAddress";
    private static final String ORGANIZATIONALUNIT = "organizationalUnit";
    private static final String ORGANIZATION = "organization";
    private static final String LOCALITY = "locality";
    private static final String STATEPROVINCE = "stateProvince";
    private static final String COUNTRYCODE = "countryCode";
    private static final String COOKIE = "cookie";
    private static final String REPOSITORY = "repository";
    private static final String ROLE = "role";
    private static final String MAILINGLIST = "mailingList";
    private static final String PRERECEIVE = "preReceiveScript";
    private static final String POSTRECEIVE = "postReceiveScript";
    private final File realmFile;
    private final Logger logger = LoggerFactory.getLogger(ConfigUserService.class);
    private final Map<String, UserModel> users = new ConcurrentHashMap<String, UserModel>();
    private final Map<String, UserModel> cookies = new ConcurrentHashMap<String, UserModel>();
    private final Map<String, TeamModel> teams = new ConcurrentHashMap<String, TeamModel>();
    private volatile long lastModified;
    private volatile boolean forceReload;

    public ConfigUserService(File realmFile) {
        this.realmFile = realmFile;
    }

    @Override
    public void setup(IStoredSettings settings) {
    }

    @Override
    public boolean supportsCredentialChanges() {
        return true;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return true;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return true;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return true;
    }

    @Override
    public boolean supportsCookies() {
        return true;
    }

    @Override
    public String getCookie(UserModel model) {
        if (!StringUtils.isEmpty(model.cookie)) {
            return model.cookie;
        }
        this.read();
        UserModel storedModel = this.users.get(model.username.toLowerCase());
        return storedModel.cookie;
    }

    @Override
    public UserModel authenticate(char[] cookie) {
        String hash = new String(cookie);
        if (StringUtils.isEmpty(hash)) {
            return null;
        }
        this.read();
        UserModel model = null;
        if (this.cookies.containsKey(hash)) {
            model = this.cookies.get(hash);
        }
        return model;
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        this.read();
        UserModel returnedUser = null;
        UserModel user = this.getUserModel(username);
        if (user == null) {
            return null;
        }
        if (user.password.startsWith("MD5:")) {
            String md5 = "MD5:" + StringUtils.getMD5(new String(password));
            if (user.password.equalsIgnoreCase(md5)) {
                returnedUser = user;
            }
        } else if (user.password.startsWith("CMD5:")) {
            String md5 = "CMD5:" + StringUtils.getMD5(username.toLowerCase() + new String(password));
            if (user.password.equalsIgnoreCase(md5)) {
                returnedUser = user;
            }
        } else if (user.password.equals(new String(password))) {
            returnedUser = user;
        }
        return returnedUser;
    }

    @Override
    public void logout(UserModel user) {
    }

    @Override
    public UserModel getUserModel(String username) {
        this.read();
        UserModel model = this.users.get(username.toLowerCase());
        if (model != null) {
            model = DeepCopier.copy(model);
        }
        return model;
    }

    @Override
    public boolean updateUserModel(UserModel model) {
        return this.updateUserModel(model.username, model);
    }

    @Override
    public boolean updateUserModels(List<UserModel> models) {
        try {
            this.read();
            for (UserModel model : models) {
                UserModel originalUser = this.users.remove(model.username.toLowerCase());
                this.users.put(model.username.toLowerCase(), model);
                if (model.teams == null) continue;
                for (TeamModel team : model.teams) {
                    TeamModel t = this.teams.get(team.name.toLowerCase());
                    if (t == null) {
                        team.addUser(model.username);
                        this.teams.put(team.name.toLowerCase(), team);
                        continue;
                    }
                    t.addUser(model.username);
                }
                if (originalUser == null) continue;
                for (TeamModel team : originalUser.teams) {
                    if (model.isTeamMember(team.name)) continue;
                    team.removeUser(model.username);
                }
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update user {0} models!", models.size()), t);
            return false;
        }
    }

    @Override
    public boolean updateUserModel(String username, UserModel model) {
        UserModel originalUser = null;
        try {
            this.read();
            originalUser = this.users.remove(username.toLowerCase());
            this.users.put(model.username.toLowerCase(), model);
            if (model.teams != null) {
                for (TeamModel team : model.teams) {
                    TeamModel t = this.teams.get(team.name.toLowerCase());
                    if (t == null) {
                        team.addUser(username);
                        this.teams.put(team.name.toLowerCase(), team);
                        continue;
                    }
                    t.removeUser(username);
                    t.addUser(model.username);
                }
                if (originalUser != null) {
                    for (TeamModel team : originalUser.teams) {
                        if (model.isTeamMember(team.name)) continue;
                        team.removeUser(username);
                    }
                }
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            if (originalUser != null) {
                this.users.put(originalUser.username.toLowerCase(), originalUser);
            } else {
                this.users.remove(model.username.toLowerCase());
            }
            this.logger.error(MessageFormat.format("Failed to update user model {0}!", model.username), t);
            return false;
        }
    }

    @Override
    public boolean deleteUserModel(UserModel model) {
        return this.deleteUser(model.username);
    }

    @Override
    public boolean deleteUser(String username) {
        try {
            this.read();
            UserModel model = this.users.remove(username.toLowerCase());
            for (TeamModel team : model.teams) {
                TeamModel t = this.teams.get(team.name);
                if (t == null) {
                    team.removeUser(username);
                    this.teams.put(team.name.toLowerCase(), team);
                    continue;
                }
                t.removeUser(username);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete user {0}!", username), t);
            return false;
        }
    }

    @Override
    public List<String> getAllTeamNames() {
        this.read();
        ArrayList<String> list = new ArrayList<String>(this.teams.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public List<TeamModel> getAllTeams() {
        this.read();
        List<TeamModel> list = new ArrayList<TeamModel>(this.teams.values());
        list = DeepCopier.copy(list);
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> getTeamnamesForRepositoryRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            this.read();
            for (Map.Entry<String, TeamModel> entry : this.teams.entrySet()) {
                TeamModel model = entry.getValue();
                if (!model.hasRepositoryPermission(role)) continue;
                list.add(model.name);
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to get teamnames for role {0}!", role), t);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public boolean setTeamnamesForRepositoryRole(String role, List<String> teamnames) {
        try {
            HashSet<String> specifiedTeams = new HashSet<String>();
            for (String teamname : teamnames) {
                specifiedTeams.add(teamname.toLowerCase());
            }
            this.read();
            for (TeamModel team : this.teams.values()) {
                if (specifiedTeams.contains(team.name.toLowerCase())) {
                    team.addRepositoryPermission(role);
                    continue;
                }
                team.removeRepositoryPermission(role);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to set teams for role {0}!", role), t);
            return false;
        }
    }

    @Override
    public TeamModel getTeamModel(String teamname) {
        this.read();
        TeamModel model = this.teams.get(teamname.toLowerCase());
        if (model != null) {
            model = DeepCopier.copy(model);
        }
        return model;
    }

    @Override
    public boolean updateTeamModel(TeamModel model) {
        return this.updateTeamModel(model.name, model);
    }

    @Override
    public boolean updateTeamModels(List<TeamModel> models) {
        try {
            this.read();
            for (TeamModel team : models) {
                this.teams.put(team.name.toLowerCase(), team);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update team {0} models!", models.size()), t);
            return false;
        }
    }

    @Override
    public boolean updateTeamModel(String teamname, TeamModel model) {
        TeamModel original = null;
        try {
            this.read();
            original = this.teams.remove(teamname.toLowerCase());
            this.teams.put(model.name.toLowerCase(), model);
            this.write();
            return true;
        }
        catch (Throwable t) {
            if (original != null) {
                this.teams.put(original.name.toLowerCase(), original);
            } else {
                this.teams.remove(model.name.toLowerCase());
            }
            this.logger.error(MessageFormat.format("Failed to update team model {0}!", model.name), t);
            return false;
        }
    }

    @Override
    public boolean deleteTeamModel(TeamModel model) {
        return this.deleteTeam(model.name);
    }

    @Override
    public boolean deleteTeam(String teamname) {
        try {
            this.read();
            this.teams.remove(teamname.toLowerCase());
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete team {0}!", teamname), t);
            return false;
        }
    }

    @Override
    public List<String> getAllUsernames() {
        this.read();
        ArrayList<String> list = new ArrayList<String>(this.users.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public List<UserModel> getAllUsers() {
        this.read();
        List<UserModel> list = new ArrayList<UserModel>(this.users.values());
        list = DeepCopier.copy(list);
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> getUsernamesForRepositoryRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            this.read();
            for (Map.Entry<String, UserModel> entry : this.users.entrySet()) {
                UserModel model = entry.getValue();
                if (!model.hasRepositoryPermission(role)) continue;
                list.add(model.username);
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to get usernames for role {0}!", role), t);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    @Deprecated
    public boolean setUsernamesForRepositoryRole(String role, List<String> usernames) {
        try {
            HashSet<String> specifiedUsers = new HashSet<String>();
            for (String username : usernames) {
                specifiedUsers.add(username.toLowerCase());
            }
            this.read();
            for (UserModel user : this.users.values()) {
                if (specifiedUsers.contains(user.username.toLowerCase())) {
                    user.addRepositoryPermission(role);
                    continue;
                }
                user.removeRepositoryPermission(role);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to set usernames for role {0}!", role), t);
            return false;
        }
    }

    @Override
    public boolean renameRepositoryRole(String oldRole, String newRole) {
        try {
            Constants.AccessPermission permission;
            this.read();
            for (UserModel userModel : this.users.values()) {
                if (!userModel.hasRepositoryPermission(oldRole)) continue;
                permission = userModel.removeRepositoryPermission(oldRole);
                userModel.setRepositoryPermission(newRole, permission);
            }
            for (TeamModel teamModel : this.teams.values()) {
                if (!teamModel.hasRepositoryPermission(oldRole)) continue;
                permission = teamModel.removeRepositoryPermission(oldRole);
                teamModel.setRepositoryPermission(newRole, permission);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to rename role {0} to {1}!", oldRole, newRole), t);
            return false;
        }
    }

    @Override
    public boolean deleteRepositoryRole(String role) {
        try {
            this.read();
            for (UserModel user : this.users.values()) {
                user.removeRepositoryPermission(role);
            }
            for (TeamModel team : this.teams.values()) {
                team.removeRepositoryPermission(role);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete role {0}!", role), t);
            return false;
        }
    }

    private synchronized void write() throws IOException {
        ArrayList<String> permissions;
        ArrayList<String> roles;
        File realmFileCopy = new File(this.realmFile.getAbsolutePath() + ".tmp");
        FileBasedConfig config = new FileBasedConfig(realmFileCopy, FS.detect());
        for (UserModel userModel : this.users.values()) {
            if (!StringUtils.isEmpty(userModel.password)) {
                config.setString(USER, userModel.username, PASSWORD, userModel.password);
            }
            if (!StringUtils.isEmpty(userModel.cookie)) {
                config.setString(USER, userModel.username, COOKIE, userModel.cookie);
            }
            if (!StringUtils.isEmpty(userModel.displayName)) {
                config.setString(USER, userModel.username, DISPLAYNAME, userModel.displayName);
            }
            if (!StringUtils.isEmpty(userModel.emailAddress)) {
                config.setString(USER, userModel.username, EMAILADDRESS, userModel.emailAddress);
            }
            if (!StringUtils.isEmpty(userModel.organizationalUnit)) {
                config.setString(USER, userModel.username, ORGANIZATIONALUNIT, userModel.organizationalUnit);
            }
            if (!StringUtils.isEmpty(userModel.organization)) {
                config.setString(USER, userModel.username, ORGANIZATION, userModel.organization);
            }
            if (!StringUtils.isEmpty(userModel.locality)) {
                config.setString(USER, userModel.username, LOCALITY, userModel.locality);
            }
            if (!StringUtils.isEmpty(userModel.stateProvince)) {
                config.setString(USER, userModel.username, STATEPROVINCE, userModel.stateProvince);
            }
            if (!StringUtils.isEmpty(userModel.countryCode)) {
                config.setString(USER, userModel.username, COUNTRYCODE, userModel.countryCode);
            }
            roles = new ArrayList();
            if (userModel.canAdmin) {
                roles.add("#admin");
            }
            if (userModel.canFork) {
                roles.add("#fork");
            }
            if (userModel.canCreate) {
                roles.add("#create");
            }
            if (userModel.excludeFromFederation) {
                roles.add("#notfederated");
            }
            if (roles.size() == 0) {
                roles.add("#none");
            }
            config.setStringList(USER, userModel.username, ROLE, roles);
            if (userModel.permissions == null || userModel.canAdmin) continue;
            permissions = new ArrayList();
            for (Map.Entry<String, Constants.AccessPermission> entry : userModel.permissions.entrySet()) {
                if (!entry.getValue().exceeds(Constants.AccessPermission.NONE)) continue;
                permissions.add(entry.getValue().asRole(entry.getKey()));
            }
            config.setStringList(USER, userModel.username, REPOSITORY, permissions);
        }
        for (TeamModel teamModel : this.teams.values()) {
            roles = new ArrayList<String>();
            if (teamModel.canAdmin) {
                roles.add("#admin");
            }
            if (teamModel.canFork) {
                roles.add("#fork");
            }
            if (teamModel.canCreate) {
                roles.add("#create");
            }
            if (roles.size() == 0) {
                roles.add("#none");
            }
            config.setStringList(TEAM, teamModel.name, ROLE, roles);
            if (!teamModel.canAdmin) {
                if (teamModel.permissions == null) {
                    if (!ArrayUtils.isEmpty(teamModel.repositories)) {
                        config.setStringList(TEAM, teamModel.name, REPOSITORY, new ArrayList<String>(teamModel.repositories));
                    }
                } else {
                    permissions = new ArrayList<String>();
                    for (Map.Entry<String, Constants.AccessPermission> entry : teamModel.permissions.entrySet()) {
                        if (!entry.getValue().exceeds(Constants.AccessPermission.NONE)) continue;
                        permissions.add(entry.getValue().asRole(entry.getKey()));
                    }
                    config.setStringList(TEAM, teamModel.name, REPOSITORY, permissions);
                }
            }
            if (!ArrayUtils.isEmpty(teamModel.users)) {
                config.setStringList(TEAM, teamModel.name, USER, new ArrayList<String>(teamModel.users));
            }
            if (!ArrayUtils.isEmpty(teamModel.mailingLists)) {
                config.setStringList(TEAM, teamModel.name, MAILINGLIST, new ArrayList<String>(teamModel.mailingLists));
            }
            if (!ArrayUtils.isEmpty(teamModel.preReceiveScripts)) {
                config.setStringList(TEAM, teamModel.name, PRERECEIVE, teamModel.preReceiveScripts);
            }
            if (ArrayUtils.isEmpty(teamModel.postReceiveScripts)) continue;
            config.setStringList(TEAM, teamModel.name, POSTRECEIVE, teamModel.postReceiveScripts);
        }
        config.save();
        this.forceReload = true;
        if (realmFileCopy.exists() && realmFileCopy.length() > 0L) {
            if (this.realmFile.exists() && !this.realmFile.delete()) {
                throw new IOException(MessageFormat.format("Failed to delete {0}!", this.realmFile.getAbsolutePath()));
            }
            if (!realmFileCopy.renameTo(this.realmFile)) {
                throw new IOException(MessageFormat.format("Failed to rename {0} to {1}!", realmFileCopy.getAbsolutePath(), this.realmFile.getAbsolutePath()));
            }
        } else {
            throw new IOException(MessageFormat.format("Failed to save {0}!", realmFileCopy.getAbsolutePath()));
        }
    }

    protected synchronized void read() {
        if (this.realmFile.exists() && (this.forceReload || this.realmFile.lastModified() != this.lastModified)) {
            this.forceReload = false;
            this.lastModified = this.realmFile.lastModified();
            this.users.clear();
            this.cookies.clear();
            this.teams.clear();
            try {
                FileBasedConfig config = new FileBasedConfig(this.realmFile, FS.detect());
                config.load();
                Set usernames = config.getSubsections(USER);
                for (String username : usernames) {
                    UserModel user = new UserModel(username.toLowerCase());
                    user.password = config.getString(USER, username, PASSWORD);
                    user.displayName = config.getString(USER, username, DISPLAYNAME);
                    user.emailAddress = config.getString(USER, username, EMAILADDRESS);
                    user.organizationalUnit = config.getString(USER, username, ORGANIZATIONALUNIT);
                    user.organization = config.getString(USER, username, ORGANIZATION);
                    user.locality = config.getString(USER, username, LOCALITY);
                    user.stateProvince = config.getString(USER, username, STATEPROVINCE);
                    user.countryCode = config.getString(USER, username, COUNTRYCODE);
                    user.cookie = config.getString(USER, username, COOKIE);
                    if (StringUtils.isEmpty(user.cookie) && !StringUtils.isEmpty(user.password)) {
                        user.cookie = StringUtils.getSHA1(user.username + user.password);
                    }
                    HashSet<String> roles = new HashSet<String>(Arrays.asList(config.getStringList(USER, username, ROLE)));
                    user.canAdmin = roles.contains("#admin");
                    user.canFork = roles.contains("#fork");
                    user.canCreate = roles.contains("#create");
                    user.excludeFromFederation = roles.contains("#notfederated");
                    if (!user.canAdmin) {
                        HashSet<String> repositories = new HashSet<String>(Arrays.asList(config.getStringList(USER, username, REPOSITORY)));
                        for (String repository : repositories) {
                            user.addRepositoryPermission(repository);
                        }
                    }
                    this.users.put(user.username, user);
                    if (StringUtils.isEmpty(user.cookie)) continue;
                    this.cookies.put(user.cookie, user);
                }
                Set teamnames = config.getSubsections(TEAM);
                for (String teamname : teamnames) {
                    TeamModel team = new TeamModel(teamname);
                    HashSet<String> roles = new HashSet<String>(Arrays.asList(config.getStringList(TEAM, teamname, ROLE)));
                    team.canAdmin = roles.contains("#admin");
                    team.canFork = roles.contains("#fork");
                    team.canCreate = roles.contains("#create");
                    if (!team.canAdmin) {
                        team.addRepositoryPermissions(Arrays.asList(config.getStringList(TEAM, teamname, REPOSITORY)));
                    }
                    team.addUsers(Arrays.asList(config.getStringList(TEAM, teamname, USER)));
                    team.addMailingLists(Arrays.asList(config.getStringList(TEAM, teamname, MAILINGLIST)));
                    team.preReceiveScripts.addAll(Arrays.asList(config.getStringList(TEAM, teamname, PRERECEIVE)));
                    team.postReceiveScripts.addAll(Arrays.asList(config.getStringList(TEAM, teamname, POSTRECEIVE)));
                    this.teams.put(team.name.toLowerCase(), team);
                    for (String user : team.users) {
                        UserModel model = this.users.get(user);
                        if (model == null) continue;
                        model.teams.add(team);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(MessageFormat.format("Failed to read {0}", this.realmFile), (Throwable)e);
            }
        }
    }

    protected long lastModified() {
        return this.lastModified;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.realmFile.getAbsolutePath() + ")";
    }
}

