/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.AccessRestrictionFilter;
import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;

public class DownloadZipFilter
extends AccessRestrictionFilter {
    @Override
    protected String extractRepositoryName(String url) {
        int a = url.indexOf("r=");
        String repository = url.substring(a + 2);
        if (repository.indexOf(38) > -1) {
            repository = repository.substring(0, repository.indexOf(38));
        }
        return repository;
    }

    @Override
    protected String getUrlRequestAction(String url) {
        return "DOWNLOAD";
    }

    @Override
    protected boolean isCreationAllowed() {
        return false;
    }

    @Override
    protected boolean isActionAllowed(RepositoryModel repository, String action) {
        return true;
    }

    @Override
    protected boolean requiresAuthentication(RepositoryModel repository, String action) {
        return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.VIEW);
    }

    @Override
    protected boolean canAccess(RepositoryModel repository, UserModel user, String action) {
        return user.canView(repository);
    }
}

