/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.IStoredSettings;
import com.gitblit.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Properties;

public class FileSettings
extends IStoredSettings {
    protected final File propertiesFile;
    private final Properties properties = new Properties();
    private volatile long lastModified;
    private volatile boolean forceReload;

    public FileSettings(String file) {
        super(FileSettings.class);
        this.propertiesFile = new File(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Properties read() {
        if (this.propertiesFile.exists() && (this.forceReload || this.propertiesFile.lastModified() > this.lastModified)) {
            FileInputStream is = null;
            try {
                Properties props = new Properties();
                is = new FileInputStream(this.propertiesFile);
                props.load(is);
                this.properties.clear();
                this.properties.putAll((Map<?, ?>)props);
                this.lastModified = this.propertiesFile.lastModified();
                this.forceReload = false;
            }
            catch (FileNotFoundException f) {
            }
            catch (Throwable t) {
                this.logger.error("Failed to read " + this.propertiesFile.getName(), t);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        return this.properties;
    }

    @Override
    public synchronized boolean saveSettings(Map<String, String> settings) {
        String content = FileUtils.readContent(this.propertiesFile, "\n");
        for (Map.Entry<String, String> setting : settings.entrySet()) {
            String regex2 = "(?m)^(" + this.regExEscape(setting.getKey()) + "\\s*+=\\s*+)" + "(?:[^\r\n\\\\]++|\\\\(?:\r?\n|\r|.))*+$";
            String oldContent = content;
            if (!(content = content.replaceAll(regex2, setting.getKey() + " = " + setting.getValue())).equals(oldContent)) continue;
            content = content + "\n" + setting.getKey() + " = " + setting.getValue();
        }
        FileUtils.writeContent(this.propertiesFile, content);
        this.forceReload = true;
        return true;
    }

    private String regExEscape(String input) {
        return input.replace(".", "\\.");
    }

    protected long lastModified() {
        return this.lastModified;
    }

    protected boolean forceReload() {
        return this.forceReload;
    }

    public String toString() {
        return this.propertiesFile.getAbsolutePath();
    }
}

