/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.FileSettings;
import com.gitblit.IStoredSettings;
import com.gitblit.IUserService;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileUserService
extends FileSettings
implements IUserService {
    private final Logger logger = LoggerFactory.getLogger(FileUserService.class);
    private final Map<String, String> cookies = new ConcurrentHashMap<String, String>();
    private final Map<String, TeamModel> teams = new ConcurrentHashMap<String, TeamModel>();

    public FileUserService(File realmFile) {
        super(realmFile.getAbsolutePath());
    }

    @Override
    public void setup(IStoredSettings settings) {
    }

    @Override
    public boolean supportsCredentialChanges() {
        return true;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return false;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return false;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return true;
    }

    @Override
    public boolean supportsCookies() {
        return true;
    }

    @Override
    public String getCookie(UserModel model) {
        if (!StringUtils.isEmpty(model.cookie)) {
            return model.cookie;
        }
        Properties allUsers = super.read();
        String value = allUsers.getProperty(model.username);
        String[] roles = value.split(",");
        String password = roles[0];
        String cookie = StringUtils.getSHA1(model.username + password);
        return cookie;
    }

    @Override
    public UserModel authenticate(char[] cookie) {
        String hash = new String(cookie);
        if (StringUtils.isEmpty(hash)) {
            return null;
        }
        this.read();
        UserModel model = null;
        if (this.cookies.containsKey(hash)) {
            String username = this.cookies.get(hash);
            model = this.getUserModel(username);
        }
        return model;
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        Properties allUsers = this.read();
        String userInfo = allUsers.getProperty(username);
        if (StringUtils.isEmpty(userInfo)) {
            return null;
        }
        UserModel returnedUser = null;
        UserModel user = this.getUserModel(username);
        if (user.password.startsWith("MD5:")) {
            String md5 = "MD5:" + StringUtils.getMD5(new String(password));
            if (user.password.equalsIgnoreCase(md5)) {
                returnedUser = user;
            }
        } else if (user.password.startsWith("CMD5:")) {
            String md5 = "CMD5:" + StringUtils.getMD5(username.toLowerCase() + new String(password));
            if (user.password.equalsIgnoreCase(md5)) {
                returnedUser = user;
            }
        } else if (user.password.equals(new String(password))) {
            returnedUser = user;
        }
        return returnedUser;
    }

    @Override
    public void logout(UserModel user) {
    }

    @Override
    public UserModel getUserModel(String username) {
        Properties allUsers = this.read();
        String userInfo = allUsers.getProperty(username.toLowerCase());
        if (userInfo == null) {
            return null;
        }
        UserModel model = new UserModel(username.toLowerCase());
        String[] userValues = userInfo.split(",");
        model.password = userValues[0];
        block3: for (int i = 1; i < userValues.length; ++i) {
            String role = userValues[i];
            switch (role.charAt(0)) {
                case '#': {
                    if (role.equalsIgnoreCase("#admin")) {
                        model.canAdmin = true;
                        continue block3;
                    }
                    if (role.equalsIgnoreCase("#fork")) {
                        model.canFork = true;
                        continue block3;
                    }
                    if (role.equalsIgnoreCase("#create")) {
                        model.canCreate = true;
                        continue block3;
                    }
                    if (!role.equalsIgnoreCase("#notfederated")) continue block3;
                    model.excludeFromFederation = true;
                    continue block3;
                }
                default: {
                    model.addRepositoryPermission(role);
                }
            }
        }
        for (TeamModel team : this.teams.values()) {
            if (!team.hasUser(username)) continue;
            model.teams.add(DeepCopier.copy(team));
        }
        return model;
    }

    @Override
    public boolean updateUserModel(UserModel model) {
        return this.updateUserModel(model.username, model);
    }

    @Override
    public boolean updateUserModels(List<UserModel> models) {
        try {
            Properties allUsers = this.read();
            for (UserModel model : models) {
                this.updateUserCache(allUsers, model.username, model);
            }
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update {0} user models!", models.size()), t);
            return false;
        }
    }

    @Override
    public boolean updateUserModel(String username, UserModel model) {
        try {
            Properties allUsers = this.read();
            this.updateUserCache(allUsers, username, model);
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update user model {0}!", model.username), t);
            return false;
        }
    }

    private boolean updateUserCache(Properties allUsers, String username, UserModel model) {
        try {
            ArrayList<String> roles;
            UserModel oldUser = this.getUserModel(username);
            if (model.permissions == null) {
                roles = new ArrayList<String>();
            } else {
                roles = new ArrayList();
                for (Map.Entry<String, Constants.AccessPermission> entry : model.permissions.entrySet()) {
                    if (!entry.getValue().exceeds(Constants.AccessPermission.NONE)) continue;
                    roles.add(entry.getValue().asRole(entry.getKey()));
                }
            }
            if (model.canAdmin) {
                roles.add("#admin");
            }
            if (model.canFork) {
                roles.add("#fork");
            }
            if (model.canCreate) {
                roles.add("#create");
            }
            if (model.excludeFromFederation) {
                roles.add("#notfederated");
            }
            StringBuilder sb = new StringBuilder();
            if (!StringUtils.isEmpty(model.password)) {
                sb.append(model.password);
            }
            sb.append(',');
            for (String role : roles) {
                sb.append(role);
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            allUsers.remove(username.toLowerCase());
            allUsers.put(model.username.toLowerCase(), sb.toString());
            if (model.teams != null) {
                for (TeamModel team : model.teams) {
                    TeamModel t = this.getTeamModel(team.name);
                    if (t == null) {
                        t = team;
                    }
                    t.removeUser(username);
                    t.addUser(model.username);
                    this.updateTeamCache(allUsers, t.name, t);
                }
                if (oldUser != null) {
                    for (TeamModel team : oldUser.teams) {
                        if (model.isTeamMember(team.name)) continue;
                        team.removeUser(username);
                        this.updateTeamCache(allUsers, team.name, team);
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update user model {0}!", model.username), t);
            return false;
        }
    }

    @Override
    public boolean deleteUserModel(UserModel model) {
        return this.deleteUser(model.username);
    }

    @Override
    public boolean deleteUser(String username) {
        try {
            Properties allUsers = this.read();
            UserModel user = this.getUserModel(username);
            allUsers.remove(username);
            for (TeamModel team : user.teams) {
                TeamModel t = this.getTeamModel(team.name);
                if (t == null) {
                    t = team;
                }
                t.removeUser(username);
                this.updateTeamCache(allUsers, t.name, t);
            }
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete user {0}!", username), t);
            return false;
        }
    }

    @Override
    public List<String> getAllUsernames() {
        Properties allUsers = this.read();
        ArrayList<String> list = new ArrayList<String>();
        for (String user : allUsers.stringPropertyNames()) {
            if (user.charAt(0) == '@') continue;
            list.add(user);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<UserModel> getAllUsers() {
        this.read();
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        for (String username : this.getAllUsernames()) {
            list.add(this.getUserModel(username));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> getUsernamesForRepositoryRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Properties allUsers = this.read();
            block2: for (String username : allUsers.stringPropertyNames()) {
                if (username.charAt(0) == '@') continue;
                String value = allUsers.getProperty(username);
                String[] values = value.split(",");
                for (int i = 1; i < values.length; ++i) {
                    String r = values[i];
                    if (!r.equalsIgnoreCase(role)) continue;
                    list.add(username);
                    continue block2;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to get usernames for role {0}!", role), t);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public boolean setUsernamesForRepositoryRole(String role, List<String> usernames) {
        try {
            HashSet<String> specifiedUsers = new HashSet<String>(usernames);
            HashSet<String> needsAddRole = new HashSet<String>(specifiedUsers);
            HashSet<String> needsRemoveRole = new HashSet<String>();
            Properties allUsers = this.read();
            block2: for (String username : allUsers.stringPropertyNames()) {
                String value = allUsers.getProperty(username);
                String[] values = value.split(",");
                for (int i = 1; i < values.length; ++i) {
                    String r = values[i];
                    if (!r.equalsIgnoreCase(role)) continue;
                    if (specifiedUsers.contains(username)) {
                        needsAddRole.remove(username);
                        continue block2;
                    }
                    needsRemoveRole.add(username);
                    continue block2;
                }
            }
            for (String user : needsAddRole) {
                String userValues = allUsers.getProperty(user);
                userValues = userValues + "," + role;
                allUsers.put(user, userValues);
            }
            for (String user : needsRemoveRole) {
                String[] values = allUsers.getProperty(user).split(",");
                String password = values[0];
                StringBuilder sb = new StringBuilder();
                sb.append(password);
                sb.append(',');
                for (int i = 1; i < values.length; ++i) {
                    String value = values[i];
                    if (value.equalsIgnoreCase(role)) continue;
                    sb.append(value);
                    sb.append(',');
                }
                sb.setLength(sb.length() - 1);
                allUsers.put(user, sb.toString());
            }
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to set usernames for role {0}!", role), t);
            return false;
        }
    }

    @Override
    public boolean renameRepositoryRole(String oldRole, String newRole) {
        try {
            Properties allUsers = this.read();
            HashSet<String> needsRenameRole = new HashSet<String>();
            block2: for (String username : allUsers.stringPropertyNames()) {
                String value = allUsers.getProperty(username);
                String[] roles = value.split(",");
                for (int i = 1; i < roles.length; ++i) {
                    String repository = Constants.AccessPermission.repositoryFromRole(roles[i]);
                    if (!repository.equalsIgnoreCase(oldRole)) continue;
                    needsRenameRole.add(username);
                    continue block2;
                }
            }
            for (String user : needsRenameRole) {
                String userValues = allUsers.getProperty(user);
                String[] values = userValues.split(",");
                String password = values[0];
                StringBuilder sb = new StringBuilder();
                sb.append(password);
                sb.append(',');
                sb.append(newRole);
                sb.append(',');
                for (int i = 1; i < values.length; ++i) {
                    String repository = Constants.AccessPermission.repositoryFromRole(values[i]);
                    if (repository.equalsIgnoreCase(oldRole)) {
                        Constants.AccessPermission permission = Constants.AccessPermission.permissionFromRole(values[i]);
                        sb.append(permission.asRole(newRole));
                        sb.append(',');
                        continue;
                    }
                    sb.append(values[i]);
                    sb.append(',');
                }
                sb.setLength(sb.length() - 1);
                allUsers.put(user, sb.toString());
            }
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to rename role {0} to {1}!", oldRole, newRole), t);
            return false;
        }
    }

    @Override
    public boolean deleteRepositoryRole(String role) {
        try {
            Properties allUsers = this.read();
            HashSet<String> needsDeleteRole = new HashSet<String>();
            block2: for (String username : allUsers.stringPropertyNames()) {
                String value = allUsers.getProperty(username);
                String[] roles = value.split(",");
                for (int i = 1; i < roles.length; ++i) {
                    String repository = Constants.AccessPermission.repositoryFromRole(roles[i]);
                    if (!repository.equalsIgnoreCase(role)) continue;
                    needsDeleteRole.add(username);
                    continue block2;
                }
            }
            for (String user : needsDeleteRole) {
                String userValues = allUsers.getProperty(user);
                String[] values = userValues.split(",");
                String password = values[0];
                StringBuilder sb = new StringBuilder();
                sb.append(password);
                sb.append(',');
                for (int i = 1; i < values.length; ++i) {
                    String repository = Constants.AccessPermission.repositoryFromRole(values[i]);
                    if (repository.equalsIgnoreCase(role)) continue;
                    sb.append(values[i]);
                    sb.append(',');
                }
                sb.setLength(sb.length() - 1);
                allUsers.put(user, sb.toString());
            }
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete role {0}!", role), t);
            return false;
        }
    }

    private void write(Properties properties) throws IOException {
        File realmFileCopy = new File(this.propertiesFile.getAbsolutePath() + ".tmp");
        FileWriter writer = new FileWriter(realmFileCopy);
        properties.store(writer, " Gitblit realm file format:\n   username=password,\\#permission,repository1,repository2...\n   @teamname=!username1,!username2,!username3,repository1,repository2...");
        writer.close();
        if (realmFileCopy.exists() && realmFileCopy.length() > 0L) {
            if (this.propertiesFile.exists() && !this.propertiesFile.delete()) {
                throw new IOException(MessageFormat.format("Failed to delete {0}!", this.propertiesFile.getAbsolutePath()));
            }
            if (!realmFileCopy.renameTo(this.propertiesFile)) {
                throw new IOException(MessageFormat.format("Failed to rename {0} to {1}!", realmFileCopy.getAbsolutePath(), this.propertiesFile.getAbsolutePath()));
            }
        } else {
            throw new IOException(MessageFormat.format("Failed to save {0}!", realmFileCopy.getAbsolutePath()));
        }
    }

    @Override
    protected synchronized Properties read() {
        long lastRead = this.lastModified();
        boolean reload = this.forceReload();
        Properties allUsers = super.read();
        if (reload || lastRead != this.lastModified()) {
            this.cookies.clear();
            this.teams.clear();
            for (String username : allUsers.stringPropertyNames()) {
                String value = allUsers.getProperty(username);
                String[] roles = value.split(",");
                if (username.charAt(0) == '@') {
                    TeamModel team = new TeamModel(username.substring(1));
                    ArrayList<String> repositories = new ArrayList<String>();
                    ArrayList<String> users = new ArrayList<String>();
                    ArrayList<String> mailingLists = new ArrayList<String>();
                    ArrayList<String> preReceive = new ArrayList<String>();
                    ArrayList<String> postReceive = new ArrayList<String>();
                    for (String role : roles) {
                        if (role.charAt(0) == '!') {
                            users.add(role.substring(1));
                            continue;
                        }
                        if (role.charAt(0) == '&') {
                            mailingLists.add(role.substring(1));
                            continue;
                        }
                        if (role.charAt(0) == '^') {
                            preReceive.add(role.substring(1));
                            continue;
                        }
                        if (role.charAt(0) == '%') {
                            postReceive.add(role.substring(1));
                            continue;
                        }
                        switch (role.charAt(0)) {
                            case '#': {
                                if (role.equalsIgnoreCase("#admin")) {
                                    team.canAdmin = true;
                                    break;
                                }
                                if (role.equalsIgnoreCase("#fork")) {
                                    team.canFork = true;
                                    break;
                                }
                                if (!role.equalsIgnoreCase("#create")) break;
                                team.canCreate = true;
                                break;
                            }
                            default: {
                                repositories.add(role);
                            }
                        }
                        repositories.add(role);
                    }
                    if (!team.canAdmin) {
                        team.addRepositoryPermissions(repositories);
                    }
                    team.addUsers(users);
                    team.addMailingLists(mailingLists);
                    team.preReceiveScripts.addAll(preReceive);
                    team.postReceiveScripts.addAll(postReceive);
                    this.teams.put(team.name.toLowerCase(), team);
                    continue;
                }
                String password = roles[0];
                this.cookies.put(StringUtils.getSHA1(username.toLowerCase() + password), username.toLowerCase());
            }
        }
        return allUsers;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.propertiesFile.getAbsolutePath() + ")";
    }

    @Override
    public List<String> getAllTeamNames() {
        ArrayList<String> list = new ArrayList<String>(this.teams.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public List<TeamModel> getAllTeams() {
        List<TeamModel> list = new ArrayList<TeamModel>(this.teams.values());
        list = DeepCopier.copy(list);
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> getTeamnamesForRepositoryRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Properties allUsers = this.read();
            block2: for (String team : allUsers.stringPropertyNames()) {
                if (team.charAt(0) != '@') continue;
                String value = allUsers.getProperty(team);
                String[] values = value.split(",");
                for (int i = 0; i < values.length; ++i) {
                    String r = values[i];
                    if (!r.equalsIgnoreCase(role)) continue;
                    list.add(team.substring(1));
                    continue block2;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to get teamnames for role {0}!", role), t);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public boolean setTeamnamesForRepositoryRole(String role, List<String> teamnames) {
        try {
            String team;
            int i;
            HashSet<String> specifiedTeams = new HashSet<String>(teamnames);
            HashSet<String> needsAddRole = new HashSet<String>(specifiedTeams);
            HashSet<String> needsRemoveRole = new HashSet<String>();
            Properties allUsers = this.read();
            block2: for (String team2 : allUsers.stringPropertyNames()) {
                if (team2.charAt(0) != '@') continue;
                String name = team2.substring(1);
                String value = allUsers.getProperty(team2);
                String[] values = value.split(",");
                for (i = 0; i < values.length; ++i) {
                    String r = values[i];
                    if (!r.equalsIgnoreCase(role)) continue;
                    if (specifiedTeams.contains(name)) {
                        needsAddRole.remove(name);
                        continue block2;
                    }
                    needsRemoveRole.add(name);
                    continue block2;
                }
            }
            for (String name : needsAddRole) {
                team = "@" + name;
                String teamValues = allUsers.getProperty(team);
                teamValues = teamValues + "," + role;
                allUsers.put(team, teamValues);
            }
            for (String name : needsRemoveRole) {
                team = "@" + name;
                String[] values = allUsers.getProperty(team).split(",");
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (value.equalsIgnoreCase(role)) continue;
                    sb.append(value);
                    sb.append(',');
                }
                sb.setLength(sb.length() - 1);
                allUsers.put(team, sb.toString());
            }
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to set teamnames for role {0}!", role), t);
            return false;
        }
    }

    @Override
    public TeamModel getTeamModel(String teamname) {
        this.read();
        TeamModel team = this.teams.get(teamname.toLowerCase());
        if (team != null) {
            team = DeepCopier.copy(team);
        }
        return team;
    }

    @Override
    public boolean updateTeamModel(TeamModel model) {
        return this.updateTeamModel(model.name, model);
    }

    @Override
    public boolean updateTeamModels(List<TeamModel> models) {
        try {
            Properties allUsers = this.read();
            for (TeamModel model : models) {
                this.updateTeamCache(allUsers, model.name, model);
            }
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update {0} team models!", models.size()), t);
            return false;
        }
    }

    @Override
    public boolean updateTeamModel(String teamname, TeamModel model) {
        try {
            Properties allUsers = this.read();
            this.updateTeamCache(allUsers, teamname, model);
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update team model {0}!", model.name), t);
            return false;
        }
    }

    private void updateTeamCache(Properties allUsers, String teamname, TeamModel model) {
        ArrayList<Object> roles;
        StringBuilder sb = new StringBuilder();
        if (model.permissions == null) {
            roles = model.repositories != null ? new ArrayList<String>(model.repositories) : new ArrayList();
        } else {
            roles = new ArrayList();
            for (Map.Entry<String, Constants.AccessPermission> entry : model.permissions.entrySet()) {
                if (!entry.getValue().exceeds(Constants.AccessPermission.NONE)) continue;
                roles.add(entry.getValue().asRole(entry.getKey()));
            }
        }
        if (model.canAdmin) {
            roles.add("#admin");
        }
        if (model.canFork) {
            roles.add("#fork");
        }
        if (model.canCreate) {
            roles.add("#create");
        }
        for (String string : roles) {
            sb.append(string);
            sb.append(',');
        }
        if (!ArrayUtils.isEmpty(model.users)) {
            for (String string : model.users) {
                sb.append('!');
                sb.append(string);
                sb.append(',');
            }
        }
        if (!ArrayUtils.isEmpty(model.mailingLists)) {
            for (String string : model.mailingLists) {
                sb.append('&');
                sb.append(string);
                sb.append(',');
            }
        }
        if (!ArrayUtils.isEmpty(model.preReceiveScripts)) {
            for (String string : model.preReceiveScripts) {
                sb.append('^');
                sb.append(string);
                sb.append(',');
            }
        }
        if (!ArrayUtils.isEmpty(model.postReceiveScripts)) {
            for (String string : model.postReceiveScripts) {
                sb.append('%');
                sb.append(string);
                sb.append(',');
            }
        }
        sb.setLength(sb.length() - 1);
        allUsers.remove("@" + teamname);
        allUsers.put("@" + model.name, sb.toString());
        this.teams.remove(teamname.toLowerCase());
        this.teams.put(model.name.toLowerCase(), model);
    }

    @Override
    public boolean deleteTeamModel(TeamModel model) {
        return this.deleteTeam(model.name);
    }

    @Override
    public boolean deleteTeam(String teamname) {
        Properties allUsers = this.read();
        this.teams.remove(teamname.toLowerCase());
        allUsers.remove("@" + teamname);
        try {
            this.write(allUsers);
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete team {0}!", teamname), t);
            return false;
        }
    }
}

