/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.FederationPullExecutor;
import com.gitblit.FileSettings;
import com.gitblit.GCExecutor;
import com.gitblit.GitBlitException;
import com.gitblit.GitblitUserService;
import com.gitblit.IStoredSettings;
import com.gitblit.IUserService;
import com.gitblit.LuceneExecutor;
import com.gitblit.MailExecutor;
import com.gitblit.WebXmlSettings;
import com.gitblit.models.FederationModel;
import com.gitblit.models.FederationProposal;
import com.gitblit.models.FederationSet;
import com.gitblit.models.ForkModel;
import com.gitblit.models.Metric;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.SearchResult;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.ServerStatus;
import com.gitblit.models.SettingModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.Base64;
import com.gitblit.utils.ByteFormat;
import com.gitblit.utils.ContainerUtils;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.FederationUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.MetricUtils;
import com.gitblit.utils.ObjectCache;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.X509Utils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.resource.ContextRelativeResource;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.WindowCache;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitBlit
implements ServletContextListener {
    private static GitBlit gitblit;
    private final Logger logger = LoggerFactory.getLogger(GitBlit.class);
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(5);
    private final List<FederationModel> federationRegistrations = Collections.synchronizedList(new ArrayList());
    private final Map<String, FederationModel> federationPullResults = new ConcurrentHashMap<String, FederationModel>();
    private final ObjectCache<Long> repositorySizeCache = new ObjectCache();
    private final ObjectCache<List<Metric>> repositoryMetricsCache = new ObjectCache();
    private final Map<String, RepositoryModel> repositoryListCache = new ConcurrentHashMap<String, RepositoryModel>();
    private final Map<String, ProjectModel> projectCache = new ConcurrentHashMap<String, ProjectModel>();
    private final AtomicReference<String> repositoryListSettingsChecksum = new AtomicReference<String>("");
    private ServletContext servletContext;
    private File repositoriesFolder;
    private IUserService userService;
    private IStoredSettings settings;
    private ServerSettings settingsModel;
    private ServerStatus serverStatus;
    private MailExecutor mailExecutor;
    private LuceneExecutor luceneExecutor;
    private GCExecutor gcExecutor;
    private TimeZone timezone;
    private FileBasedConfig projectConfigs;

    public GitBlit() {
        if (gitblit == null) {
            gitblit = this;
        }
    }

    public GitBlit(IUserService userService) {
        this.userService = userService;
        gitblit = this;
    }

    public static GitBlit self() {
        if (gitblit == null) {
            new GitBlit();
        }
        return gitblit;
    }

    public static boolean isGO() {
        return GitBlit.self().settings instanceof FileSettings;
    }

    public static TimeZone getTimezone() {
        if (GitBlit.self().timezone == null) {
            String tzid = GitBlit.getString("web.timezone", null);
            if (StringUtils.isEmpty(tzid)) {
                GitBlit.self().timezone = TimeZone.getDefault();
                return GitBlit.self().timezone;
            }
            GitBlit.self().timezone = TimeZone.getTimeZone(tzid);
        }
        return GitBlit.self().timezone;
    }

    public static String[] getEncodings() {
        return GitBlit.getStrings("web.blobEncodings").toArray(new String[0]);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return GitBlit.self().settings.getBoolean(key, defaultValue);
    }

    public static int getInteger(String key, int defaultValue) {
        return GitBlit.self().settings.getInteger(key, defaultValue);
    }

    public static int getFilesize(String key, int defaultValue) {
        return GitBlit.self().settings.getFilesize(key, defaultValue);
    }

    public static long getFilesize(String key, long defaultValue) {
        return GitBlit.self().settings.getFilesize(key, defaultValue);
    }

    public static char getChar(String key, char defaultValue) {
        return GitBlit.self().settings.getChar(key, defaultValue);
    }

    public static String getString(String key, String defaultValue) {
        return GitBlit.self().settings.getString(key, defaultValue);
    }

    public static List<String> getStrings(String key) {
        return GitBlit.self().settings.getStrings(key);
    }

    public static Map<String, String> getMap(String key) {
        return GitBlit.self().settings.getMap(key);
    }

    public static List<String> getAllKeys(String startingWith) {
        return GitBlit.self().settings.getAllKeys(startingWith);
    }

    public static boolean isDebugMode() {
        return GitBlit.self().settings.getBoolean("web.debugMode", false);
    }

    public static File getFileOrFolder(String key, String defaultFileOrFolder) {
        String fileOrFolder = GitBlit.getString(key, defaultFileOrFolder);
        return GitBlit.getFileOrFolder(fileOrFolder);
    }

    public static File getFileOrFolder(String fileOrFolder) {
        String openShift = System.getenv("OPENSHIFT_DATA_DIR");
        if (!StringUtils.isEmpty(openShift)) {
            return new File(openShift, fileOrFolder);
        }
        return new File(fileOrFolder);
    }

    public static File getRepositoriesFolder() {
        return GitBlit.getFileOrFolder("git.repositoriesFolder", "git");
    }

    public static File getProposalsFolder() {
        return GitBlit.getFileOrFolder("federation.proposalsFolder", "proposals");
    }

    public static File getGroovyScriptsFolder() {
        return GitBlit.getFileOrFolder("groovy.scriptsFolder", "groovy");
    }

    public boolean updateSettings(Map<String, String> updatedSettings) {
        return this.settings.saveSettings(updatedSettings);
    }

    public ServerStatus getStatus() {
        this.serverStatus.heapAllocated = Runtime.getRuntime().totalMemory();
        this.serverStatus.heapFree = Runtime.getRuntime().freeMemory();
        return this.serverStatus;
    }

    public List<String> getOtherCloneUrls(String repositoryName) {
        ArrayList<String> cloneUrls = new ArrayList<String>();
        for (String url : this.settings.getStrings("web.otherUrls")) {
            cloneUrls.add(MessageFormat.format(url, repositoryName));
        }
        return cloneUrls;
    }

    public void setUserService(IUserService userService) {
        this.logger.info("Setting up user service " + ((Object)userService).toString());
        this.userService = userService;
        this.userService.setup(this.settings);
    }

    public boolean supportsCredentialChanges() {
        return this.userService.supportsCredentialChanges();
    }

    public boolean supportsDisplayNameChanges() {
        return this.userService.supportsDisplayNameChanges();
    }

    public boolean supportsEmailAddressChanges() {
        return this.userService.supportsEmailAddressChanges();
    }

    public boolean supportsTeamMembershipChanges() {
        return this.userService.supportsTeamMembershipChanges();
    }

    public UserModel authenticate(String username, char[] password) {
        List<String> tokens;
        if (StringUtils.isEmpty(username)) {
            return null;
        }
        String pw = new String(password);
        if (StringUtils.isEmpty(pw)) {
            return null;
        }
        if (GitBlit.canFederate() && username.equalsIgnoreCase("$gitblit") && (tokens = this.getFederationTokens()).contains(pw)) {
            UserModel federationUser = new UserModel("$gitblit");
            federationUser.canAdmin = true;
            return federationUser;
        }
        if (this.userService == null) {
            return null;
        }
        return this.userService.authenticate(username, password);
    }

    protected UserModel authenticate(Cookie[] cookies) {
        if (this.userService == null) {
            return null;
        }
        if (this.userService.supportsCookies() && cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("Gitblit")) continue;
                String value = cookie.getValue();
                return this.userService.authenticate(value.toCharArray());
            }
        }
        return null;
    }

    public UserModel authenticate(HttpServletRequest httpRequest) {
        return this.authenticate(httpRequest, false);
    }

    public UserModel authenticate(HttpServletRequest httpRequest, boolean requiresCertificate) {
        String base64Credentials;
        String credentials;
        String[] values;
        UserModel user;
        String[] oids;
        boolean checkValidity = this.settings.getBoolean("git.enforceCertificateValidity", true);
        UserModel model = HttpUtils.getUserModelFromCertificate(httpRequest, checkValidity, oids = GitBlit.getStrings("git.certificateUsernameOIDs").toArray(new String[0]));
        if (model != null) {
            UserModel user2 = this.getUserModel(model.username);
            X509Utils.X509Metadata metadata = HttpUtils.getCertificateMetadata(httpRequest);
            if (user2 != null) {
                this.flagWicketSession(Constants.AuthenticationType.CERTIFICATE);
                this.logger.info(MessageFormat.format("{0} authenticated by client certificate {1} from {2}", user2.username, metadata.serialNumber, httpRequest.getRemoteAddr()));
                return user2;
            }
            this.logger.warn(MessageFormat.format("Failed to find UserModel for {0}, attempted client certificate ({1}) authentication from {2}", model.username, metadata.serialNumber, httpRequest.getRemoteAddr()));
        }
        if (requiresCertificate) {
            return null;
        }
        Principal principal = httpRequest.getUserPrincipal();
        if (principal != null) {
            user = this.getUserModel(principal.getName());
            if (user != null) {
                this.flagWicketSession(Constants.AuthenticationType.CONTAINER);
                this.logger.info(MessageFormat.format("{0} authenticated by servlet container principal from {1}", user.username, httpRequest.getRemoteAddr()));
                return user;
            }
            this.logger.warn(MessageFormat.format("Failed to find UserModel for {0}, attempted servlet container authentication from {1}", principal.getName(), httpRequest.getRemoteAddr()));
        }
        if (this.allowCookieAuthentication() && (user = this.authenticate(httpRequest.getCookies())) != null) {
            this.flagWicketSession(Constants.AuthenticationType.COOKIE);
            this.logger.info(MessageFormat.format("{0} authenticated by cookie from {1}", user.username, httpRequest.getRemoteAddr()));
            return user;
        }
        String authorization = httpRequest.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic") && (values = (credentials = new String(Base64.decode(base64Credentials = authorization.substring("Basic".length()).trim()), Charset.forName("UTF-8"))).split(":", 2)).length == 2) {
            String username = values[0];
            char[] password = values[1].toCharArray();
            UserModel user3 = this.authenticate(username, password);
            if (user3 != null) {
                this.flagWicketSession(Constants.AuthenticationType.CREDENTIALS);
                this.logger.info(MessageFormat.format("{0} authenticated by BASIC request header from {1}", user3.username, httpRequest.getRemoteAddr()));
                return user3;
            }
            this.logger.warn(MessageFormat.format("Failed login attempt for {0}, invalid credentials ({1}) from {2}", username, credentials, httpRequest.getRemoteAddr()));
        }
        return null;
    }

    protected void flagWicketSession(Constants.AuthenticationType authenticationType) {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle != null) {
            GitBlitWebSession session = GitBlitWebSession.get();
            session.authenticationType = authenticationType;
        }
    }

    public InputStream getResourceAsStream(String file) throws ResourceStreamNotFoundException {
        ContextRelativeResource res = WicketUtils.getResource(file);
        return res.getResourceStream().getInputStream();
    }

    public void setCookie(WebResponse response, UserModel user) {
        if (this.userService == null) {
            return;
        }
        if (this.userService.supportsCookies()) {
            Cookie userCookie;
            if (user == null) {
                userCookie = new Cookie("Gitblit", "");
            } else {
                String cookie = this.userService.getCookie(user);
                if (StringUtils.isEmpty(cookie)) {
                    userCookie = new Cookie("Gitblit", "");
                } else {
                    userCookie = new Cookie("Gitblit", cookie);
                    userCookie.setMaxAge(Integer.MAX_VALUE);
                }
            }
            userCookie.setPath("/");
            response.addCookie(userCookie);
        }
    }

    public void logout(UserModel user) {
        if (this.userService == null) {
            return;
        }
        this.userService.logout(user);
    }

    public List<String> getAllUsernames() {
        ArrayList<String> names = new ArrayList<String>(this.userService.getAllUsernames());
        return names;
    }

    public List<UserModel> getAllUsers() {
        List<UserModel> users = this.userService.getAllUsers();
        return users;
    }

    public boolean deleteUser(String username) {
        if (StringUtils.isEmpty(username)) {
            return false;
        }
        return this.userService.deleteUser(username);
    }

    public UserModel getUserModel(String username) {
        if (StringUtils.isEmpty(username)) {
            return null;
        }
        UserModel user = this.userService.getUserModel(username);
        return user;
    }

    public List<RegistrantAccessPermission> getUserAccessPermissions(UserModel user) {
        LinkedHashSet<RegistrantAccessPermission> set = new LinkedHashSet<RegistrantAccessPermission>();
        set.addAll(user.getRepositoryPermissions());
        for (RegistrantAccessPermission permission : set) {
            RepositoryModel rm;
            if (!permission.mutable || !Constants.PermissionType.EXPLICIT.equals((Object)permission.permissionType) || (rm = GitBlit.self().getRepositoryModel(permission.registrant)) != null) continue;
            permission.permissionType = Constants.PermissionType.MISSING;
            permission.mutable = false;
        }
        for (RepositoryModel rm : this.repositoryListCache.values()) {
            if (!rm.isUsersPersonalRepository(user.username) && !rm.isOwner(user.username)) continue;
            RegistrantAccessPermission rp = new RegistrantAccessPermission(rm.name, Constants.AccessPermission.REWIND, Constants.PermissionType.OWNER, Constants.RegistrantType.REPOSITORY, null, false);
            set.remove(rp);
            set.add(rp);
        }
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>(set);
        Collections.sort(list);
        return list;
    }

    public List<RegistrantAccessPermission> getUserAccessPermissions(RepositoryModel repository) {
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>();
        if (Constants.AccessRestrictionType.NONE.equals((Object)repository.accessRestriction)) {
            return list;
        }
        if (Constants.AuthorizationControl.AUTHENTICATED.equals((Object)repository.authorizationControl)) {
            return list;
        }
        for (UserModel user : this.userService.getAllUsers()) {
            RegistrantAccessPermission ap = user.getRepositoryPermission(repository);
            if (!ap.permission.exceeds(Constants.AccessPermission.NONE)) continue;
            list.add(ap);
        }
        return list;
    }

    public boolean setUserAccessPermissions(RepositoryModel repository, Collection<RegistrantAccessPermission> permissions) {
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (RegistrantAccessPermission up : permissions) {
            if (!up.mutable) continue;
            UserModel user = this.userService.getUserModel(up.registrant);
            user.setRepositoryPermission(repository.name, up.permission);
            users.add(user);
        }
        return this.userService.updateUserModels(users);
    }

    public List<String> getRepositoryUsers(RepositoryModel repository) {
        return this.userService.getUsernamesForRepositoryRole(repository.name);
    }

    @Deprecated
    public boolean setRepositoryUsers(RepositoryModel repository, List<String> repositoryUsers) {
        return false;
    }

    public void updateUserModel(String username, UserModel user, boolean isCreate) throws GitBlitException {
        if (!username.equalsIgnoreCase(user.username)) {
            if (this.userService.getUserModel(user.username) != null) {
                throw new GitBlitException(MessageFormat.format("Failed to rename ''{0}'' because ''{1}'' already exists.", username, user.username));
            }
            for (RepositoryModel model : this.getRepositoryModels(user)) {
                if (model.isUsersPersonalRepository(username)) {
                    model.owner = user.username;
                    String oldRepositoryName = model.name;
                    model.name = "~" + user.username + model.name.substring(model.projectPath.length());
                    model.projectPath = "~" + user.username;
                    this.updateRepositoryModel(oldRepositoryName, model, false);
                    continue;
                }
                if (!model.isOwner(username)) continue;
                model.owner = user.username;
                this.updateRepositoryModel(model.name, model, false);
            }
        }
        if (!this.userService.updateUserModel(username, user)) {
            throw new GitBlitException(isCreate ? "Failed to add user!" : "Failed to update user!");
        }
    }

    public List<String> getAllTeamnames() {
        ArrayList<String> teams = new ArrayList<String>(this.userService.getAllTeamNames());
        return teams;
    }

    public List<TeamModel> getAllTeams() {
        List<TeamModel> teams = this.userService.getAllTeams();
        return teams;
    }

    public TeamModel getTeamModel(String teamname) {
        return this.userService.getTeamModel(teamname);
    }

    public List<RegistrantAccessPermission> getTeamAccessPermissions(RepositoryModel repository) {
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>();
        for (TeamModel team : this.userService.getAllTeams()) {
            RegistrantAccessPermission ap = team.getRepositoryPermission(repository);
            if (!ap.permission.exceeds(Constants.AccessPermission.NONE)) continue;
            list.add(ap);
        }
        Collections.sort(list);
        return list;
    }

    public boolean setTeamAccessPermissions(RepositoryModel repository, Collection<RegistrantAccessPermission> permissions) {
        ArrayList<TeamModel> teams = new ArrayList<TeamModel>();
        for (RegistrantAccessPermission tp : permissions) {
            if (!tp.mutable) continue;
            TeamModel team = this.userService.getTeamModel(tp.registrant);
            team.setRepositoryPermission(repository.name, tp.permission);
            teams.add(team);
        }
        return this.userService.updateTeamModels(teams);
    }

    public List<String> getRepositoryTeams(RepositoryModel repository) {
        return this.userService.getTeamnamesForRepositoryRole(repository.name);
    }

    @Deprecated
    public boolean setRepositoryTeams(RepositoryModel repository, List<String> repositoryTeams) {
        return false;
    }

    public void updateTeamModel(String teamname, TeamModel team, boolean isCreate) throws GitBlitException {
        if (!teamname.equalsIgnoreCase(team.name) && this.userService.getTeamModel(team.name) != null) {
            throw new GitBlitException(MessageFormat.format("Failed to rename ''{0}'' because ''{1}'' already exists.", teamname, team.name));
        }
        if (!this.userService.updateTeamModel(teamname, team)) {
            throw new GitBlitException(isCreate ? "Failed to add team!" : "Failed to update team!");
        }
    }

    public boolean deleteTeam(String teamname) {
        return this.userService.deleteTeam(teamname);
    }

    private void addToCachedRepositoryList(RepositoryModel model) {
        if (this.settings.getBoolean("git.cacheRepositoryList", true)) {
            this.repositoryListCache.put(model.name.toLowerCase(), model);
            if (!StringUtils.isEmpty(model.originRepository) && this.repositoryListCache.containsKey(model.originRepository)) {
                RepositoryModel origin = this.repositoryListCache.get(model.originRepository);
                origin.addFork(model.name);
            }
        }
    }

    private RepositoryModel removeFromCachedRepositoryList(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        return this.repositoryListCache.remove(name.toLowerCase());
    }

    private void clearRepositoryMetadataCache(String repositoryName) {
        this.repositorySizeCache.remove(repositoryName);
        this.repositoryMetricsCache.remove(repositoryName);
    }

    public void resetRepositoryListCache() {
        this.logger.info("Repository cache manually reset");
        this.repositoryListCache.clear();
    }

    private String getRepositoryListSettingsChecksum() {
        StringBuilder ns = new StringBuilder();
        ns.append(this.settings.getString("git.cacheRepositoryList", "")).append('\n');
        ns.append(this.settings.getString("git.onlyAccessBareRepositories", "")).append('\n');
        ns.append(this.settings.getString("git.searchRepositoriesSubfolders", "")).append('\n');
        ns.append(this.settings.getString("git.searchRecursionDepth", "")).append('\n');
        ns.append(this.settings.getString("git.searchExclusions", "")).append('\n');
        String checksum = StringUtils.getSHA1(ns.toString());
        return checksum;
    }

    private boolean isValidRepositoryList() {
        String newChecksum = this.getRepositoryListSettingsChecksum();
        boolean valid = newChecksum.equals(this.repositoryListSettingsChecksum.get());
        this.repositoryListSettingsChecksum.set(newChecksum);
        if (!valid && this.settings.getBoolean("git.cacheRepositoryList", true)) {
            this.logger.info("Repository list settings have changed. Clearing repository list cache.");
            this.repositoryListCache.clear();
        }
        return valid;
    }

    public List<String> getRepositoryList() {
        if (this.repositoryListCache.size() == 0 || !this.isValidRepositoryList()) {
            long startTime = System.currentTimeMillis();
            List<String> repositories = JGitUtils.getRepositoryList(this.repositoriesFolder, this.settings.getBoolean("git.onlyAccessBareRepositories", false), this.settings.getBoolean("git.searchRepositoriesSubfolders", true), this.settings.getInteger("git.searchRecursionDepth", -1), this.settings.getStrings("git.searchExclusions"));
            if (!this.settings.getBoolean("git.cacheRepositoryList", true)) {
                StringUtils.sortRepositorynames(repositories);
                return repositories;
            }
            String msg = "{0} repositories identified in {1} msecs";
            if (GitBlit.getBoolean("web.showRepositorySizes", true)) {
                msg = "{0} repositories identified with calculated folder sizes in {1} msecs";
                for (String repository : repositories) {
                    RepositoryModel model = this.getRepositoryModel(repository);
                    if (model.skipSizeCalculation) continue;
                    this.calculateSize(model);
                }
            } else {
                for (String repository : repositories) {
                    this.getRepositoryModel(repository);
                }
            }
            for (RepositoryModel model : this.repositoryListCache.values()) {
                if (StringUtils.isEmpty(model.originRepository) || !this.repositoryListCache.containsKey(model.originRepository)) continue;
                RepositoryModel origin = this.repositoryListCache.get(model.originRepository);
                origin.addFork(model.name);
            }
            long duration = System.currentTimeMillis() - startTime;
            this.logger.info(MessageFormat.format(msg, this.repositoryListCache.size(), duration));
        }
        ArrayList<String> list = new ArrayList<String>(this.repositoryListCache.keySet());
        StringUtils.sortRepositorynames(list);
        return list;
    }

    public Repository getRepository(String repositoryName) {
        return this.getRepository(repositoryName, true);
    }

    public Repository getRepository(String repositoryName, boolean logError) {
        Repository r;
        block4: {
            if (this.isCollectingGarbage(repositoryName)) {
                this.logger.warn(MessageFormat.format("Rejecting request for {0}, busy collecting garbage!", repositoryName));
                return null;
            }
            File dir = RepositoryCache.FileKey.resolve((File)new File(this.repositoriesFolder, repositoryName), (FS)FS.DETECTED);
            if (dir == null) {
                return null;
            }
            r = null;
            try {
                RepositoryCache.FileKey key = RepositoryCache.FileKey.exact((File)dir, (FS)FS.DETECTED);
                r = RepositoryCache.open((RepositoryCache.Key)key, (boolean)true);
            }
            catch (IOException e) {
                if (!logError) break block4;
                this.logger.error("GitBlit.getRepository(String) failed to find " + new File(this.repositoriesFolder, repositoryName).getAbsolutePath());
            }
        }
        return r;
    }

    public List<RepositoryModel> getRepositoryModels(UserModel user) {
        long methodStart = System.currentTimeMillis();
        List<String> list = this.getRepositoryList();
        ArrayList<RepositoryModel> repositories = new ArrayList<RepositoryModel>();
        for (String repo : list) {
            RepositoryModel model = this.getRepositoryModel(user, repo);
            if (model == null) continue;
            repositories.add(model);
        }
        if (GitBlit.getBoolean("web.showRepositorySizes", true)) {
            int repoCount = 0;
            long startTime = System.currentTimeMillis();
            ByteFormat byteFormat = new ByteFormat();
            for (RepositoryModel model : repositories) {
                if (model.skipSizeCalculation) continue;
                ++repoCount;
                model.size = byteFormat.format(this.calculateSize(model));
            }
            long duration = System.currentTimeMillis() - startTime;
            if (duration > 250L) {
                this.logger.info(MessageFormat.format("{0} repository sizes calculated in {1} msecs", repoCount, duration));
            }
        }
        long duration = System.currentTimeMillis() - methodStart;
        this.logger.info(MessageFormat.format("{0} repository models loaded for {1} in {2} msecs", repositories.size(), user == null ? "anonymous" : user.username, duration));
        return repositories;
    }

    public RepositoryModel getRepositoryModel(UserModel user, String repositoryName) {
        RepositoryModel model = this.getRepositoryModel(repositoryName);
        if (model == null) {
            return null;
        }
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        if (user.canView(model)) {
            return model;
        }
        return null;
    }

    public RepositoryModel getRepositoryModel(String repositoryName) {
        if (!this.repositoryListCache.containsKey(repositoryName)) {
            RepositoryModel model = this.loadRepositoryModel(repositoryName);
            if (model == null) {
                return null;
            }
            this.addToCachedRepositoryList(model);
            return model;
        }
        RepositoryModel model = this.repositoryListCache.get(repositoryName.toLowerCase());
        if (this.gcExecutor.isCollectingGarbage(model.name)) {
            RepositoryModel rm = DeepCopier.copy(model);
            rm.isCollectingGarbage = true;
            return rm;
        }
        Repository r = this.getRepository(model.name);
        if (r == null) {
            this.removeFromCachedRepositoryList(repositoryName);
            this.logger.error(MessageFormat.format("Repository \"{0}\" is missing! Removing from cache.", repositoryName));
            return null;
        }
        FileBasedConfig config = (FileBasedConfig)this.getRepositoryConfig(r);
        if (config.isOutdated()) {
            this.logger.info(MessageFormat.format("Config for \"{0}\" has changed. Reloading model and updating cache.", repositoryName));
            model = this.loadRepositoryModel(repositoryName);
            this.removeFromCachedRepositoryList(repositoryName);
            this.addToCachedRepositoryList(model);
        } else {
            if (!model.hasCommits) {
                model.hasCommits = JGitUtils.hasCommits(r);
            }
            model.lastChange = JGitUtils.getLastChange(r);
        }
        r.close();
        return DeepCopier.copy(model);
    }

    private Map<String, ProjectModel> getProjectConfigs() {
        if (this.projectCache.isEmpty() || this.projectConfigs.isOutdated()) {
            try {
                this.projectConfigs.load();
            }
            catch (Exception e) {
                // empty catch block
            }
            String rootName = GitBlit.getString("web.repositoryRootGroupName", "main");
            ProjectModel rootProject = new ProjectModel(rootName, true);
            HashMap<String, ProjectModel> configs = new HashMap<String, ProjectModel>();
            configs.put("", rootProject);
            configs.put(rootProject.name.toLowerCase(), rootProject);
            for (String name : this.projectConfigs.getSubsections("project")) {
                ProjectModel project = name.equalsIgnoreCase(rootName) ? rootProject : new ProjectModel(name);
                project.title = this.projectConfigs.getString("project", name, "title");
                project.description = this.projectConfigs.getString("project", name, "description");
                configs.put(name.toLowerCase(), project);
            }
            this.projectCache.clear();
            this.projectCache.putAll(configs);
        }
        return this.projectCache;
    }

    public List<ProjectModel> getProjectModels(UserModel user, boolean includeUsers) {
        ArrayList<Object> projects;
        Map<String, ProjectModel> configs = this.getProjectConfigs();
        TreeMap<String, ProjectModel> map = new TreeMap<String, ProjectModel>();
        map.put("", configs.get(""));
        for (RepositoryModel model : this.getRepositoryModels(user)) {
            String rootPath = StringUtils.getRootPath(model.name).toLowerCase();
            if (!map.containsKey(rootPath)) {
                ProjectModel project = configs.containsKey(rootPath) ? DeepCopier.copy(configs.get(rootPath)) : new ProjectModel(rootPath);
                map.put(rootPath, project);
            }
            ((ProjectModel)map.get(rootPath)).addRepository(model);
        }
        if (includeUsers) {
            projects = new ArrayList(map.values());
            Collections.sort(projects);
            projects.remove(map.get(""));
            projects.add(0, map.get(""));
        } else {
            projects = new ArrayList();
            ProjectModel root = (ProjectModel)map.remove("");
            for (ProjectModel model : map.values()) {
                if (model.isUserProject()) continue;
                projects.add(model);
            }
            Collections.sort(projects);
            projects.add(0, root);
        }
        return projects;
    }

    public ProjectModel getProjectModel(String name, UserModel user) {
        for (ProjectModel project : this.getProjectModels(user, true)) {
            if (!project.name.equalsIgnoreCase(name)) continue;
            return project;
        }
        return null;
    }

    public ProjectModel getProjectModel(String name) {
        Map<String, ProjectModel> configs = this.getProjectConfigs();
        ProjectModel project = configs.get(name.toLowerCase());
        if (project == null) {
            UserModel user;
            project = new ProjectModel(name);
            if (name.length() > 0 && name.charAt(0) == '~' && (user = this.getUserModel(name.substring(1))) != null) {
                project.title = user.getDisplayName();
                project.description = "personal repositories";
            }
        } else {
            project = DeepCopier.copy(project);
        }
        if (StringUtils.isEmpty(name)) {
            for (String repository : this.getRepositoryList()) {
                if (repository.indexOf(47) != -1) continue;
                project.addRepository(repository);
            }
        } else {
            String folder = name.toLowerCase() + "/";
            for (String repository : this.getRepositoryList()) {
                if (!repository.toLowerCase().startsWith(folder)) continue;
                project.addRepository(repository);
            }
        }
        if (project.repositories.size() == 0) {
            return null;
        }
        return project;
    }

    private StoredConfig getRepositoryConfig(Repository r) {
        try {
            Field f = r.getClass().getDeclaredField("repoConfig");
            f.setAccessible(true);
            StoredConfig config = (StoredConfig)f.get(r);
            return config;
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve \"repoConfig\" via reflection", (Throwable)e);
            return r.getConfig();
        }
    }

    private RepositoryModel loadRepositoryModel(String repositoryName) {
        boolean hasOrigin;
        Repository r = this.getRepository(repositoryName);
        if (r == null) {
            return null;
        }
        RepositoryModel model = new RepositoryModel();
        model.isBare = r.isBare();
        File basePath = GitBlit.getFileOrFolder("git.repositoriesFolder", "git");
        model.name = model.isBare ? FileUtils.getRelativePath(basePath, r.getDirectory()) : FileUtils.getRelativePath(basePath, r.getDirectory().getParentFile());
        model.hasCommits = JGitUtils.hasCommits(r);
        model.lastChange = JGitUtils.getLastChange(r);
        model.projectPath = StringUtils.getFirstPathElement(repositoryName);
        StoredConfig config = r.getConfig();
        boolean bl = hasOrigin = !StringUtils.isEmpty(config.getString("remote", "origin", "url"));
        if (config != null) {
            model.description = this.getConfig(config, "description", "");
            model.owner = this.getConfig(config, "owner", "");
            model.useTickets = this.getConfig(config, "useTickets", false);
            model.useDocs = this.getConfig(config, "useDocs", false);
            model.allowForks = this.getConfig(config, "allowForks", true);
            model.accessRestriction = Constants.AccessRestrictionType.fromName(this.getConfig(config, "accessRestriction", this.settings.getString("git.defaultAccessRestriction", null)));
            model.authorizationControl = Constants.AuthorizationControl.fromName(this.getConfig(config, "authorizationControl", this.settings.getString("git.defaultAuthorizationControl", null)));
            model.verifyCommitter = this.getConfig(config, "verifyCommitter", false);
            model.showRemoteBranches = this.getConfig(config, "showRemoteBranches", hasOrigin);
            model.isFrozen = this.getConfig(config, "isFrozen", false);
            model.showReadme = this.getConfig(config, "showReadme", false);
            model.skipSizeCalculation = this.getConfig(config, "skipSizeCalculation", false);
            model.skipSummaryMetrics = this.getConfig(config, "skipSummaryMetrics", false);
            model.federationStrategy = Constants.FederationStrategy.fromName(this.getConfig(config, "federationStrategy", null));
            model.federationSets = new ArrayList<String>(Arrays.asList(config.getStringList("gitblit", null, "federationSets")));
            model.isFederated = this.getConfig(config, "isFederated", false);
            model.gcThreshold = this.getConfig(config, "gcThreshold", this.settings.getString("git.defaultGarbageCollectionThreshold", "500KB"));
            model.gcPeriod = this.getConfig(config, "gcPeriod", this.settings.getInteger("git.defaultGarbageCollectionPeriod", 7));
            try {
                model.lastGC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(this.getConfig(config, "lastGC", "1970-01-01'T'00:00:00Z"));
            }
            catch (Exception e) {
                model.lastGC = new Date(0L);
            }
            model.maxActivityCommits = this.getConfig(config, "maxActivityCommits", this.settings.getInteger("web.maxActivityCommits", 0));
            model.origin = config.getString("remote", "origin", "url");
            if (model.origin != null) {
                model.origin = model.origin.replace('\\', '/');
            }
            model.preReceiveScripts = new ArrayList<String>(Arrays.asList(config.getStringList("gitblit", null, "preReceiveScript")));
            model.postReceiveScripts = new ArrayList<String>(Arrays.asList(config.getStringList("gitblit", null, "postReceiveScript")));
            model.mailingLists = new ArrayList<String>(Arrays.asList(config.getStringList("gitblit", null, "mailingList")));
            model.indexedBranches = new ArrayList<String>(Arrays.asList(config.getStringList("gitblit", null, "indexBranch")));
            model.customFields = new LinkedHashMap<String, String>();
            for (String aProperty : config.getNames("gitblit", "customFields")) {
                model.customFields.put(aProperty, config.getString("gitblit", "customFields", aProperty));
            }
        }
        model.HEAD = JGitUtils.getHEADRef(r);
        model.availableRefs = JGitUtils.getAvailableHeadTargets(r);
        r.close();
        if (model.origin != null && model.origin.startsWith("file://")) {
            try {
                File repoFolder;
                File folder = new File(new URI(model.origin));
                String originRepo = FileUtils.getRelativePath(GitBlit.getRepositoriesFolder(), folder);
                if (!StringUtils.isEmpty(originRepo) && (repoFolder = new File(GitBlit.getRepositoriesFolder(), originRepo)).exists()) {
                    model.originRepository = originRepo.toLowerCase();
                }
            }
            catch (URISyntaxException e) {
                this.logger.error("Failed to determine fork for " + model, (Throwable)e);
            }
        }
        return model;
    }

    public boolean hasRepository(String repositoryName) {
        return this.hasRepository(repositoryName, false);
    }

    public boolean hasRepository(String repositoryName, boolean caseSensitiveCheck) {
        if (!caseSensitiveCheck && this.settings.getBoolean("git.cacheRepositoryList", true)) {
            return this.repositoryListCache.containsKey(repositoryName.toLowerCase());
        }
        Repository r = this.getRepository(repositoryName, false);
        if (r == null) {
            return false;
        }
        r.close();
        return true;
    }

    public boolean hasFork(String username, String origin) {
        return this.getFork(username, origin) != null;
    }

    public String getFork(String username, String origin) {
        String userProject = "~" + username.toLowerCase();
        if (this.settings.getBoolean("git.cacheRepositoryList", true)) {
            String userPath = userProject + "/";
            HashSet<String> roots = new HashSet<String>();
            roots.add(origin);
            RepositoryModel originModel = this.repositoryListCache.get(origin);
            while (originModel != null) {
                if (!ArrayUtils.isEmpty(originModel.forks)) {
                    for (String fork : originModel.forks) {
                        if (fork.startsWith(userPath)) continue;
                        roots.add(fork);
                    }
                }
                if (originModel.originRepository != null) {
                    roots.add(originModel.originRepository);
                    originModel = this.repositoryListCache.get(originModel.originRepository);
                    continue;
                }
                originModel = null;
            }
            for (String repository : this.repositoryListCache.keySet()) {
                if (!repository.startsWith(userPath)) continue;
                RepositoryModel model = this.repositoryListCache.get(repository);
                if (StringUtils.isEmpty(model.originRepository) || !roots.contains(model.originRepository)) continue;
                return model.name;
            }
        } else {
            ProjectModel project = this.getProjectModel(userProject);
            for (String repository : project.repositories) {
                if (!repository.startsWith(userProject)) continue;
                RepositoryModel model = this.repositoryListCache.get(repository);
                if (!model.originRepository.equalsIgnoreCase(origin)) continue;
                return model.name;
            }
        }
        return null;
    }

    public ForkModel getForkNetwork(String repository) {
        if (this.settings.getBoolean("git.cacheRepositoryList", true)) {
            RepositoryModel model = this.repositoryListCache.get(repository.toLowerCase());
            while (model.originRepository != null) {
                model = this.repositoryListCache.get(model.originRepository);
            }
            ForkModel root = this.getForkModel(model.name);
            return root;
        }
        return null;
    }

    private ForkModel getForkModel(String repository) {
        RepositoryModel model = this.repositoryListCache.get(repository.toLowerCase());
        ForkModel fork = new ForkModel(model);
        if (!ArrayUtils.isEmpty(model.forks)) {
            for (String aFork : model.forks) {
                ForkModel fm = this.getForkModel(aFork);
                fork.forks.add(fm);
            }
        }
        return fork;
    }

    public long calculateSize(RepositoryModel model) {
        if (this.repositorySizeCache.hasCurrent(model.name, model.lastChange)) {
            return this.repositorySizeCache.getObject(model.name);
        }
        File gitDir = RepositoryCache.FileKey.resolve((File)new File(this.repositoriesFolder, model.name), (FS)FS.DETECTED);
        long size = FileUtils.folderSize(gitDir);
        this.repositorySizeCache.updateObject(model.name, model.lastChange, size);
        return size;
    }

    private void closeRepository(String repositoryName) {
        Repository repository = this.getRepository(repositoryName);
        if (repository == null) {
            return;
        }
        RepositoryCache.close((Repository)repository);
        int uses = 2;
        try {
            Field useCnt = Repository.class.getDeclaredField("useCnt");
            useCnt.setAccessible(true);
            uses = ((AtomicInteger)useCnt.get(repository)).get();
        }
        catch (Exception e) {
            this.logger.warn(MessageFormat.format("Failed to reflectively determine use count for repository {0}", repositoryName), (Throwable)e);
        }
        if (uses > 0) {
            this.logger.info(MessageFormat.format("{0}.useCnt={1}, calling close() {2} time(s) to close object and ref databases", repositoryName, uses, uses));
            for (int i = 0; i < uses; ++i) {
                repository.close();
            }
        }
        this.luceneExecutor.close(repositoryName);
    }

    public List<Metric> getRepositoryDefaultMetrics(RepositoryModel model, Repository repository) {
        if (this.repositoryMetricsCache.hasCurrent(model.name, model.lastChange)) {
            return new ArrayList<Metric>((Collection)this.repositoryMetricsCache.getObject(model.name));
        }
        List<Metric> metrics = MetricUtils.getDateMetrics(repository, null, true, null, GitBlit.getTimezone());
        this.repositoryMetricsCache.updateObject(model.name, model.lastChange, metrics);
        return new ArrayList<Metric>(metrics);
    }

    private String getConfig(StoredConfig config, String field, String defaultValue) {
        String value = config.getString("gitblit", null, field);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    private boolean getConfig(StoredConfig config, String field, boolean defaultValue) {
        return config.getBoolean("gitblit", field, defaultValue);
    }

    private int getConfig(StoredConfig config, String field, int defaultValue) {
        String value = config.getString("gitblit", null, field);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void updateRepositoryModel(String repositoryName, RepositoryModel repository, boolean isCreate) throws GitBlitException {
        if (this.gcExecutor.isCollectingGarbage(repositoryName)) {
            throw new GitBlitException(MessageFormat.format("sorry, Gitblit is busy collecting garbage in {0}", repositoryName));
        }
        Repository r = null;
        String projectPath = StringUtils.getFirstPathElement(repository.name);
        if (!StringUtils.isEmpty(projectPath) && projectPath.equalsIgnoreCase(GitBlit.getString("web.repositoryRootGroupName", "main"))) {
            repository.name = repository.name.substring(projectPath.length() + 1);
        }
        if (isCreate) {
            if (!repository.name.toLowerCase().endsWith(".git")) {
                repository.name = repository.name + ".git";
            }
            if (this.hasRepository(repository.name)) {
                throw new GitBlitException(MessageFormat.format("Can not create repository ''{0}'' because it already exists.", repository.name));
            }
            this.logger.info("create repository " + repository.name);
            r = JGitUtils.createRepository(this.repositoriesFolder, repository.name);
        } else {
            if (!repositoryName.equalsIgnoreCase(repository.name)) {
                RepositoryModel origin;
                if (!repository.name.toLowerCase().endsWith(".git")) {
                    repository.name = repository.name + ".git";
                }
                if (new File(this.repositoriesFolder, repository.name).exists()) {
                    throw new GitBlitException(MessageFormat.format("Failed to rename ''{0}'' because ''{1}'' already exists.", repositoryName, repository.name));
                }
                this.closeRepository(repositoryName);
                File folder = new File(this.repositoriesFolder, repositoryName);
                File destFolder = new File(this.repositoriesFolder, repository.name);
                if (destFolder.exists()) {
                    throw new GitBlitException(MessageFormat.format("Can not rename repository ''{0}'' to ''{1}'' because ''{1}'' already exists.", repositoryName, repository.name));
                }
                File parentFile = destFolder.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new GitBlitException(MessageFormat.format("Failed to create folder ''{0}''", parentFile.getAbsolutePath()));
                }
                if (!folder.renameTo(destFolder)) {
                    throw new GitBlitException(MessageFormat.format("Failed to rename repository ''{0}'' to ''{1}''.", repositoryName, repository.name));
                }
                if (!this.userService.renameRepositoryRole(repositoryName, repository.name)) {
                    throw new GitBlitException(MessageFormat.format("Failed to rename repository permissions ''{0}'' to ''{1}''.", repositoryName, repository.name));
                }
                if (!ArrayUtils.isEmpty(repository.forks)) {
                    for (String fork : repository.forks) {
                        Repository rf = this.getRepository(fork);
                        try {
                            StoredConfig config = rf.getConfig();
                            String origin2 = config.getString("remote", "origin", "url");
                            origin2 = origin2.replace(repositoryName, repository.name);
                            config.setString("remote", "origin", "url", origin2);
                            config.save();
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to update repository fork config for " + fork, (Throwable)e);
                        }
                        rf.close();
                    }
                }
                if (!StringUtils.isEmpty(repository.originRepository) && (origin = this.repositoryListCache.get(repository.originRepository)) != null && !ArrayUtils.isEmpty(origin.forks)) {
                    origin.forks.remove(repositoryName);
                }
                this.clearRepositoryMetadataCache(repositoryName);
                repository.resetDisplayName();
            }
            this.logger.info("edit repository " + repository.name);
            r = this.getRepository(repository.name);
        }
        if (r != null) {
            this.updateConfiguration(r, repository);
            String currentRef = JGitUtils.getHEADRef(r);
            if (!StringUtils.isEmpty(repository.HEAD) && !repository.HEAD.equals(currentRef)) {
                this.logger.info(MessageFormat.format("Relinking {0} HEAD from {1} to {2}", repository.name, currentRef, repository.HEAD));
                if (JGitUtils.setHEADtoRef(r, repository.HEAD)) {
                    this.clearRepositoryMetadataCache(repository.name);
                }
            }
            r.close();
        }
        this.removeFromCachedRepositoryList(repositoryName);
        this.addToCachedRepositoryList(repository);
    }

    public void updateConfiguration(Repository r, RepositoryModel repository) {
        StoredConfig config = r.getConfig();
        config.setString("gitblit", null, "description", repository.description);
        config.setString("gitblit", null, "owner", repository.owner);
        config.setBoolean("gitblit", null, "useTickets", repository.useTickets);
        config.setBoolean("gitblit", null, "useDocs", repository.useDocs);
        config.setBoolean("gitblit", null, "allowForks", repository.allowForks);
        config.setString("gitblit", null, "accessRestriction", repository.accessRestriction.name());
        config.setString("gitblit", null, "authorizationControl", repository.authorizationControl.name());
        config.setBoolean("gitblit", null, "verifyCommitter", repository.verifyCommitter);
        config.setBoolean("gitblit", null, "showRemoteBranches", repository.showRemoteBranches);
        config.setBoolean("gitblit", null, "isFrozen", repository.isFrozen);
        config.setBoolean("gitblit", null, "showReadme", repository.showReadme);
        config.setBoolean("gitblit", null, "skipSizeCalculation", repository.skipSizeCalculation);
        config.setBoolean("gitblit", null, "skipSummaryMetrics", repository.skipSummaryMetrics);
        config.setString("gitblit", null, "federationStrategy", repository.federationStrategy.name());
        config.setBoolean("gitblit", null, "isFederated", repository.isFederated);
        config.setString("gitblit", null, "gcThreshold", repository.gcThreshold);
        if (repository.gcPeriod == this.settings.getInteger("git.defaultGarbageCollectionPeriod", 7)) {
            config.unset("gitblit", null, "gcPeriod");
        } else {
            config.setInt("gitblit", null, "gcPeriod", repository.gcPeriod);
        }
        if (repository.lastGC != null) {
            config.setString("gitblit", null, "lastGC", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(repository.lastGC));
        }
        if (repository.maxActivityCommits == this.settings.getInteger("web.maxActivityCommits", 0)) {
            config.unset("gitblit", null, "maxActivityCommits");
        } else {
            config.setInt("gitblit", null, "maxActivityCommits", repository.maxActivityCommits);
        }
        this.updateList(config, "federationSets", repository.federationSets);
        this.updateList(config, "preReceiveScript", repository.preReceiveScripts);
        this.updateList(config, "postReceiveScript", repository.postReceiveScripts);
        this.updateList(config, "mailingList", repository.mailingLists);
        this.updateList(config, "indexBranch", repository.indexedBranches);
        if (repository.customFields != null) {
            if (repository.customFields.size() == 0) {
                config.unsetSection("gitblit", "customFields");
            } else {
                for (Map.Entry<String, String> property : repository.customFields.entrySet()) {
                    String key = property.getKey();
                    String value = property.getValue();
                    config.setString("gitblit", "customFields", key, value);
                }
            }
        }
        try {
            config.save();
        }
        catch (IOException e) {
            this.logger.error("Failed to save repository config!", (Throwable)e);
        }
    }

    private void updateList(StoredConfig config, String field, List<String> list) {
        if (list == null) {
            return;
        }
        if (ArrayUtils.isEmpty(list)) {
            config.unset("gitblit", null, field);
        } else {
            config.setStringList("gitblit", null, field, list);
        }
    }

    public boolean deleteRepositoryModel(RepositoryModel model) {
        return this.deleteRepository(model.name);
    }

    public boolean deleteRepository(String repositoryName) {
        try {
            File folder;
            this.closeRepository(repositoryName);
            this.clearRepositoryMetadataCache(repositoryName);
            RepositoryModel model = this.removeFromCachedRepositoryList(repositoryName);
            if (model != null && !ArrayUtils.isEmpty(model.forks)) {
                this.resetRepositoryListCache();
            }
            if ((folder = new File(this.repositoriesFolder, repositoryName)).exists() && folder.isDirectory()) {
                org.eclipse.jgit.util.FileUtils.delete((File)folder, (int)3);
                if (this.userService.deleteRepositoryRole(repositoryName)) {
                    this.logger.info(MessageFormat.format("Repository \"{0}\" deleted", repositoryName));
                    return true;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete repository {0}", repositoryName), t);
        }
        return false;
    }

    public String processCommitMessage(String repositoryName, String text) {
        String html = StringUtils.breakLinesForHtml(text);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.settings.getBoolean("regex.global", false)) {
            for (String key : this.settings.getAllKeys("regex.global")) {
                if (key.equals("regex.global")) continue;
                String string = key.substring(key.lastIndexOf(46) + 1);
                map.put(string, this.settings.getString(key, ""));
            }
        }
        List<String> keys = this.settings.getAllKeys("regex." + repositoryName.toLowerCase());
        for (String string : keys) {
            String subKey = string.substring(string.lastIndexOf(46) + 1);
            map.put(subKey, this.settings.getString(string, ""));
        }
        for (Map.Entry entry : map.entrySet()) {
            String definition = ((String)entry.getValue()).trim();
            String[] chunks = definition.split("!!!");
            if (chunks.length == 2) {
                html = html.replaceAll(chunks[0], chunks[1]);
                continue;
            }
            this.logger.warn((String)entry.getKey() + " improperly formatted.  Use !!! to separate match from replacement: " + definition);
        }
        return html;
    }

    public ScheduledExecutorService executor() {
        return this.scheduledExecutor;
    }

    public static boolean canFederate() {
        String passphrase = GitBlit.getString("federation.passphrase", "");
        return !StringUtils.isEmpty(passphrase);
    }

    private void configureFederation() {
        List<FederationModel> registrations;
        boolean validPassphrase = true;
        String passphrase = this.settings.getString("federation.passphrase", "");
        if (StringUtils.isEmpty(passphrase)) {
            this.logger.warn("Federation passphrase is blank! This server can not be PULLED from.");
            validPassphrase = false;
        }
        if (validPassphrase) {
            for (Constants.FederationToken tokenType : Constants.FederationToken.values()) {
                this.logger.info(MessageFormat.format("Federation {0} token = {1}", tokenType.name(), this.getFederationToken(tokenType)));
            }
            for (String set : this.settings.getStrings("federation.sets")) {
                this.logger.info(MessageFormat.format("Federation Set {0} token = {1}", set, this.getFederationToken(set)));
            }
        }
        if ((registrations = this.getFederationRegistrations()).size() > 0) {
            FederationPullExecutor executor = new FederationPullExecutor(registrations, true);
            this.scheduledExecutor.schedule(executor, 1L, TimeUnit.MINUTES);
        }
    }

    public List<FederationModel> getFederationRegistrations() {
        if (this.federationRegistrations.isEmpty()) {
            this.federationRegistrations.addAll(FederationUtils.getFederationRegistrations(this.settings));
        }
        return this.federationRegistrations;
    }

    public FederationModel getFederationRegistration(String url, String name) {
        for (FederationModel r : this.getFederationRegistrations()) {
            if (!r.name.equals(name) || !r.url.equals(url)) continue;
            return r;
        }
        for (FederationModel r : this.getFederationResultRegistrations()) {
            if (!r.name.equals(name) || !r.url.equals(url)) continue;
            return r;
        }
        return null;
    }

    public List<FederationSet> getFederationSets(String gitblitUrl) {
        ArrayList<FederationSet> list = new ArrayList<FederationSet>();
        for (Constants.FederationToken type : Constants.FederationToken.values()) {
            FederationSet fset = new FederationSet(type.toString(), type, this.getFederationToken(type));
            fset.repositories = this.getRepositories(gitblitUrl, fset.token);
            list.add(fset);
        }
        for (String set : this.settings.getStrings("federation.sets")) {
            FederationSet fset = new FederationSet(set, Constants.FederationToken.REPOSITORIES, this.getFederationToken(set));
            fset.repositories = this.getRepositories(gitblitUrl, fset.token);
            list.add(fset);
        }
        return list;
    }

    public List<String> getFederationTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        for (Constants.FederationToken type : Constants.FederationToken.values()) {
            tokens.add(this.getFederationToken(type));
        }
        for (String set : this.settings.getStrings("federation.sets")) {
            tokens.add(this.getFederationToken(set));
        }
        return tokens;
    }

    public String getFederationToken(Constants.FederationToken type) {
        return this.getFederationToken(type.name());
    }

    public String getFederationToken(String value) {
        String passphrase = this.settings.getString("federation.passphrase", "");
        return StringUtils.getSHA1(passphrase + "-" + value);
    }

    public boolean validateFederationRequest(Constants.FederationRequest req, String token) {
        String all = this.getFederationToken(Constants.FederationToken.ALL);
        String unr = this.getFederationToken(Constants.FederationToken.USERS_AND_REPOSITORIES);
        String jur = this.getFederationToken(Constants.FederationToken.REPOSITORIES);
        switch (req) {
            case PULL_REPOSITORIES: {
                return token.equals(all) || token.equals(unr) || token.equals(jur);
            }
            case PULL_USERS: 
            case PULL_TEAMS: {
                return token.equals(all) || token.equals(unr);
            }
            case PULL_SETTINGS: 
            case PULL_SCRIPTS: {
                return token.equals(all);
            }
        }
        return false;
    }

    public boolean acknowledgeFederationStatus(String identification, FederationModel registration) {
        registration.url = identification;
        String id = identification;
        if (!StringUtils.isEmpty(registration.folder)) {
            id = id + "-" + registration.folder;
        }
        this.federationPullResults.put(id, registration);
        return true;
    }

    public List<FederationModel> getFederationResultRegistrations() {
        return new ArrayList<FederationModel>(this.federationPullResults.values());
    }

    public boolean submitFederationProposal(FederationProposal proposal, String gitblitUrl) {
        String json = JsonUtils.toJsonString(proposal);
        try {
            File proposalsFolder = GitBlit.getProposalsFolder();
            proposalsFolder.mkdirs();
            File file = new File(proposalsFolder, proposal.token + ".json");
            FileUtils.writeContent(file, json);
        }
        catch (Exception e) {
            this.logger.error(MessageFormat.format("Failed to cache proposal from {0}", proposal.url), (Throwable)e);
        }
        try {
            Message message = this.mailExecutor.createMessageForAdministrators();
            if (message != null) {
                message.setSubject("Federation proposal from " + proposal.url);
                message.setText("Please review the proposal @ " + gitblitUrl + "/proposal/" + proposal.token);
                this.mailExecutor.queue(message);
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to notify administrators of proposal", t);
        }
        return true;
    }

    public List<FederationProposal> getPendingFederationProposals() {
        ArrayList<FederationProposal> list = new ArrayList<FederationProposal>();
        File folder = GitBlit.getProposalsFolder();
        if (folder.exists()) {
            File[] files;
            for (File file : files = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".json");
                }
            })) {
                String json = FileUtils.readContent(file, null);
                FederationProposal proposal = JsonUtils.fromJsonString(json, FederationProposal.class);
                list.add(proposal);
            }
        }
        return list;
    }

    public Map<String, RepositoryModel> getRepositories(String gitblitUrl, String token) {
        HashMap<String, String> federationSets = new HashMap<String, String>();
        for (String set : GitBlit.getStrings("federation.sets")) {
            federationSets.put(this.getFederationToken(set), set);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(gitblitUrl);
        sb.append("/git/");
        sb.append("{0}");
        String cloneUrl = sb.toString();
        UserModel user = new UserModel("$gitblit");
        user.canAdmin = true;
        List<RepositoryModel> list = this.getRepositoryModels(user);
        HashMap<String, RepositoryModel> repositories = new HashMap<String, RepositoryModel>();
        block5: for (RepositoryModel model : list) {
            String url = MessageFormat.format(cloneUrl, model.name);
            switch (model.federationStrategy) {
                case EXCLUDE: {
                    continue block5;
                }
                case FEDERATE_ORIGIN: {
                    if (StringUtils.isEmpty(model.origin)) break;
                    url = model.origin;
                    break;
                }
            }
            if (federationSets.containsKey(token)) {
                String set = (String)federationSets.get(token);
                if (!model.federationSets.contains(set)) continue;
                repositories.put(url, model);
                continue;
            }
            repositories.put(url, model);
        }
        return repositories;
    }

    public FederationProposal createFederationProposal(String gitblitUrl, String token) {
        Constants.FederationToken tokenType = Constants.FederationToken.REPOSITORIES;
        for (Constants.FederationToken type : Constants.FederationToken.values()) {
            if (!token.equals(this.getFederationToken(type))) continue;
            tokenType = type;
            break;
        }
        Map<String, RepositoryModel> repositories = this.getRepositories(gitblitUrl, token);
        FederationProposal proposal = new FederationProposal(gitblitUrl, tokenType, token, repositories);
        return proposal;
    }

    public FederationProposal getPendingFederationProposal(String token) {
        List<FederationProposal> list = this.getPendingFederationProposals();
        for (FederationProposal proposal : list) {
            if (!proposal.token.equals(token)) continue;
            return proposal;
        }
        return null;
    }

    public boolean deletePendingFederationProposal(FederationProposal proposal) {
        File folder = GitBlit.getProposalsFolder();
        File file = new File(folder, proposal.token + ".json");
        return file.delete();
    }

    public List<String> getAllScripts() {
        File groovyFolder = GitBlit.getGroovyScriptsFolder();
        File[] files = groovyFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".groovy");
            }
        });
        ArrayList<String> scripts = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                String script = file.getName().substring(0, file.getName().lastIndexOf(46));
                scripts.add(script);
            }
        }
        return scripts;
    }

    public List<String> getPreReceiveScriptsInherited(RepositoryModel repository) {
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        for (String script : GitBlit.getStrings("groovy.preReceiveScripts")) {
            if (script.endsWith(".groovy")) {
                scripts.add(script.substring(0, script.lastIndexOf(46)));
                continue;
            }
            scripts.add(script);
        }
        if (repository != null) {
            for (String teamname : this.userService.getTeamnamesForRepositoryRole(repository.name)) {
                TeamModel team = this.userService.getTeamModel(teamname);
                scripts.addAll(team.preReceiveScripts);
            }
        }
        return new ArrayList<String>(scripts);
    }

    public List<String> getPreReceiveScriptsUnused(RepositoryModel repository) {
        TreeSet<String> inherited = new TreeSet<String>(this.getPreReceiveScriptsInherited(repository));
        ArrayList<String> scripts = new ArrayList<String>();
        for (String script : this.getAllScripts()) {
            if (inherited.contains(script)) continue;
            scripts.add(script);
        }
        return scripts;
    }

    public List<String> getPostReceiveScriptsInherited(RepositoryModel repository) {
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        for (String script : GitBlit.getStrings("groovy.postReceiveScripts")) {
            if (script.endsWith(".groovy")) {
                scripts.add(script.substring(0, script.lastIndexOf(46)));
                continue;
            }
            scripts.add(script);
        }
        if (repository != null) {
            for (String teamname : this.userService.getTeamnamesForRepositoryRole(repository.name)) {
                TeamModel team = this.userService.getTeamModel(teamname);
                scripts.addAll(team.postReceiveScripts);
            }
        }
        return new ArrayList<String>(scripts);
    }

    public List<String> getPostReceiveScriptsUnused(RepositoryModel repository) {
        TreeSet<String> inherited = new TreeSet<String>(this.getPostReceiveScriptsInherited(repository));
        ArrayList<String> scripts = new ArrayList<String>();
        for (String script : this.getAllScripts()) {
            if (inherited.contains(script)) continue;
            scripts.add(script);
        }
        return scripts;
    }

    public List<SearchResult> search(String query, int page, int pageSize, List<String> repositories) {
        List<SearchResult> srs = this.luceneExecutor.search(query, page, pageSize, repositories);
        return srs;
    }

    public void sendMailToAdministrators(String subject, String message) {
        try {
            Message mail2 = this.mailExecutor.createMessageForAdministrators();
            if (mail2 != null) {
                mail2.setSubject(subject);
                mail2.setText(message);
                this.mailExecutor.queue(mail2);
            }
        }
        catch (MessagingException e) {
            this.logger.error("Messaging error", (Throwable)e);
        }
    }

    public void sendMail(String subject, String message, Collection<String> toAddresses) {
        this.sendMail(subject, message, toAddresses.toArray(new String[0]));
    }

    public void sendMail(String subject, String message, String ... toAddresses) {
        try {
            Message mail2 = this.mailExecutor.createMessage(toAddresses);
            if (mail2 != null) {
                mail2.setSubject(subject);
                mail2.setText(message);
                this.mailExecutor.queue(mail2);
            }
        }
        catch (MessagingException e) {
            this.logger.error("Messaging error", (Throwable)e);
        }
    }

    public void sendHtmlMail(String subject, String message, Collection<String> toAddresses) {
        this.sendHtmlMail(subject, message, toAddresses.toArray(new String[0]));
    }

    public void sendHtmlMail(String subject, String message, String ... toAddresses) {
        try {
            Message mail2 = this.mailExecutor.createMessage(toAddresses);
            if (mail2 != null) {
                mail2.setSubject(subject);
                mail2.setContent((Object)message, "text/html");
                this.mailExecutor.queue(mail2);
            }
        }
        catch (MessagingException e) {
            this.logger.error("Messaging error", (Throwable)e);
        }
    }

    public ServerSettings getSettingsModel() {
        for (String key : this.settings.getAllKeys(null)) {
            SettingModel setting = this.settingsModel.get(key);
            if (setting == null) {
                setting = new SettingModel();
                setting.name = key;
                this.settingsModel.add(setting);
            }
            setting.currentValue = this.settings.getString(key, "");
        }
        this.settingsModel.pushScripts = this.getAllScripts();
        return this.settingsModel;
    }

    private ServerSettings loadSettingModels(InputStream referencePropertiesInputStream) {
        ServerSettings settingsModel = new ServerSettings();
        settingsModel.supportsCredentialChanges = this.userService.supportsCredentialChanges();
        settingsModel.supportsDisplayNameChanges = this.userService.supportsDisplayNameChanges();
        settingsModel.supportsEmailAddressChanges = this.userService.supportsEmailAddressChanges();
        settingsModel.supportsTeamMembershipChanges = this.userService.supportsTeamMembershipChanges();
        try {
            InputStream is = referencePropertiesInputStream;
            BufferedReader propertiesReader = new BufferedReader(new InputStreamReader(is));
            StringBuilder description = new StringBuilder();
            SettingModel setting = new SettingModel();
            String line = null;
            while ((line = propertiesReader.readLine()) != null) {
                String key;
                if (line.length() == 0) {
                    description.setLength(0);
                    setting = new SettingModel();
                    continue;
                }
                if (line.charAt(0) == '#') {
                    if (line.length() <= 1) continue;
                    String text = line.substring(1).trim();
                    if ("CASE-SENSITIVE".equals(text)) {
                        setting.caseSensitive = true;
                        continue;
                    }
                    if ("RESTART REQUIRED".equals(text)) {
                        setting.restartRequired = true;
                        continue;
                    }
                    if ("SPACE-DELIMITED".equals(text)) {
                        setting.spaceDelimited = true;
                        continue;
                    }
                    if (text.startsWith("SINCE")) {
                        try {
                            setting.since = text.split(" ")[1];
                        }
                        catch (Exception e) {
                            setting.since = text;
                        }
                        continue;
                    }
                    description.append(text);
                    description.append('\n');
                    continue;
                }
                String[] kvp = line.split("=", 2);
                setting.name = key = kvp[0].trim();
                setting.currentValue = setting.defaultValue = kvp[1].trim();
                setting.description = description.toString().trim();
                settingsModel.add(setting);
                description.setLength(0);
                setting = new SettingModel();
            }
            propertiesReader.close();
        }
        catch (NullPointerException e) {
            this.logger.error("Failed to find resource copy of gitblit.properties");
        }
        catch (IOException e) {
            this.logger.error("Failed to load resource copy of gitblit.properties");
        }
        return settingsModel;
    }

    public void configureContext(IStoredSettings settings, boolean startFederation) {
        this.logger.info("Reading configuration from " + settings.toString());
        this.settings = settings;
        this.repositoriesFolder = GitBlit.getRepositoriesFolder();
        this.logger.info("Git repositories folder " + this.repositoriesFolder.getAbsolutePath());
        this.mailExecutor = new MailExecutor(settings);
        this.luceneExecutor = new LuceneExecutor(settings, this.repositoriesFolder);
        this.gcExecutor = new GCExecutor(settings);
        this.repositoryListSettingsChecksum.set(this.getRepositoryListSettingsChecksum());
        if (settings.getBoolean("git.cacheRepositoryList", true)) {
            this.logger.info("Identifying available repositories...");
            this.getRepositoryList();
        }
        this.logTimezone("JVM", TimeZone.getDefault());
        this.logTimezone("Gitblit", GitBlit.getTimezone());
        this.serverStatus = new ServerStatus(GitBlit.isGO());
        if (this.userService == null) {
            String realm2 = settings.getString("realm.userService", "users.properties");
            IUserService loginService = null;
            try {
                Class<?> realmClass = Class.forName(realm2);
                loginService = (IUserService)realmClass.newInstance();
            }
            catch (Throwable t) {
                loginService = new GitblitUserService();
            }
            this.setUserService(loginService);
        }
        this.projectConfigs = new FileBasedConfig(GitBlit.getFileOrFolder("web.projectsFile", "projects.conf"), FS.detect());
        this.getProjectConfigs();
        if (this.mailExecutor.isReady()) {
            this.logger.info("Mail executor is scheduled to process the message queue every 2 minutes.");
            this.scheduledExecutor.scheduleAtFixedRate(this.mailExecutor, 1L, 2L, TimeUnit.MINUTES);
        } else {
            this.logger.warn("Mail server is not properly configured.  Mail services disabled.");
        }
        this.logger.info("Lucene executor is scheduled to process indexed branches every 2 minutes.");
        this.scheduledExecutor.scheduleAtFixedRate(this.luceneExecutor, 1L, 2L, TimeUnit.MINUTES);
        if (this.gcExecutor.isReady()) {
            this.logger.info("GC executor is scheduled to scan repositories every 24 hours.");
            Calendar c = Calendar.getInstance();
            c.set(11, settings.getInteger("git.garbageCollectionHour", 0));
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            Date cd = c.getTime();
            Date now = new Date();
            int delay = 0;
            if (cd.before(now)) {
                c.add(5, 1);
                cd = c.getTime();
            }
            delay = (int)((cd.getTime() - now.getTime()) / 60000L);
            String when = delay + " mins";
            if (delay > 60) {
                when = MessageFormat.format("{0,number,0.0} hours", Float.valueOf((float)delay / 60.0f));
            }
            this.logger.info(MessageFormat.format("Next scheculed GC scan is in {0}", when));
            this.scheduledExecutor.scheduleAtFixedRate(this.gcExecutor, delay, 1440L, TimeUnit.MINUTES);
        }
        if (startFederation) {
            this.configureFederation();
        }
        WindowCacheConfig cfg = new WindowCacheConfig();
        cfg.setPackedGitWindowSize(settings.getFilesize("git.packedGitWindowSize", cfg.getPackedGitWindowSize()));
        cfg.setPackedGitLimit(settings.getFilesize("git.packedGitLimit", cfg.getPackedGitLimit()));
        cfg.setDeltaBaseCacheLimit(settings.getFilesize("git.deltaBaseCacheLimit", cfg.getDeltaBaseCacheLimit()));
        cfg.setPackedGitOpenFiles(settings.getFilesize("git.packedGitOpenFiles", cfg.getPackedGitOpenFiles()));
        cfg.setStreamFileThreshold(settings.getFilesize("git.streamFileThreshold", cfg.getStreamFileThreshold()));
        cfg.setPackedGitMMAP(settings.getBoolean("git.packedGitMmap", cfg.isPackedGitMMAP()));
        try {
            WindowCache.reconfigure((WindowCacheConfig)cfg);
            this.logger.debug(MessageFormat.format("{0} = {1,number,0}", "git.packedGitWindowSize", cfg.getPackedGitWindowSize()));
            this.logger.debug(MessageFormat.format("{0} = {1,number,0}", "git.packedGitLimit", cfg.getPackedGitLimit()));
            this.logger.debug(MessageFormat.format("{0} = {1,number,0}", "git.deltaBaseCacheLimit", cfg.getDeltaBaseCacheLimit()));
            this.logger.debug(MessageFormat.format("{0} = {1,number,0}", "git.packedGitOpenFiles", cfg.getPackedGitOpenFiles()));
            this.logger.debug(MessageFormat.format("{0} = {1,number,0}", "git.streamFileThreshold", cfg.getStreamFileThreshold()));
            this.logger.debug(MessageFormat.format("{0} = {1}", "git.packedGitMmap", cfg.isPackedGitMMAP()));
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Failed to configure JGit parameters!", (Throwable)e);
        }
        ContainerUtils.CVE_2007_0450.test();
    }

    private void logTimezone(String type, TimeZone zone) {
        SimpleDateFormat df = new SimpleDateFormat("z Z");
        df.setTimeZone(zone);
        String offset = df.format(new Date());
        this.logger.info(type + " timezone is " + zone.getID() + " (" + offset + ")");
    }

    public void contextInitialized(ServletContextEvent contextEvent) {
        this.contextInitialized(contextEvent, contextEvent.getServletContext().getResourceAsStream("/WEB-INF/reference.properties"));
    }

    public void contextInitialized(ServletContextEvent contextEvent, InputStream referencePropertiesInputStream) {
        this.servletContext = contextEvent.getServletContext();
        if (this.settings == null) {
            File includedScripts;
            File overrideFile;
            ServletContext context = contextEvent.getServletContext();
            WebXmlSettings webxmlSettings = new WebXmlSettings(context);
            String webProps = context.getRealPath("/WEB-INF/gitblit.properties");
            if (!StringUtils.isEmpty(webProps)) {
                overrideFile = new File(webProps);
                webxmlSettings.applyOverrides(overrideFile);
            }
            if (!(overrideFile = GitBlit.getFileOrFolder("gitblit.properties")).getPath().equals("gitblit.properties")) {
                webxmlSettings.applyOverrides(overrideFile);
            }
            this.configureContext(webxmlSettings, true);
            File localScripts = GitBlit.getFileOrFolder("groovy.scriptsFolder", "groovy");
            if (!localScripts.exists() && !(includedScripts = new File(context.getRealPath("/WEB-INF/groovy"))).equals(localScripts)) {
                try {
                    FileUtils.copy(localScripts, includedScripts.listFiles());
                }
                catch (IOException e) {
                    this.logger.error(MessageFormat.format("Failed to copy included Groovy scripts from {0} to {1}", includedScripts, localScripts));
                }
            }
        }
        this.settingsModel = this.loadSettingModels(referencePropertiesInputStream);
        this.serverStatus.servletContainer = this.servletContext.getServerInfo();
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        this.logger.info("Gitblit context destroyed by servlet container.");
        this.scheduledExecutor.shutdownNow();
        this.luceneExecutor.close();
        this.gcExecutor.close();
    }

    public boolean isCollectingGarbage() {
        return this.gcExecutor.isRunning();
    }

    public boolean isCollectingGarbage(String repositoryName) {
        return this.gcExecutor.isCollectingGarbage(repositoryName);
    }

    public RepositoryModel fork(RepositoryModel repository, UserModel user) throws GitBlitException {
        UserModel originOwner;
        String cloneName = MessageFormat.format("~{0}/{1}.git", user.username, StringUtils.stripDotGit(StringUtils.getLastPathElement(repository.name)));
        String fromUrl = MessageFormat.format("file://{0}/{1}", this.repositoriesFolder.getAbsolutePath(), repository.name);
        try {
            JGitUtils.cloneRepository(this.repositoriesFolder, cloneName, fromUrl, true, null);
        }
        catch (Exception e) {
            throw new GitBlitException(e);
        }
        RepositoryModel cloneModel = repository.cloneAs(cloneName);
        cloneModel.owner = user.username;
        this.updateRepositoryModel(cloneName, cloneModel, false);
        if (!StringUtils.isEmpty(repository.owner) && (originOwner = this.getUserModel(repository.owner)) != null) {
            originOwner.setRepositoryPermission(cloneName, Constants.AccessPermission.CLONE);
            this.updateUserModel(originOwner.username, originOwner, false);
        }
        List<String> users = this.getRepositoryUsers(repository);
        ArrayList<UserModel> cloneUsers = new ArrayList<UserModel>();
        for (String name : users) {
            if (name.equalsIgnoreCase(user.username)) continue;
            UserModel cloneUser = this.getUserModel(name);
            if (cloneUser.canClone(repository)) {
                cloneUser.setRepositoryPermission(cloneName, Constants.AccessPermission.CLONE);
            }
            cloneUsers.add(cloneUser);
        }
        this.userService.updateUserModels(cloneUsers);
        List<String> teams = this.getRepositoryTeams(repository);
        ArrayList<TeamModel> cloneTeams = new ArrayList<TeamModel>();
        for (String name : teams) {
            TeamModel cloneTeam = this.getTeamModel(name);
            if (cloneTeam.canClone(repository)) {
                cloneTeam.setRepositoryPermission(cloneName, Constants.AccessPermission.CLONE);
            }
            cloneTeams.add(cloneTeam);
        }
        this.userService.updateTeamModels(cloneTeams);
        this.addToCachedRepositoryList(cloneModel);
        return cloneModel;
    }

    public boolean allowCookieAuthentication() {
        return GitBlit.getBoolean("web.allowCookieAuthentication", true) && this.userService.supportsCookies();
    }
}

