/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.AccessRestrictionFilter;
import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.GitBlitException;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import java.text.MessageFormat;

public class GitFilter
extends AccessRestrictionFilter {
    protected static final String gitReceivePack = "/git-receive-pack";
    protected static final String gitUploadPack = "/git-upload-pack";
    protected static final String[] suffixes = new String[]{"/git-receive-pack", "/git-upload-pack", "/info/refs", "/HEAD", "/objects"};

    public static String getRepositoryName(String value) {
        String repository = value;
        for (String urlSuffix : suffixes) {
            if (repository.indexOf(urlSuffix) <= -1) continue;
            repository = repository.substring(0, repository.indexOf(urlSuffix));
        }
        return repository;
    }

    @Override
    protected String extractRepositoryName(String url) {
        return GitFilter.getRepositoryName(url);
    }

    @Override
    protected String getUrlRequestAction(String suffix) {
        if (!StringUtils.isEmpty(suffix)) {
            if (suffix.startsWith(gitReceivePack)) {
                return gitReceivePack;
            }
            if (suffix.startsWith(gitUploadPack)) {
                return gitUploadPack;
            }
            if (suffix.contains("?service=git-receive-pack")) {
                return gitReceivePack;
            }
            if (suffix.contains("?service=git-upload-pack")) {
                return gitUploadPack;
            }
            return gitUploadPack;
        }
        return null;
    }

    @Override
    protected boolean isCreationAllowed() {
        return GitBlit.getBoolean("git.allowCreateOnPush", true);
    }

    @Override
    protected boolean isActionAllowed(RepositoryModel repository, String action) {
        if (!StringUtils.isEmpty(action) && action.equals(gitReceivePack) && !repository.isBare) {
            this.logger.warn("Gitblit does not allow pushes to repositories with a working copy");
            return false;
        }
        return true;
    }

    @Override
    protected boolean requiresClientCertificate() {
        return GitBlit.getBoolean("git.requiresClientCertificate", false);
    }

    @Override
    protected boolean requiresAuthentication(RepositoryModel repository, String action) {
        if (gitUploadPack.equals(action)) {
            return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.CLONE);
        }
        if (gitReceivePack.equals(action)) {
            return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.PUSH);
        }
        return false;
    }

    @Override
    protected boolean canAccess(RepositoryModel repository, UserModel user, String action) {
        if (!GitBlit.getBoolean("git.enableGitServlet", true)) {
            return false;
        }
        if (action.equals(gitReceivePack)) {
            if (user.canPush(repository)) {
                return true;
            }
            this.logger.warn(MessageFormat.format("user {0} is not authorized to push to {1}", user.username, repository));
            return false;
        }
        if (action.equals(gitUploadPack)) {
            if (user.canClone(repository)) {
                return true;
            }
            this.logger.warn(MessageFormat.format("user {0} is not authorized to clone {1}", user.username, repository));
            return false;
        }
        return true;
    }

    @Override
    protected RepositoryModel createRepository(UserModel user, String repository, String action) {
        boolean isPush;
        boolean bl = isPush = !StringUtils.isEmpty(action) && gitReceivePack.equals(action);
        if (isPush) {
            if (user.canCreate(repository)) {
                if (repository.startsWith("../")) {
                    this.logger.error(MessageFormat.format("Illegal relative path in repository name! {0}", repository));
                    return null;
                }
                if (repository.contains("/../")) {
                    this.logger.error(MessageFormat.format("Illegal relative path in repository name! {0}", repository));
                    return null;
                }
                Character c = StringUtils.findInvalidCharacter(repository);
                if (c != null) {
                    this.logger.error(MessageFormat.format("Invalid character '{0}' in repository name {1}!", c, repository));
                    return null;
                }
                RepositoryModel model = new RepositoryModel();
                model.name = repository;
                model.owner = user.username;
                model.projectPath = StringUtils.getFirstPathElement(repository);
                if (model.isUsersPersonalRepository(user.username)) {
                    model.authorizationControl = Constants.AuthorizationControl.NAMED;
                    model.accessRestriction = Constants.AccessRestrictionType.VIEW;
                } else {
                    model.authorizationControl = Constants.AuthorizationControl.fromName(GitBlit.getString("git.defaultAuthorizationControl", ""));
                    model.accessRestriction = Constants.AccessRestrictionType.fromName(GitBlit.getString("git.defaultAccessRestriction", ""));
                }
                try {
                    GitBlit.self().updateRepositoryModel(model.name, model, true);
                    this.logger.info(MessageFormat.format("{0} created {1} ON-PUSH", user.username, model.name));
                    return GitBlit.self().getRepositoryModel(model.name);
                }
                catch (GitBlitException e) {
                    this.logger.error(MessageFormat.format("{0} failed to create repository {1} ON-PUSH!", user.username, model.name), (Throwable)e);
                }
            } else {
                this.logger.warn(MessageFormat.format("{0} is not permitted to create repository {1} ON-PUSH!", user.username, repository));
            }
        }
        return null;
    }
}

