/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.GitBlit;
import com.gitblit.GitblitUserService;
import com.gitblit.IStoredSettings;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserService
extends GitblitUserService {
    public static final Logger logger = LoggerFactory.getLogger(LdapUserService.class);
    private IStoredSettings settings;

    @Override
    public void setup(IStoredSettings settings) {
        this.settings = settings;
        String file = settings.getString("realm.ldap.backingUserService", "users.conf");
        File realmFile = GitBlit.getFileOrFolder(file);
        this.serviceImpl = this.createUserService(realmFile);
        logger.info("LDAP User Service backed by " + ((Object)this.serviceImpl).toString());
    }

    private LDAPConnection getLdapConnection() {
        try {
            SSLUtil sslUtil;
            ExtendedResult extendedResult;
            URI ldapUrl = new URI(this.settings.getRequiredString("realm.ldap.server"));
            String bindUserName = this.settings.getString("realm.ldap.username", "");
            String bindPassword = this.settings.getString("realm.ldap.password", "");
            int ldapPort = ldapUrl.getPort();
            if (ldapUrl.getScheme().equalsIgnoreCase("ldaps")) {
                if (ldapPort == -1) {
                    ldapPort = 636;
                }
                SSLUtil sslUtil2 = new SSLUtil((TrustManager)new TrustAllTrustManager());
                return new LDAPConnection((SocketFactory)sslUtil2.createSSLSocketFactory(), ldapUrl.getHost(), ldapPort, bindUserName, bindPassword);
            }
            if (ldapPort == -1) {
                ldapPort = 389;
            }
            LDAPConnection conn = new LDAPConnection(ldapUrl.getHost(), ldapPort, bindUserName, bindPassword);
            if (ldapUrl.getScheme().equalsIgnoreCase("ldap+tls") && (extendedResult = conn.processExtendedOperation((ExtendedRequest)new StartTLSExtendedRequest((sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager())).createSSLContext()))).getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(extendedResult.getResultCode());
            }
            return conn;
        }
        catch (URISyntaxException e) {
            logger.error("Bad LDAP URL, should be in the form: ldap(s|+tls)://<server>:<port>", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            logger.error("Unable to create SSL Connection", (Throwable)e);
        }
        catch (LDAPException e) {
            logger.error("Error Connecting to LDAP", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return StringUtils.isEmpty(this.settings.getString("realm.ldap.displayName", ""));
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return StringUtils.isEmpty(this.settings.getString("realm.ldap.email", ""));
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return !this.settings.getBoolean("realm.ldap.maintainTeams", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserModel authenticate(String username, char[] password) {
        String simpleUsername = this.getSimpleUsername(username);
        LDAPConnection ldapConnection = this.getLdapConnection();
        if (ldapConnection != null) {
            try {
                SearchResultEntry loggingInUser;
                String loggingInUserDN;
                String accountBase = this.settings.getString("realm.ldap.accountBase", "");
                String accountPattern = this.settings.getString("realm.ldap.accountPattern", "(&(objectClass=person)(sAMAccountName=${username}))");
                accountPattern = StringUtils.replace(accountPattern, "${username}", LdapUserService.escapeLDAPSearchFilter(simpleUsername));
                SearchResult result = this.doSearch(ldapConnection, accountBase, accountPattern);
                if (result != null && result.getEntryCount() == 1 && this.isAuthenticated(ldapConnection, loggingInUserDN = (loggingInUser = (SearchResultEntry)result.getSearchEntries().get(0)).getDN(), new String(password))) {
                    logger.debug("LDAP authenticated: " + username);
                    UserModel user = this.getUserModel(simpleUsername);
                    if (user == null) {
                        user = new UserModel(simpleUsername);
                    }
                    if (StringUtils.isEmpty(user.cookie) && !ArrayUtils.isEmpty(password)) {
                        user.cookie = StringUtils.getSHA1(user.username + new String(password));
                    }
                    if (!this.supportsTeamMembershipChanges()) {
                        this.getTeamsFromLdap(ldapConnection, simpleUsername, loggingInUser, user);
                    }
                    this.setUserAttributes(user, loggingInUser);
                    super.updateUserModel(user);
                    if (!this.supportsTeamMembershipChanges()) {
                        for (TeamModel userTeam : user.teams) {
                            this.updateTeamModel(userTeam);
                        }
                    }
                    UserModel userModel = user;
                    return userModel;
                }
            }
            finally {
                ldapConnection.close();
            }
        }
        return null;
    }

    private void setAdminAttribute(UserModel user) {
        List<String> admins;
        if (!this.supportsTeamMembershipChanges() && !ArrayUtils.isEmpty(admins = this.settings.getStrings("realm.ldap.admins"))) {
            user.canAdmin = false;
            for (String admin : admins) {
                if (admin.startsWith("@")) {
                    if (user.getTeam(admin.substring(1)) == null) continue;
                    user.canAdmin = true;
                    continue;
                }
                if (!user.getName().equalsIgnoreCase(admin)) continue;
                user.canAdmin = true;
            }
        }
    }

    private void setUserAttributes(UserModel user, SearchResultEntry userEntry) {
        String email;
        this.setAdminAttribute(user);
        user.password = "StoredInLDAP";
        String displayName = this.settings.getString("realm.ldap.displayName", "");
        if (!StringUtils.isEmpty(displayName)) {
            if (displayName.contains("${")) {
                for (Attribute userAttribute : userEntry.getAttributes()) {
                    displayName = StringUtils.replace(displayName, "${" + userAttribute.getName() + "}", userAttribute.getValue());
                }
                user.displayName = displayName;
            } else {
                Attribute attribute = userEntry.getAttribute(displayName);
                if (attribute != null && attribute.hasValue()) {
                    user.displayName = attribute.getValue();
                }
            }
        }
        if (!StringUtils.isEmpty(email = this.settings.getString("realm.ldap.email", ""))) {
            if (email.contains("${")) {
                for (Attribute userAttribute : userEntry.getAttributes()) {
                    email = StringUtils.replace(email, "${" + userAttribute.getName() + "}", userAttribute.getValue());
                }
                user.emailAddress = email;
            } else {
                Attribute attribute = userEntry.getAttribute(email);
                if (attribute != null && attribute.hasValue()) {
                    user.emailAddress = attribute.getValue();
                }
            }
        }
    }

    private void getTeamsFromLdap(LDAPConnection ldapConnection, String simpleUsername, SearchResultEntry loggingInUser, UserModel user) {
        String loggingInUserDN = loggingInUser.getDN();
        user.teams.clear();
        String groupBase = this.settings.getString("realm.ldap.groupBase", "");
        String groupMemberPattern = this.settings.getString("realm.ldap.groupMemberPattern", "(&(objectClass=group)(member=${dn}))");
        groupMemberPattern = StringUtils.replace(groupMemberPattern, "${dn}", LdapUserService.escapeLDAPSearchFilter(loggingInUserDN));
        groupMemberPattern = StringUtils.replace(groupMemberPattern, "${username}", LdapUserService.escapeLDAPSearchFilter(simpleUsername));
        for (Attribute userAttribute : loggingInUser.getAttributes()) {
            groupMemberPattern = StringUtils.replace(groupMemberPattern, "${" + userAttribute.getName() + "}", LdapUserService.escapeLDAPSearchFilter(userAttribute.getValue()));
        }
        SearchResult teamMembershipResult = this.doSearch(ldapConnection, groupBase, groupMemberPattern);
        if (teamMembershipResult != null && teamMembershipResult.getEntryCount() > 0) {
            for (int i = 0; i < teamMembershipResult.getEntryCount(); ++i) {
                SearchResultEntry teamEntry = (SearchResultEntry)teamMembershipResult.getSearchEntries().get(i);
                String teamName = teamEntry.getAttribute("cn").getValue();
                TeamModel teamModel = this.getTeamModel(teamName);
                if (teamModel == null) {
                    teamModel = this.createTeamFromLdap(teamEntry);
                }
                user.teams.add(teamModel);
                teamModel.addUser(user.getName());
            }
        }
    }

    private TeamModel createTeamFromLdap(SearchResultEntry teamEntry) {
        TeamModel answer = new TeamModel(teamEntry.getAttributeValue("cn"));
        return answer;
    }

    private SearchResult doSearch(LDAPConnection ldapConnection, String base, String filter) {
        try {
            return ldapConnection.search(base, SearchScope.SUB, filter, new String[0]);
        }
        catch (LDAPSearchException e) {
            logger.error("Problem Searching LDAP", (Throwable)e);
            return null;
        }
    }

    private boolean isAuthenticated(LDAPConnection ldapConnection, String userDn, String password) {
        try {
            ldapConnection.bind(userDn, password);
            return true;
        }
        catch (LDAPException e) {
            logger.error("Error authenticating user", (Throwable)e);
            return false;
        }
    }

    protected String getSimpleUsername(String username) {
        int lastSlash = username.lastIndexOf(92);
        if (lastSlash > -1) {
            username = username.substring(lastSlash + 1);
        }
        return username;
    }

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }
}

