/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.GitBlit;
import com.gitblit.GitblitUserService;
import com.gitblit.IStoredSettings;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ConnectionUtils;
import com.gitblit.utils.StringUtils;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedmineUserService
extends GitblitUserService {
    private final Logger logger = LoggerFactory.getLogger(RedmineUserService.class);
    private IStoredSettings settings;
    private String testingJson;

    @Override
    public void setup(IStoredSettings settings) {
        this.settings = settings;
        String file = settings.getString("realm.redmine.backingUserService", "users.conf");
        File realmFile = GitBlit.getFileOrFolder(file);
        this.serviceImpl = this.createUserService(realmFile);
        this.logger.info("Redmine User Service backed by " + ((Object)this.serviceImpl).toString());
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return false;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return false;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return false;
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        String urlText = this.settings.getString("realm.redmine.url", "");
        if (!urlText.endsWith("/")) {
            urlText.concat("/");
        }
        String apiKey = String.valueOf(password);
        try {
            String jsonString = this.getCurrentUserAsJson(urlText, apiKey);
            RedmineCurrent current = (RedmineCurrent)new Gson().fromJson(jsonString, RedmineCurrent.class);
            String login = current.user.login;
            boolean canAdmin = true;
            if (StringUtils.isEmpty(login)) {
                canAdmin = false;
                login = current.user.mail;
            }
            UserModel userModel = new UserModel(login);
            userModel.canAdmin = canAdmin;
            userModel.displayName = current.user.firstname + " " + current.user.lastname;
            userModel.emailAddress = current.user.mail;
            userModel.cookie = StringUtils.getSHA1(userModel.username + new String(password));
            return userModel;
        }
        catch (IOException e) {
            this.logger.error("authenticate", (Throwable)e);
            return null;
        }
    }

    private String getCurrentUserAsJson(String url, String apiKey) throws IOException {
        if (this.testingJson != null) {
            return this.testingJson;
        }
        String apiUrl = url + "users/current.json?key=" + apiKey;
        HttpURLConnection http = (HttpURLConnection)ConnectionUtils.openConnection(apiUrl, null, null);
        http.setRequestMethod("GET");
        http.connect();
        InputStreamReader reader = new InputStreamReader(http.getInputStream());
        return IOUtils.toString((Reader)reader);
    }

    public void setTestingCurrentUserAsJson(String json) {
        this.testingJson = json;
    }

    private class RedmineCurrent {
        public RedmineUser user;

        private RedmineCurrent() {
        }

        private class RedmineUser {
            public String login;
            public String firstname;
            public String lastname;
            public String mail;

            private RedmineUser() {
            }
        }
    }
}

