/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.AuthenticationFilter;
import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SyndicationFilter
extends AuthenticationFilter {
    protected String extractRequestedName(String url) {
        if (url.indexOf(63) > -1) {
            return url.substring(0, url.indexOf(63));
        }
        return url;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String fullUrl = this.getFullUrl(httpRequest);
        String name = this.extractRequestedName(fullUrl);
        ProjectModel project = GitBlit.self().getProjectModel(name);
        RepositoryModel model = null;
        if (project == null && (model = GitBlit.self().getRepositoryModel(name)) == null) {
            this.logger.info(MessageFormat.format("ARF: {0} ({1})", fullUrl, 404));
            httpResponse.sendError(404);
            return;
        }
        AuthenticationFilter.AuthenticatedRequest authenticatedRequest = new AuthenticationFilter.AuthenticatedRequest(httpRequest);
        UserModel user = this.getUser(httpRequest);
        if (user != null) {
            authenticatedRequest.setUser(user);
        }
        if (model != null && model.accessRestriction.atLeast(Constants.AccessRestrictionType.VIEW)) {
            if (user == null) {
                if (GitBlit.isDebugMode()) {
                    this.logger.info(MessageFormat.format("ARF: CHALLENGE {0}", fullUrl));
                }
                httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Gitblit\"");
                httpResponse.sendError(401);
                return;
            }
            if (user.canView(model)) {
                this.newSession(authenticatedRequest, httpResponse);
                this.logger.info(MessageFormat.format("ARF: {0} ({1}) authenticated", fullUrl, 100));
                chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
                return;
            }
            if (GitBlit.isDebugMode()) {
                this.logger.info(MessageFormat.format("ARF: {0} forbidden to access {1}", user.username, fullUrl));
            }
            httpResponse.sendError(403);
            return;
        }
        if (GitBlit.isDebugMode()) {
            this.logger.info(MessageFormat.format("ARF: {0} ({1}) unauthenticated", fullUrl, 100));
        }
        chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
    }
}

