/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.Metric;
import com.gitblit.models.RefModel;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class Activity
implements Serializable,
Comparable<Activity> {
    private static final long serialVersionUID = 1L;
    public final Date startDate;
    public final Date endDate;
    private final Set<RepositoryCommit> commits;
    private final Map<String, Metric> authorMetrics;
    private final Map<String, Metric> repositoryMetrics;

    public Activity(Date date) {
        this(date, 86399999L);
    }

    public Activity(Date date, long duration) {
        this.startDate = date;
        this.endDate = new Date(date.getTime() + duration);
        this.commits = new LinkedHashSet<RepositoryCommit>();
        this.authorMetrics = new HashMap<String, Metric>();
        this.repositoryMetrics = new HashMap<String, Metric>();
    }

    public RepositoryCommit addCommit(String repository, String branch, RevCommit commit) {
        RepositoryCommit commitModel = new RepositoryCommit(repository, branch, commit);
        if (this.commits.add(commitModel)) {
            if (!this.repositoryMetrics.containsKey(repository)) {
                this.repositoryMetrics.put(repository, new Metric(repository));
            }
            this.repositoryMetrics.get((Object)repository).count += 1.0;
            String author = StringUtils.removeNewlines(commit.getAuthorIdent().getEmailAddress()).toLowerCase();
            if (!this.authorMetrics.containsKey(author)) {
                this.authorMetrics.put(author, new Metric(author));
            }
            this.authorMetrics.get((Object)author).count += 1.0;
            return commitModel;
        }
        return null;
    }

    public int getCommitCount() {
        return this.commits.size();
    }

    public List<RepositoryCommit> getCommits() {
        ArrayList<RepositoryCommit> list = new ArrayList<RepositoryCommit>(this.commits);
        Collections.sort(list);
        return list;
    }

    public Map<String, Metric> getAuthorMetrics() {
        return this.authorMetrics;
    }

    public Map<String, Metric> getRepositoryMetrics() {
        return this.repositoryMetrics;
    }

    @Override
    public int compareTo(Activity o) {
        return o.startDate.compareTo(this.startDate);
    }

    public static class RepositoryCommit
    implements Serializable,
    Comparable<RepositoryCommit> {
        private static final long serialVersionUID = 1L;
        public final String repository;
        public final String branch;
        private final RevCommit commit;
        private List<RefModel> refs;

        public RepositoryCommit(String repository, String branch, RevCommit commit) {
            this.repository = repository;
            this.branch = branch;
            this.commit = commit;
        }

        public void setRefs(List<RefModel> refs) {
            this.refs = refs;
        }

        public List<RefModel> getRefs() {
            return this.refs;
        }

        public String getName() {
            return this.commit.getName();
        }

        public String getShortName() {
            return this.commit.getName().substring(0, 8);
        }

        public String getShortMessage() {
            return this.commit.getShortMessage();
        }

        public int getParentCount() {
            return this.commit.getParentCount();
        }

        public PersonIdent getAuthorIdent() {
            return this.commit.getAuthorIdent();
        }

        public PersonIdent getCommitterIdent() {
            return this.commit.getCommitterIdent();
        }

        public boolean equals(Object o) {
            if (o instanceof RepositoryCommit) {
                RepositoryCommit commit = (RepositoryCommit)o;
                return this.repository.equals(commit.repository) && this.getName().equals(commit.getName());
            }
            return false;
        }

        public int hashCode() {
            return (this.repository + this.commit).hashCode();
        }

        @Override
        public int compareTo(RepositoryCommit o) {
            if (this.commit.getCommitTime() > o.commit.getCommitTime()) {
                return -1;
            }
            if (this.commit.getCommitTime() < o.commit.getCommitTime()) {
                return 1;
            }
            return 0;
        }
    }
}

