/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.Date;

public class FeedModel
implements Serializable,
Comparable<FeedModel> {
    public String repository;
    public String branch;
    public Date lastRefreshDate = new Date(0L);
    public Date currentRefreshDate = new Date(0L);
    public boolean subscribed = true;
    private static final long serialVersionUID = 1L;

    public FeedModel() {
        this("");
        this.subscribed = false;
    }

    public FeedModel(String definition) {
        String[] fields = definition.split(":");
        this.repository = fields[0];
        if (fields.length > 1) {
            this.branch = fields[1];
        }
    }

    public String toString() {
        if (StringUtils.isEmpty(this.branch)) {
            return this.repository;
        }
        return this.repository + ":" + this.branch;
    }

    @Override
    public int compareTo(FeedModel o) {
        int repositoryCompare = StringUtils.compareRepositoryNames(this.repository, o.repository);
        if (repositoryCompare == 0) {
            if (StringUtils.isEmpty(this.branch)) {
                return 1;
            }
            if (StringUtils.isEmpty(o.branch)) {
                return -1;
            }
            return this.branch.compareTo(o.branch);
        }
        return repositoryCompare;
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof FeedModel) {
            return this.hashCode() == o.hashCode();
        }
        return false;
    }
}

