/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class IssueModel
implements Serializable,
Comparable<IssueModel> {
    private static final long serialVersionUID = 1L;
    public String id;
    public Type type;
    public Status status;
    public Priority priority;
    public Date created = new Date(0L);
    public String summary;
    public String description;
    public String reporter;
    public String owner;
    public String milestone;
    public List<Change> changes;

    public IssueModel() {
        this.type = Type.Defect;
        this.status = Status.New;
        this.priority = Priority.Medium;
        this.changes = new ArrayList<Change>();
    }

    public String getStatus() {
        String s = this.status.toString();
        if (!StringUtils.isEmpty(this.owner)) {
            s = s + " (" + this.owner + ")";
        }
        return s;
    }

    public boolean hasLabel(String label) {
        return this.getLabels().contains(label);
    }

    public List<String> getLabels() {
        ArrayList<String> list = new ArrayList<String>();
        String labels = null;
        for (Change change : this.changes) {
            if (!change.hasField(Field.Labels)) continue;
            labels = change.getString(Field.Labels);
        }
        if (!StringUtils.isEmpty(labels)) {
            list.addAll(StringUtils.getStringsFromValue(labels, " "));
        }
        return list;
    }

    public Attachment getAttachment(String name) {
        Attachment attachment = null;
        for (Change change : this.changes) {
            Attachment a;
            if (!change.hasAttachments() || (a = change.getAttachment(name)) == null) continue;
            attachment = a;
        }
        return attachment;
    }

    public List<Attachment> getAttachments() {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        for (Change change : this.changes) {
            if (!change.hasAttachments()) continue;
            list.addAll(change.attachments);
        }
        return list;
    }

    public void applyChange(Change change) {
        if (this.changes.size() == 0) {
            this.created = change.created;
        }
        this.changes.add(change);
        if (change.hasFieldChanges()) {
            for (FieldChange fieldChange : change.fieldChanges) {
                switch (fieldChange.field) {
                    case Id: {
                        this.id = fieldChange.value.toString();
                        break;
                    }
                    case Type: {
                        this.type = Type.fromObject(fieldChange.value);
                        break;
                    }
                    case Status: {
                        this.status = Status.fromObject(fieldChange.value);
                        break;
                    }
                    case Priority: {
                        this.priority = Priority.fromObject(fieldChange.value);
                        break;
                    }
                    case Summary: {
                        this.summary = fieldChange.value.toString();
                        break;
                    }
                    case Description: {
                        this.description = fieldChange.value.toString();
                        break;
                    }
                    case Reporter: {
                        this.reporter = fieldChange.value.toString();
                        break;
                    }
                    case Owner: {
                        this.owner = fieldChange.value.toString();
                        break;
                    }
                    case Milestone: {
                        this.milestone = fieldChange.value.toString();
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("issue ");
        sb.append(this.id.substring(0, 8));
        sb.append(" (" + this.summary + ")\n");
        for (Change change : this.changes) {
            sb.append(change);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public int compareTo(IssueModel o) {
        return o.created.compareTo(this.created);
    }

    public boolean equals(Object o) {
        if (o instanceof IssueModel) {
            return this.id.equals(((IssueModel)o).id);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static enum Status {
        New,
        Accepted,
        Started,
        Review,
        Queued,
        Testing,
        Done,
        Fixed,
        WontFix,
        Duplicate,
        Invalid;


        public static Status fromObject(Object o) {
            int id;
            if (o instanceof Status) {
                return (Status)((Object)o);
            }
            if (o instanceof String) {
                for (Status status : Status.values()) {
                    String str = o.toString();
                    if (!status.toString().equalsIgnoreCase(str)) continue;
                    return status;
                }
            } else if (o instanceof Number && (id = ((Number)o).intValue()) >= 0 && id < Status.values().length) {
                return Status.values()[id];
            }
            return null;
        }

        public boolean atLeast(Status status) {
            return this.ordinal() >= status.ordinal();
        }

        public boolean exceeds(Status status) {
            return this.ordinal() > status.ordinal();
        }

        public boolean isClosed() {
            return this.ordinal() >= Done.ordinal();
        }

        public Status next() {
            switch (this) {
                case New: {
                    return Started;
                }
                case Accepted: {
                    return Started;
                }
                case Started: {
                    return Testing;
                }
                case Review: {
                    return Testing;
                }
                case Queued: {
                    return Testing;
                }
                case Testing: {
                    return Done;
                }
            }
            return Accepted;
        }
    }

    public static enum Priority {
        Low,
        Medium,
        High,
        Critical;


        public static Priority fromObject(Object o) {
            int id;
            if (o instanceof Priority) {
                return (Priority)((Object)o);
            }
            if (o instanceof String) {
                for (Priority priority : Priority.values()) {
                    String str = o.toString();
                    if (!priority.toString().equalsIgnoreCase(str)) continue;
                    return priority;
                }
            } else if (o instanceof Number && (id = ((Number)o).intValue()) >= 0 && id < Priority.values().length) {
                return Priority.values()[id];
            }
            return null;
        }
    }

    public static enum Type {
        Defect,
        Enhancement,
        Task,
        Review,
        Other;


        public static Type fromObject(Object o) {
            int id;
            if (o instanceof Type) {
                return (Type)((Object)o);
            }
            if (o instanceof String) {
                for (Type type : Type.values()) {
                    String str = o.toString();
                    if (!type.toString().equalsIgnoreCase(str)) continue;
                    return type;
                }
            } else if (o instanceof Number && (id = ((Number)o).intValue()) >= 0 && id < Type.values().length) {
                return Type.values()[id];
            }
            return null;
        }
    }

    public static enum Field {
        Id,
        Summary,
        Description,
        Reporter,
        Owner,
        Type,
        Status,
        Priority,
        Milestone,
        Component,
        Labels;

    }

    public static class Attachment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String name;
        public String id;
        public long size;
        public byte[] content;
        public boolean deleted;

        public Attachment(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Attachment) {
                return this.name.equalsIgnoreCase(((Attachment)o).name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class FieldChange
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Field field;
        public final Object value;

        FieldChange(Field field, Object value) {
            this.field = field;
            this.value = value;
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FieldChange) {
                return this.field.equals((Object)((FieldChange)o).field);
            }
            return false;
        }

        public String toString() {
            return (Object)((Object)this.field) + ": " + this.value;
        }
    }

    public static class Comment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String text;
        public String id;
        public boolean deleted;

        Comment(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Change
    implements Serializable,
    Comparable<Change> {
        private static final long serialVersionUID = 1L;
        public final Date created = new Date(System.currentTimeMillis() / 1000L * 1000L);
        public final String author;
        public String id;
        public char code;
        public Comment comment;
        public Set<FieldChange> fieldChanges;
        public Set<Attachment> attachments;

        public Change(String author) {
            this.author = author;
            this.id = StringUtils.getSHA1(this.created.toString() + author);
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.deleted;
        }

        public void comment(String text) {
            this.comment = new Comment(text);
            this.comment.id = StringUtils.getSHA1(this.created.toString() + this.author + text);
        }

        public boolean hasAttachments() {
            return !ArrayUtils.isEmpty(this.attachments);
        }

        public void addAttachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new LinkedHashSet<Attachment>();
            }
            this.attachments.add(attachment);
        }

        public Attachment getAttachment(String name) {
            for (Attachment attachment : this.attachments) {
                if (!attachment.name.equalsIgnoreCase(name)) continue;
                return attachment;
            }
            return null;
        }

        public boolean hasField(Field field) {
            return !StringUtils.isEmpty(this.getString(field));
        }

        public boolean hasFieldChanges() {
            return !ArrayUtils.isEmpty(this.fieldChanges);
        }

        public Object getField(Field field) {
            if (this.fieldChanges != null) {
                for (FieldChange fieldChange : this.fieldChanges) {
                    if (fieldChange.field != field) continue;
                    return fieldChange.value;
                }
            }
            return null;
        }

        public void setField(Field field, Object value) {
            FieldChange fieldChange = new FieldChange(field, value);
            if (this.fieldChanges == null) {
                this.fieldChanges = new LinkedHashSet<FieldChange>();
            }
            this.fieldChanges.add(fieldChange);
        }

        public String getString(Field field) {
            Object value = this.getField(field);
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        @Override
        public int compareTo(Change c) {
            return this.created.compareTo(c.created);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Change) {
                return this.id.equals(((Change)o).id);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(new TimeUtils().timeAgo(this.created));
            switch (this.code) {
                case '+': {
                    sb.append(" created by ");
                    break;
                }
                default: {
                    if (this.hasComment()) {
                        sb.append(" commented on by ");
                        break;
                    }
                    sb.append(" changed by ");
                }
            }
            sb.append(this.author).append(" - ");
            if (this.hasComment()) {
                if (this.comment.deleted) {
                    sb.append("(deleted) ");
                }
                sb.append(this.comment.text).append(" ");
            }
            if (this.hasFieldChanges()) {
                switch (this.code) {
                    case '+': {
                        break;
                    }
                    default: {
                        for (FieldChange fieldChange : this.fieldChanges) {
                            sb.append("\n  ");
                            sb.append(fieldChange);
                        }
                    }
                }
            }
            return sb.toString();
        }
    }
}

