/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import java.io.Serializable;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.FileMode;

public class PathModel
implements Serializable,
Comparable<PathModel> {
    private static final long serialVersionUID = 1L;
    public final String name;
    public final String path;
    public final long size;
    public final int mode;
    public final String objectId;
    public final String commitId;
    public boolean isParentPath;

    public PathModel(String name, String path, long size, int mode, String objectId, String commitId) {
        this.name = name;
        this.path = path;
        this.size = size;
        this.mode = mode;
        this.objectId = objectId;
        this.commitId = commitId;
    }

    public boolean isSymlink() {
        return FileMode.SYMLINK.equals(this.mode);
    }

    public boolean isSubmodule() {
        return FileMode.GITLINK.equals(this.mode);
    }

    public boolean isTree() {
        return FileMode.TREE.equals(this.mode);
    }

    public int hashCode() {
        return this.commitId.hashCode() + this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PathModel) {
            PathModel other = (PathModel)o;
            return this.path.equals(other.path);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(PathModel o) {
        boolean isTree = this.isTree();
        boolean otherTree = o.isTree();
        if (isTree && otherTree) {
            return this.path.compareTo(o.path);
        }
        if (!isTree && !otherTree) {
            if (this.isSubmodule() && o.isSubmodule()) {
                return this.path.compareTo(o.path);
            }
            if (this.isSubmodule()) {
                return -1;
            }
            if (o.isSubmodule()) {
                return 1;
            }
            return this.path.compareTo(o.path);
        }
        if (isTree && !otherTree) {
            return -1;
        }
        return 1;
    }

    public static class PathChangeModel
    extends PathModel {
        private static final long serialVersionUID = 1L;
        public final DiffEntry.ChangeType changeType;

        public PathChangeModel(String name, String path, long size, int mode, String objectId, String commitId, DiffEntry.ChangeType type) {
            super(name, path, size, mode, objectId, commitId);
            this.changeType = type;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }
}

