/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;

public class RefModel
implements Serializable,
Comparable<RefModel> {
    private static final long serialVersionUID = 1L;
    public final String displayName;
    public final RevObject referencedObject;
    public transient Ref reference;

    public RefModel(String displayName, Ref ref, RevObject refObject) {
        this.displayName = displayName;
        this.reference = ref;
        this.referencedObject = refObject;
    }

    public Date getDate() {
        Date date = new Date(0L);
        if (this.referencedObject != null) {
            if (this.referencedObject instanceof RevTag) {
                RevTag tag = (RevTag)this.referencedObject;
                if (tag.getTaggerIdent() != null) {
                    date = tag.getTaggerIdent().getWhen();
                }
            } else if (this.referencedObject instanceof RevCommit) {
                date = ((RevCommit)this.referencedObject).getCommitterIdent().getWhen();
            }
        }
        return date;
    }

    public String getName() {
        if (this.reference == null) {
            return this.displayName;
        }
        return this.reference.getName();
    }

    public int getReferencedObjectType() {
        int type = this.referencedObject.getType();
        if (this.referencedObject instanceof RevTag) {
            type = ((RevTag)this.referencedObject).getObject().getType();
        }
        return type;
    }

    public ObjectId getReferencedObjectId() {
        if (this.referencedObject instanceof RevTag) {
            return ((RevTag)this.referencedObject).getObject().getId();
        }
        return this.referencedObject.getId();
    }

    public String getShortMessage() {
        String message = "";
        if (this.referencedObject instanceof RevTag) {
            message = ((RevTag)this.referencedObject).getShortMessage();
        } else if (this.referencedObject instanceof RevCommit) {
            message = ((RevCommit)this.referencedObject).getShortMessage();
        }
        return message;
    }

    public String getFullMessage() {
        String message = "";
        if (this.referencedObject instanceof RevTag) {
            message = ((RevTag)this.referencedObject).getFullMessage();
        } else if (this.referencedObject instanceof RevCommit) {
            message = ((RevCommit)this.referencedObject).getFullMessage();
        }
        return message;
    }

    public PersonIdent getAuthorIdent() {
        if (this.referencedObject instanceof RevTag) {
            return ((RevTag)this.referencedObject).getTaggerIdent();
        }
        if (this.referencedObject instanceof RevCommit) {
            return ((RevCommit)this.referencedObject).getAuthorIdent();
        }
        return null;
    }

    public ObjectId getObjectId() {
        return this.reference.getObjectId();
    }

    public boolean isAnnotatedTag() {
        if (this.referencedObject instanceof RevTag) {
            return !this.getReferencedObjectId().equals((AnyObjectId)this.getObjectId());
        }
        return this.reference.getPeeledObjectId() != null;
    }

    public int hashCode() {
        return this.getReferencedObjectId().hashCode() + this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RefModel) {
            RefModel other = (RefModel)o;
            return this.getName().equals(other.getName());
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(RefModel o) {
        return this.getDate().compareTo(o.getDate());
    }

    public String toString() {
        return this.displayName;
    }
}

