/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RepositoryModel
implements Serializable,
Comparable<RepositoryModel> {
    private static final long serialVersionUID = 1L;
    public String name;
    public String description;
    public String owner;
    public Date lastChange;
    public boolean hasCommits;
    public boolean showRemoteBranches;
    public boolean useTickets;
    public boolean useDocs;
    public Constants.AccessRestrictionType accessRestriction;
    public Constants.AuthorizationControl authorizationControl;
    public boolean allowAuthenticated;
    public boolean isFrozen;
    public boolean showReadme;
    public Constants.FederationStrategy federationStrategy;
    public List<String> federationSets;
    public boolean isFederated;
    public boolean skipSizeCalculation;
    public boolean skipSummaryMetrics;
    public String frequency;
    public boolean isBare;
    public String origin;
    public String HEAD;
    public List<String> availableRefs;
    public List<String> indexedBranches;
    public String size;
    public List<String> preReceiveScripts;
    public List<String> postReceiveScripts;
    public List<String> mailingLists;
    public Map<String, String> customFields;
    public String projectPath;
    private String displayName;
    public boolean allowForks;
    public Set<String> forks;
    public String originRepository;
    public boolean verifyCommitter;
    public String gcThreshold;
    public int gcPeriod;
    public int maxActivityCommits;
    public transient boolean isCollectingGarbage;
    public Date lastGC;

    public RepositoryModel() {
        this("", "", "", new Date(0L));
    }

    public RepositoryModel(String name, String description, String owner, Date lastchange) {
        this.name = name;
        this.description = description;
        this.owner = owner;
        this.lastChange = lastchange;
        this.accessRestriction = Constants.AccessRestrictionType.NONE;
        this.authorizationControl = Constants.AuthorizationControl.NAMED;
        this.federationSets = new ArrayList<String>();
        this.federationStrategy = Constants.FederationStrategy.FEDERATE_THIS;
        this.projectPath = StringUtils.getFirstPathElement(name);
    }

    public List<String> getLocalBranches() {
        if (ArrayUtils.isEmpty(this.availableRefs)) {
            return new ArrayList<String>();
        }
        ArrayList<String> localBranches = new ArrayList<String>();
        for (String ref : this.availableRefs) {
            if (!ref.startsWith("refs/heads")) continue;
            localBranches.add(ref);
        }
        return localBranches;
    }

    public void addFork(String repository) {
        if (this.forks == null) {
            this.forks = new TreeSet<String>();
        }
        this.forks.add(repository);
    }

    public void removeFork(String repository) {
        if (this.forks == null) {
            return;
        }
        this.forks.remove(repository);
    }

    public void resetDisplayName() {
        this.displayName = null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RepositoryModel) {
            return this.name.equals(((RepositoryModel)o).name);
        }
        return false;
    }

    public String toString() {
        if (this.displayName == null) {
            this.displayName = StringUtils.stripDotGit(this.name);
        }
        return this.displayName;
    }

    @Override
    public int compareTo(RepositoryModel o) {
        return StringUtils.compareRepositoryNames(this.name, o.name);
    }

    public boolean isFork() {
        return !StringUtils.isEmpty(this.originRepository);
    }

    public boolean isOwner(String username) {
        return this.owner != null && username != null && this.owner.equalsIgnoreCase(username);
    }

    public boolean isPersonalRepository() {
        return !StringUtils.isEmpty(this.projectPath) && this.projectPath.charAt(0) == '~';
    }

    public boolean isUsersPersonalRepository(String username) {
        return !StringUtils.isEmpty(this.projectPath) && this.projectPath.equalsIgnoreCase("~" + username);
    }

    public boolean allowAnonymousView() {
        return !this.accessRestriction.atLeast(Constants.AccessRestrictionType.VIEW);
    }

    public RepositoryModel cloneAs(String cloneName) {
        RepositoryModel clone = new RepositoryModel();
        clone.originRepository = this.name;
        clone.name = cloneName;
        clone.projectPath = StringUtils.getFirstPathElement(cloneName);
        clone.isBare = true;
        clone.description = this.description;
        clone.accessRestriction = Constants.AccessRestrictionType.PUSH;
        clone.authorizationControl = Constants.AuthorizationControl.NAMED;
        clone.federationStrategy = this.federationStrategy;
        clone.showReadme = this.showReadme;
        clone.showRemoteBranches = false;
        clone.allowForks = false;
        clone.useDocs = this.useDocs;
        clone.useTickets = this.useTickets;
        clone.skipSizeCalculation = this.skipSizeCalculation;
        clone.skipSummaryMetrics = this.skipSummaryMetrics;
        return clone;
    }
}

