/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SettingModel
implements Serializable {
    public static final String SPACE_DELIMITED = "SPACE-DELIMITED";
    public static final String CASE_SENSITIVE = "CASE-SENSITIVE";
    public static final String RESTART_REQUIRED = "RESTART REQUIRED";
    public static final String SINCE = "SINCE";
    public String name;
    public volatile String currentValue;
    public String defaultValue;
    public String description;
    public String since;
    public boolean caseSensitive;
    public boolean restartRequired;
    public boolean spaceDelimited;
    private static final long serialVersionUID = 1L;

    public boolean isDefaultValue() {
        return this.currentValue != null && this.currentValue.equals(this.defaultValue) || this.currentValue.trim().length() == 0;
    }

    public boolean getBoolean(boolean defaultValue) {
        if (!StringUtils.isEmpty(this.currentValue)) {
            return Boolean.parseBoolean(this.currentValue.trim());
        }
        return defaultValue;
    }

    public int getInteger(int defaultValue) {
        try {
            if (!StringUtils.isEmpty(this.currentValue)) {
                return Integer.parseInt(this.currentValue.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public char getChar(char defaultValue) {
        if (!StringUtils.isEmpty(this.currentValue)) {
            return this.currentValue.trim().charAt(0);
        }
        return defaultValue;
    }

    public String getString(String defaultValue) {
        if (this.currentValue != null) {
            return this.currentValue.trim();
        }
        return defaultValue;
    }

    public List<String> getStrings() {
        return this.getStrings(" ");
    }

    public List<String> getStrings(String separator) {
        ArrayList<String> strings = new ArrayList();
        strings = StringUtils.getStringsFromValue(this.currentValue, separator);
        return strings;
    }

    public Map<String, String> getMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String string : this.getStrings()) {
            String[] kvp = string.split("=", 2);
            String key = kvp[0];
            String value = kvp[1];
            map.put(key, value);
        }
        return map;
    }
}

