/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TeamModel
implements Serializable,
Comparable<TeamModel> {
    private static final long serialVersionUID = 1L;
    public String name;
    public boolean canAdmin;
    public boolean canFork;
    public boolean canCreate;
    public final Set<String> users = new HashSet<String>();
    @Deprecated
    public final Set<String> repositories = new HashSet<String>();
    public final Map<String, Constants.AccessPermission> permissions = new LinkedHashMap<String, Constants.AccessPermission>();
    public final Set<String> mailingLists = new HashSet<String>();
    public final List<String> preReceiveScripts = new ArrayList<String>();
    public final List<String> postReceiveScripts = new ArrayList<String>();

    public TeamModel(String name) {
        this.name = name;
    }

    @Deprecated
    @Constants.Unused
    public boolean hasRepository(String name) {
        return this.hasRepositoryPermission(name);
    }

    @Deprecated
    @Constants.Unused
    public void addRepository(String name) {
        this.addRepositoryPermission(name);
    }

    @Deprecated
    @Constants.Unused
    public void addRepositories(Collection<String> names) {
        this.addRepositoryPermissions(names);
    }

    @Deprecated
    @Constants.Unused
    public void removeRepository(String name) {
        this.removeRepositoryPermission(name);
    }

    public List<RegistrantAccessPermission> getRepositoryPermissions() {
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>();
        if (this.canAdmin) {
            return list;
        }
        for (Map.Entry<String, Constants.AccessPermission> entry : this.permissions.entrySet()) {
            String registrant = entry.getKey();
            String source = null;
            boolean editable = true;
            Constants.PermissionType pType = Constants.PermissionType.EXPLICIT;
            if (StringUtils.findInvalidCharacter(registrant) != null) {
                pType = Constants.PermissionType.REGEX;
                source = registrant;
            }
            list.add(new RegistrantAccessPermission(registrant, entry.getValue(), pType, Constants.RegistrantType.REPOSITORY, source, editable));
        }
        Collections.sort(list);
        return list;
    }

    public boolean hasRepositoryPermission(String name) {
        String repository = Constants.AccessPermission.repositoryFromRole(name).toLowerCase();
        if (this.permissions.containsKey(repository)) {
            return true;
        }
        for (String key : this.permissions.keySet()) {
            Constants.AccessPermission p;
            if (!name.matches(key) || (p = this.permissions.get(key)) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasExplicitRepositoryPermission(String name) {
        String repository = Constants.AccessPermission.repositoryFromRole(name).toLowerCase();
        return this.permissions.containsKey(repository);
    }

    public void addRepositoryPermission(String role) {
        Constants.AccessPermission permission = Constants.AccessPermission.permissionFromRole(role);
        String repository = Constants.AccessPermission.repositoryFromRole(role).toLowerCase();
        this.repositories.add(repository);
        this.permissions.put(repository, permission);
    }

    public void addRepositoryPermissions(Collection<String> roles) {
        for (String role : roles) {
            this.addRepositoryPermission(role);
        }
    }

    public Constants.AccessPermission removeRepositoryPermission(String name) {
        String repository = Constants.AccessPermission.repositoryFromRole(name).toLowerCase();
        this.repositories.remove(repository);
        return this.permissions.remove(repository);
    }

    public void setRepositoryPermission(String repository, Constants.AccessPermission permission) {
        this.permissions.put(repository.toLowerCase(), permission);
        this.repositories.add(repository.toLowerCase());
    }

    public RegistrantAccessPermission getRepositoryPermission(RepositoryModel repository) {
        RegistrantAccessPermission ap = new RegistrantAccessPermission();
        ap.registrant = this.name;
        ap.registrantType = Constants.RegistrantType.TEAM;
        ap.permission = Constants.AccessPermission.NONE;
        ap.mutable = false;
        if (this.canAdmin) {
            ap.permissionType = Constants.PermissionType.ADMINISTRATOR;
            ap.permission = Constants.AccessPermission.REWIND;
            return ap;
        }
        if (this.permissions.containsKey(repository.name.toLowerCase())) {
            Constants.AccessPermission p = this.permissions.get(repository.name.toLowerCase());
            if (p != null) {
                ap.permissionType = Constants.PermissionType.EXPLICIT;
                ap.permission = p;
                ap.mutable = true;
                return ap;
            }
        } else {
            for (String key : this.permissions.keySet()) {
                Constants.AccessPermission p;
                if (!StringUtils.matchesIgnoreCase(repository.name, key) || (p = this.permissions.get(key)) == null) continue;
                ap.permissionType = Constants.PermissionType.REGEX;
                ap.permission = p;
                ap.source = key;
                return ap;
            }
        }
        return ap;
    }

    protected boolean canAccess(RepositoryModel repository, Constants.AccessRestrictionType ifRestriction, Constants.AccessPermission requirePermission) {
        if (repository.accessRestriction.atLeast(ifRestriction)) {
            RegistrantAccessPermission ap = this.getRepositoryPermission(repository);
            return ap.permission.atLeast(requirePermission);
        }
        return true;
    }

    public boolean canView(RepositoryModel repository) {
        return this.canAccess(repository, Constants.AccessRestrictionType.VIEW, Constants.AccessPermission.VIEW);
    }

    public boolean canClone(RepositoryModel repository) {
        return this.canAccess(repository, Constants.AccessRestrictionType.CLONE, Constants.AccessPermission.CLONE);
    }

    public boolean canPush(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.PUSH);
    }

    public boolean canCreateRef(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.CREATE);
    }

    public boolean canDeleteRef(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.DELETE);
    }

    public boolean canRewindRef(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.REWIND);
    }

    public boolean hasUser(String name) {
        return this.users.contains(name.toLowerCase());
    }

    public void addUser(String name) {
        this.users.add(name.toLowerCase());
    }

    public void addUsers(Collection<String> names) {
        for (String name : names) {
            this.users.add(name.toLowerCase());
        }
    }

    public void removeUser(String name) {
        this.users.remove(name.toLowerCase());
    }

    public void addMailingLists(Collection<String> addresses) {
        for (String address : addresses) {
            this.mailingLists.add(address.toLowerCase());
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(TeamModel o) {
        return this.name.compareTo(o.name);
    }
}

