/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TicketModel
implements Serializable,
Comparable<TicketModel> {
    private static final long serialVersionUID = 1L;
    public String id;
    public String name;
    public String title;
    public String state = "";
    public Date date;
    public String handler;
    public String milestone;
    public String email;
    public String author;
    public List<Comment> comments;
    public List<String> tags;

    public TicketModel(String ticketName) throws ParseException {
        this.name = ticketName;
        this.comments = new ArrayList<Comment>();
        this.tags = new ArrayList<String>();
        String[] chunks = this.name.split("_");
        if (chunks.length == 3) {
            this.date = new Date(Long.parseLong(chunks[0]) * 1000L);
            this.title = chunks[1].replace('-', ' ');
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TicketModel) {
            TicketModel other = (TicketModel)o;
            return this.id.equals(other.id);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(TicketModel o) {
        return this.date.compareTo(o.date);
    }

    public static class Comment
    implements Serializable,
    Comparable<Comment> {
        private static final long serialVersionUID = 1L;
        public String text;
        public String author;
        public Date date;

        public Comment(String filename, String content) throws ParseException {
            String[] chunks = filename.split("_", -1);
            this.date = new Date(Long.parseLong(chunks[1]) * 1000L);
            this.author = chunks[2];
            this.text = content;
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Comment) {
                Comment other = (Comment)o;
                return this.text.equals(other.text);
            }
            return super.equals(o);
        }

        @Override
        public int compareTo(Comment o) {
            return this.date.compareTo(o.date);
        }
    }
}

