/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TeamModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class UserModel
implements Principal,
Serializable,
Comparable<UserModel> {
    private static final long serialVersionUID = 1L;
    public static final UserModel ANONYMOUS = new UserModel();
    public String username;
    public String password;
    public String cookie;
    public String displayName;
    public String emailAddress;
    public String organizationalUnit;
    public String organization;
    public String locality;
    public String stateProvince;
    public String countryCode;
    public boolean canAdmin;
    public boolean canFork;
    public boolean canCreate;
    public boolean excludeFromFederation;
    @Deprecated
    public final Set<String> repositories = new HashSet<String>();
    public final Map<String, Constants.AccessPermission> permissions = new LinkedHashMap<String, Constants.AccessPermission>();
    public final Set<TeamModel> teams = new TreeSet<TeamModel>();
    public boolean isAuthenticated;

    public UserModel(String username) {
        this.username = username;
        this.isAuthenticated = true;
    }

    private UserModel() {
        this.username = "$anonymous";
        this.isAuthenticated = false;
    }

    @Deprecated
    public boolean canAccessRepository(String repositoryName) {
        return this.canAdmin() || this.repositories.contains(repositoryName.toLowerCase()) || this.hasTeamAccess(repositoryName);
    }

    @Deprecated
    @Constants.Unused
    public boolean canAccessRepository(RepositoryModel repository) {
        boolean isOwner = !StringUtils.isEmpty(repository.owner) && repository.owner.equals(this.username);
        boolean allowAuthenticated = this.isAuthenticated && Constants.AuthorizationControl.AUTHENTICATED.equals((Object)repository.authorizationControl);
        return this.canAdmin() || isOwner || this.repositories.contains(repository.name.toLowerCase()) || this.hasTeamAccess(repository.name) || allowAuthenticated;
    }

    @Deprecated
    @Constants.Unused
    public boolean hasTeamAccess(String repositoryName) {
        for (TeamModel team : this.teams) {
            if (!team.hasRepositoryPermission(repositoryName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Constants.Unused
    public boolean hasRepository(String name) {
        return this.hasRepositoryPermission(name);
    }

    @Deprecated
    @Constants.Unused
    public void addRepository(String name) {
        this.addRepositoryPermission(name);
    }

    @Deprecated
    @Constants.Unused
    public void removeRepository(String name) {
        this.removeRepositoryPermission(name);
    }

    public List<RegistrantAccessPermission> getRepositoryPermissions() {
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>();
        if (this.canAdmin()) {
            return list;
        }
        for (Map.Entry<String, Constants.AccessPermission> entry : this.permissions.entrySet()) {
            String registrant = entry.getKey();
            Constants.AccessPermission ap = entry.getValue();
            String source = null;
            boolean mutable = true;
            Constants.PermissionType pType = Constants.PermissionType.EXPLICIT;
            if (this.isMyPersonalRepository(registrant)) {
                pType = Constants.PermissionType.OWNER;
                ap = Constants.AccessPermission.REWIND;
                mutable = false;
            } else if (StringUtils.findInvalidCharacter(registrant) != null) {
                pType = Constants.PermissionType.REGEX;
                source = registrant;
            }
            list.add(new RegistrantAccessPermission(registrant, ap, pType, Constants.RegistrantType.REPOSITORY, source, mutable));
        }
        Collections.sort(list);
        LinkedHashSet<RegistrantAccessPermission> set = new LinkedHashSet<RegistrantAccessPermission>(list);
        for (TeamModel team : this.teams) {
            for (RegistrantAccessPermission teamPermission : team.getRepositoryPermissions()) {
                teamPermission.registrantType = Constants.RegistrantType.REPOSITORY;
                teamPermission.permissionType = Constants.PermissionType.TEAM;
                teamPermission.source = team.name;
                teamPermission.mutable = false;
                set.add(teamPermission);
            }
        }
        return new ArrayList<RegistrantAccessPermission>(set);
    }

    public boolean hasRepositoryPermission(String name) {
        String repository = Constants.AccessPermission.repositoryFromRole(name).toLowerCase();
        if (this.permissions.containsKey(repository)) {
            return true;
        }
        for (String key : this.permissions.keySet()) {
            Constants.AccessPermission p;
            if (!name.matches(key) || (p = this.permissions.get(key)) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasExplicitRepositoryPermission(String name) {
        String repository = Constants.AccessPermission.repositoryFromRole(name).toLowerCase();
        return this.permissions.containsKey(repository);
    }

    public boolean hasTeamRepositoryPermission(String name) {
        if (this.teams != null) {
            for (TeamModel team : this.teams) {
                if (!team.hasRepositoryPermission(name)) continue;
                return true;
            }
        }
        return false;
    }

    public void addRepositoryPermission(String role) {
        Constants.AccessPermission permission = Constants.AccessPermission.permissionFromRole(role);
        String repository = Constants.AccessPermission.repositoryFromRole(role).toLowerCase();
        this.repositories.add(repository);
        this.permissions.put(repository, permission);
    }

    public Constants.AccessPermission removeRepositoryPermission(String name) {
        String repository = Constants.AccessPermission.repositoryFromRole(name).toLowerCase();
        this.repositories.remove(repository);
        return this.permissions.remove(repository);
    }

    public void setRepositoryPermission(String repository, Constants.AccessPermission permission) {
        this.permissions.put(repository.toLowerCase(), permission);
    }

    public RegistrantAccessPermission getRepositoryPermission(RepositoryModel repository) {
        Object p;
        RegistrantAccessPermission ap = new RegistrantAccessPermission();
        ap.registrant = this.username;
        ap.registrantType = Constants.RegistrantType.USER;
        ap.permission = Constants.AccessPermission.NONE;
        ap.mutable = false;
        if (Constants.AccessRestrictionType.NONE.equals((Object)repository.accessRestriction)) {
            ap.permissionType = Constants.PermissionType.ADMINISTRATOR;
            ap.permission = Constants.AccessPermission.REWIND;
            return ap;
        }
        if (this.canAdmin()) {
            ap.permissionType = Constants.PermissionType.ADMINISTRATOR;
            ap.permission = Constants.AccessPermission.REWIND;
            if (!this.canAdmin) {
                for (TeamModel team : this.teams) {
                    if (!team.canAdmin) continue;
                    ap.source = team.name;
                    break;
                }
            }
            return ap;
        }
        if (repository.isOwner(this.username) || repository.isUsersPersonalRepository(this.username)) {
            ap.permissionType = Constants.PermissionType.OWNER;
            ap.permission = Constants.AccessPermission.REWIND;
            return ap;
        }
        if (Constants.AuthorizationControl.AUTHENTICATED.equals((Object)repository.authorizationControl) && this.isAuthenticated) {
            ap.permission = Constants.AccessPermission.REWIND;
            return ap;
        }
        if (this.permissions.containsKey(repository.name.toLowerCase())) {
            Constants.AccessPermission p2 = this.permissions.get(repository.name.toLowerCase());
            if (p2 != null) {
                ap.permissionType = Constants.PermissionType.EXPLICIT;
                ap.permission = p2;
                ap.mutable = true;
                return ap;
            }
        } else {
            for (String key : this.permissions.keySet()) {
                if (!StringUtils.matchesIgnoreCase(repository.name, key) || (p = this.permissions.get(key)) == null) continue;
                ap.permissionType = Constants.PermissionType.REGEX;
                ap.permission = p;
                ap.source = key;
                return ap;
            }
        }
        for (TeamModel team : this.teams) {
            p = team.getRepositoryPermission(repository);
            if (!((RegistrantAccessPermission)p).permission.exceeds(ap.permission)) continue;
            ap.permission = ((RegistrantAccessPermission)p).permission;
            ap.source = team.name;
            ap.permissionType = Constants.PermissionType.TEAM;
        }
        return ap;
    }

    protected boolean canAccess(RepositoryModel repository, Constants.AccessRestrictionType ifRestriction, Constants.AccessPermission requirePermission) {
        if (repository.accessRestriction.atLeast(ifRestriction)) {
            RegistrantAccessPermission ap = this.getRepositoryPermission(repository);
            return ap.permission.atLeast(requirePermission);
        }
        return true;
    }

    public boolean canView(RepositoryModel repository) {
        return this.canAccess(repository, Constants.AccessRestrictionType.VIEW, Constants.AccessPermission.VIEW);
    }

    public boolean canView(RepositoryModel repository, String ref) {
        return this.canView(repository);
    }

    public boolean canClone(RepositoryModel repository) {
        return this.canAccess(repository, Constants.AccessRestrictionType.CLONE, Constants.AccessPermission.CLONE);
    }

    public boolean canPush(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.PUSH);
    }

    public boolean canCreateRef(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.CREATE);
    }

    public boolean canDeleteRef(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.DELETE);
    }

    public boolean canRewindRef(RepositoryModel repository) {
        if (repository.isFrozen) {
            return false;
        }
        return this.canAccess(repository, Constants.AccessRestrictionType.PUSH, Constants.AccessPermission.REWIND);
    }

    public boolean canFork(RepositoryModel repository) {
        if (repository.isUsersPersonalRepository(this.username)) {
            return false;
        }
        if (this.canAdmin() || repository.isOwner(this.username)) {
            return true;
        }
        if (!repository.allowForks) {
            return false;
        }
        if (!this.isAuthenticated || !this.canFork()) {
            return false;
        }
        return this.canClone(repository);
    }

    public boolean canDelete(RepositoryModel model) {
        return this.canAdmin() || model.isUsersPersonalRepository(this.username);
    }

    public boolean canEdit(RepositoryModel model) {
        return this.canAdmin() || model.isUsersPersonalRepository(this.username) || model.isOwner(this.username);
    }

    public boolean canFork() {
        if (this.canFork) {
            return true;
        }
        if (!ArrayUtils.isEmpty(this.teams)) {
            for (TeamModel team : this.teams) {
                if (!team.canFork) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAdmin() {
        if (this.canAdmin) {
            return true;
        }
        if (!ArrayUtils.isEmpty(this.teams)) {
            for (TeamModel team : this.teams) {
                if (!team.canAdmin) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canCreate() {
        if (this.canCreate) {
            return true;
        }
        if (!ArrayUtils.isEmpty(this.teams)) {
            for (TeamModel team : this.teams) {
                if (!team.canCreate) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canCreate(String repository) {
        String projectPath;
        if (this.canAdmin()) {
            return true;
        }
        return this.canCreate && !StringUtils.isEmpty(projectPath = StringUtils.getFirstPathElement(repository)) && projectPath.equalsIgnoreCase("~" + this.username);
    }

    public boolean isTeamMember(String teamname) {
        for (TeamModel team : this.teams) {
            if (!team.name.equalsIgnoreCase(teamname)) continue;
            return true;
        }
        return false;
    }

    public TeamModel getTeam(String teamname) {
        if (this.teams == null) {
            return null;
        }
        for (TeamModel team : this.teams) {
            if (!team.name.equalsIgnoreCase(teamname)) continue;
            return team;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.username;
    }

    public String getDisplayName() {
        if (StringUtils.isEmpty(this.displayName)) {
            return this.username;
        }
        return this.displayName;
    }

    public String getPersonalPath() {
        return "~" + this.username;
    }

    @Override
    public int hashCode() {
        return this.username.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UserModel) {
            return this.username.equals(((UserModel)o).username);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.username;
    }

    @Override
    public int compareTo(UserModel o) {
        return this.username.compareTo(o.username);
    }

    public boolean is(String name, String email) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        boolean nameVerified = name.equalsIgnoreCase(this.username) || name.equalsIgnoreCase(this.getDisplayName());
        boolean emailVerified = false;
        if (StringUtils.isEmpty(this.emailAddress)) {
            emailVerified = true;
        } else if (!StringUtils.isEmpty(email)) {
            emailVerified = email.equalsIgnoreCase(this.emailAddress);
        }
        return nameVerified && emailVerified;
    }

    @Deprecated
    public boolean hasBranchPermission(String repositoryName, String branch) {
        return this.hasRepositoryPermission(repositoryName) || this.hasTeamRepositoryPermission(repositoryName);
    }

    public boolean isMyPersonalRepository(String repository) {
        String projectPath = StringUtils.getFirstPathElement(repository);
        return !StringUtils.isEmpty(projectPath) && projectPath.equalsIgnoreCase("~" + this.username);
    }
}

