/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class FileUtils {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;

    public static int convertSizeToInt(String aString, int defaultValue) {
        return (int)FileUtils.convertSizeToLong(aString, defaultValue);
    }

    public static long convertSizeToLong(String aString, long defaultValue) {
        aString = aString.toLowerCase().trim();
        StringBuilder sb = new StringBuilder();
        for (String a : aString.split(" ")) {
            sb.append(a);
        }
        aString = sb.toString();
        int idx = 0;
        int len = aString.length();
        while (Character.isDigit(aString.charAt(idx)) && ++idx != len) {
        }
        long value = 0L;
        String unit = null;
        try {
            value = Long.parseLong(aString.substring(0, idx));
            unit = aString.substring(idx);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (unit.equals("g") || unit.equals("gb")) {
            return value * 0x40000000L;
        }
        if (unit.equals("m") || unit.equals("mb")) {
            return value * 0x100000L;
        }
        if (unit.equals("k") || unit.equals("kb")) {
            return value * 1024L;
        }
        return defaultValue;
    }

    public static byte[] readContent(File file) {
        byte[] buffer = new byte[(int)file.length()];
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            is.read(buffer, 0, buffer.length);
            is.close();
        }
        catch (Throwable t) {
            System.err.println("Failed to read byte content of " + file.getAbsolutePath());
            t.printStackTrace();
        }
        return buffer;
    }

    public static String readContent(File file, String lineEnding) {
        StringBuilder sb = new StringBuilder();
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
            BufferedReader reader = new BufferedReader(is);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                if (lineEnding == null) continue;
                sb.append(lineEnding);
            }
            reader.close();
        }
        catch (Throwable t) {
            System.err.println("Failed to read content of " + file.getAbsolutePath());
            t.printStackTrace();
        }
        return sb.toString();
    }

    public static void writeContent(File file, String content) {
        try {
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));
            BufferedWriter writer = new BufferedWriter(os);
            writer.append(content);
            writer.close();
        }
        catch (Throwable t) {
            System.err.println("Failed to write content of " + file.getAbsolutePath());
            t.printStackTrace();
        }
    }

    public static long folderSize(File directory) {
        if (directory == null || !directory.exists()) {
            return -1L;
        }
        if (directory.isFile()) {
            return directory.length();
        }
        long length = 0L;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += FileUtils.folderSize(file);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File destinationFolder, File ... filesOrFolders) throws FileNotFoundException, IOException {
        destinationFolder.mkdirs();
        for (File file : filesOrFolders) {
            if (file.isDirectory()) {
                FileUtils.copy(new File(destinationFolder, file.getName()), file.listFiles());
                continue;
            }
            File dFile = new File(destinationFolder, file.getName());
            BufferedInputStream bufin = null;
            FileOutputStream fos = null;
            try {
                bufin = new BufferedInputStream(new FileInputStream(file));
                fos = new FileOutputStream(dFile);
                int len = 8196;
                byte[] buff = new byte[len];
                int n = 0;
                while ((n = bufin.read(buff, 0, len)) != -1) {
                    fos.write(buff, 0, n);
                }
            }
            finally {
                try {
                    bufin.close();
                }
                catch (Throwable t) {}
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
            dFile.setLastModified(file.lastModified());
        }
    }

    public static String getRelativePath(File basePath, File path) {
        File exactBase = FileUtils.getExactFile(basePath);
        File exactPath = FileUtils.getExactFile(path);
        if (path.getAbsolutePath().startsWith(basePath.getAbsolutePath())) {
            return StringUtils.getRelativePath(basePath.getAbsolutePath(), path.getAbsolutePath());
        }
        if (exactPath.getPath().startsWith(exactBase.getPath())) {
            return StringUtils.getRelativePath(exactBase.getPath(), exactPath.getPath());
        }
        if (exactPath.getPath().startsWith(basePath.getAbsolutePath())) {
            return StringUtils.getRelativePath(basePath.getAbsolutePath(), exactPath.getPath());
        }
        if (path.getAbsolutePath().startsWith(exactBase.getPath())) {
            return StringUtils.getRelativePath(exactBase.getPath(), path.getAbsolutePath());
        }
        return null;
    }

    public static File getExactFile(File path) {
        try {
            return path.getCanonicalFile();
        }
        catch (IOException e) {
            return path.getAbsoluteFile();
        }
    }
}

