/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;

public class GitWebDiffFormatter
extends DiffFormatter {
    private final OutputStream os;

    public GitWebDiffFormatter(OutputStream os) {
        super(os);
        this.os = os;
    }

    protected void writeHunkHeader(int aStartLine, int aEndLine, int bStartLine, int bEndLine) throws IOException {
        this.os.write("<div class=\"diff hunk_header\"><span class=\"diff hunk_info\">".getBytes());
        this.os.write(64);
        this.os.write(64);
        this.writeRange('-', aStartLine + 1, aEndLine - aStartLine);
        this.writeRange('+', bStartLine + 1, bEndLine - bStartLine);
        this.os.write(32);
        this.os.write(64);
        this.os.write(64);
        this.os.write("</span></div>".getBytes());
    }

    protected void writeRange(char prefix, int begin, int cnt) throws IOException {
        this.os.write(32);
        this.os.write(prefix);
        switch (cnt) {
            case 0: {
                this.os.write(Constants.encodeASCII((long)(begin - 1)));
                this.os.write(44);
                this.os.write(48);
                break;
            }
            case 1: {
                this.os.write(Constants.encodeASCII((long)begin));
                break;
            }
            default: {
                this.os.write(Constants.encodeASCII((long)begin));
                this.os.write(44);
                this.os.write(Constants.encodeASCII((long)cnt));
            }
        }
    }

    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        switch (prefix) {
            case '+': {
                this.os.write("<span style=\"color:#008000;\">".getBytes());
                break;
            }
            case '-': {
                this.os.write("<span style=\"color:#800000;\">".getBytes());
            }
        }
        this.os.write(prefix);
        String line = text.getString(cur);
        line = StringUtils.escapeForHtml(line, false);
        this.os.write(Constants.encode((String)line));
        switch (prefix) {
            case '+': 
            case '-': {
                this.os.write("</span>\n".getBytes());
                break;
            }
            default: {
                this.os.write(10);
            }
        }
    }

    public String getHtml() {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)this.os;
        String html = RawParseUtils.decode((byte[])bos.toByteArray());
        String[] lines = html.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"diff\">");
        for (String line : lines) {
            if (line.startsWith("diff")) {
                sb.append("<div class=\"diff header\">").append(StringUtils.convertOctal(line)).append("</div>");
                continue;
            }
            if (line.startsWith("---")) {
                sb.append("<span style=\"color:#800000;\">").append(StringUtils.convertOctal(line)).append("</span><br/>");
                continue;
            }
            if (line.startsWith("+++")) {
                sb.append("<span style=\"color:#008000;\">").append(StringUtils.convertOctal(line)).append("</span><br/>");
                continue;
            }
            sb.append(line).append('\n');
        }
        sb.append("</div>\n");
        return sb.toString();
    }
}

