/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.IssueModel;
import com.gitblit.models.RefModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueUtils {
    public static final String GB_ISSUES = "refs/heads/gb-issues";
    static final Logger LOGGER = LoggerFactory.getLogger(JGitUtils.class);

    private static void error(Throwable t, Repository repository, String pattern, Object ... objects) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                parameters.add(o);
            }
        }
        if (repository != null) {
            parameters.add(0, repository.getDirectory().getAbsolutePath());
        }
        LOGGER.error(MessageFormat.format(pattern, parameters.toArray()), t);
    }

    public static RefModel getIssuesBranch(Repository repository) {
        return JGitUtils.getBranch(repository, "gb-issues");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IssueModel> getIssues(Repository repository, IssueFilter filter) {
        ArrayList<IssueModel> list = new ArrayList<IssueModel>();
        RefModel issuesBranch = IssueUtils.getIssuesBranch(repository);
        if (issuesBranch == null) {
            return list;
        }
        HashSet<String> issuePaths = new HashSet<String>();
        TreeWalk tw = new TreeWalk(repository);
        try {
            RevCommit head = JGitUtils.getCommit(repository, GB_ISSUES);
            tw.addTree((AnyObjectId)head.getTree());
            tw.setRecursive(false);
            while (tw.next()) {
                if (tw.getDepth() >= 2 || !tw.isSubtree()) continue;
                tw.enterSubtree();
                if (tw.getDepth() != 2) continue;
                issuePaths.add(tw.getPathString());
            }
        }
        catch (IOException e) {
            IssueUtils.error(e, repository, "{0} failed to query issues", new Object[0]);
        }
        finally {
            tw.release();
        }
        for (String issuePath : issuePaths) {
            RevWalk rw = new RevWalk(repository);
            try {
                RevCommit start = rw.parseCommit((AnyObjectId)repository.resolve(GB_ISSUES));
                rw.markStart(start);
            }
            catch (Exception e) {
                IssueUtils.error(e, repository, "Failed to find {1} in {0}", GB_ISSUES);
            }
            TreeFilter treeFilter = AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{issuePath}), (TreeFilter)TreeFilter.ANY_DIFF);
            rw.setTreeFilter(treeFilter);
            Iterator revlog = rw.iterator();
            ArrayList commits = new ArrayList();
            while (revlog.hasNext()) {
                commits.add(revlog.next());
            }
            rw.release();
            if (commits.size() == 0) {
                LOGGER.warn("Failed to find changes for issue " + issuePath);
                continue;
            }
            Collections.reverse(commits);
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (RevCommit commit : commits) {
                if (!first) {
                    sb.append(',');
                }
                String message = commit.getFullMessage();
                String json = message.substring(43);
                sb.append(json);
                first = false;
            }
            sb.append(']');
            Collection changes = (Collection)JsonUtils.fromJsonString(sb.toString(), new TypeToken<Collection<IssueModel.Change>>(){}.getType());
            IssueModel issue = IssueUtils.buildIssue(changes, true);
            if (filter == null) {
                list.add(issue);
                continue;
            }
            if (!filter.accept(issue)) continue;
            list.add(issue);
        }
        Collections.sort(list);
        return list;
    }

    public static IssueModel getIssue(Repository repository, String issueId) {
        return IssueUtils.getIssue(repository, issueId, true);
    }

    public static IssueModel getIssue(Repository repository, String issueId, boolean effective) {
        RefModel issuesBranch = IssueUtils.getIssuesBranch(repository);
        if (issuesBranch == null) {
            return null;
        }
        if (StringUtils.isEmpty(issueId)) {
            return null;
        }
        String issuePath = IssueUtils.getIssuePath(issueId);
        List<RevCommit> commits = JGitUtils.getRevLog(repository, GB_ISSUES, issuePath, 0, -1);
        Collections.reverse(commits);
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (RevCommit commit : commits) {
            if (!first) {
                sb.append(',');
            }
            String message = commit.getFullMessage();
            String json = message.substring(43);
            sb.append(json);
            first = false;
        }
        sb.append(']');
        Collection changes = (Collection)JsonUtils.fromJsonString(sb.toString(), new TypeToken<Collection<IssueModel.Change>>(){}.getType());
        IssueModel issue = IssueUtils.buildIssue(changes, effective);
        return issue;
    }

    private static IssueModel buildIssue(Collection<IssueModel.Change> changes, boolean effective) {
        IssueModel issue;
        if (effective) {
            ArrayList<IssueModel.Change> effectiveChanges = new ArrayList<IssueModel.Change>();
            HashMap<String, IssueModel.Change> comments = new HashMap<String, IssueModel.Change>();
            for (IssueModel.Change change : changes) {
                if (change.comment != null) {
                    if (comments.containsKey(change.comment.id)) {
                        IssueModel.Change original = (IssueModel.Change)comments.get(change.comment.id);
                        IssueModel.Change clone = DeepCopier.copy(original);
                        clone.comment.text = change.comment.text;
                        clone.comment.deleted = change.comment.deleted;
                        int idx = effectiveChanges.indexOf(original);
                        effectiveChanges.remove(original);
                        effectiveChanges.add(idx, clone);
                        comments.put(clone.comment.id, clone);
                        continue;
                    }
                    effectiveChanges.add(change);
                    comments.put(change.comment.id, change);
                    continue;
                }
                effectiveChanges.add(change);
            }
            issue = new IssueModel();
            for (IssueModel.Change change : effectiveChanges) {
                issue.applyChange(change);
            }
        } else {
            issue = new IssueModel();
            for (IssueModel.Change change : changes) {
                issue.applyChange(change);
            }
        }
        return issue;
    }

    public static IssueModel.Attachment getIssueAttachment(Repository repository, String issueId, String filename) {
        RefModel issuesBranch = IssueUtils.getIssuesBranch(repository);
        if (issuesBranch == null) {
            return null;
        }
        if (StringUtils.isEmpty(issueId)) {
            return null;
        }
        IssueModel issue = IssueUtils.getIssue(repository, issueId, true);
        IssueModel.Attachment attachment = issue.getAttachment(filename);
        if (attachment == null) {
            return null;
        }
        String issuePath = IssueUtils.getIssuePath(issueId);
        RevTree tree = JGitUtils.getCommit(repository, GB_ISSUES).getTree();
        byte[] content = JGitUtils.getByteContent(repository, tree, issuePath + "/" + attachment.id);
        attachment.content = content;
        attachment.size = content.length;
        return attachment;
    }

    public static IssueModel createIssue(Repository repository, IssueModel.Change change) {
        RefModel issuesBranch = IssueUtils.getIssuesBranch(repository);
        if (issuesBranch == null) {
            JGitUtils.createOrphanBranch(repository, "gb-issues", null);
        }
        if (StringUtils.isEmpty(change.author)) {
            throw new RuntimeException("Must specify a change author!");
        }
        if (!change.hasField(IssueModel.Field.Summary)) {
            throw new RuntimeException("Must specify a summary!");
        }
        if (!change.hasField(IssueModel.Field.Description)) {
            throw new RuntimeException("Must specify a description!");
        }
        change.setField(IssueModel.Field.Reporter, change.author);
        String issueId = StringUtils.getSHA1(change.created.toString() + change.author + change.getString(IssueModel.Field.Summary) + change.getField(IssueModel.Field.Description));
        change.setField(IssueModel.Field.Id, issueId);
        change.code = (char)43;
        boolean success = IssueUtils.commit(repository, issueId, change);
        if (success) {
            return IssueUtils.getIssue(repository, issueId, false);
        }
        return null;
    }

    public static boolean updateIssue(Repository repository, String issueId, IssueModel.Change change) {
        IssueModel.Status status;
        boolean success = false;
        RefModel issuesBranch = IssueUtils.getIssuesBranch(repository);
        if (issuesBranch == null) {
            throw new RuntimeException("gb-issues branch does not exist!");
        }
        if (change == null) {
            throw new RuntimeException("change can not be null!");
        }
        if (StringUtils.isEmpty(change.author)) {
            throw new RuntimeException("must specify a change author!");
        }
        change.code = (char)61;
        if (change.hasField(IssueModel.Field.Status) && (status = IssueModel.Status.fromObject(change.getField(IssueModel.Field.Status))).isClosed()) {
            change.code = (char)120;
        }
        success = IssueUtils.commit(repository, issueId, change);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean deleteIssue(Repository repository, String issueId, String author) {
        boolean success = false;
        RefModel issuesBranch = IssueUtils.getIssuesBranch(repository);
        if (issuesBranch == null) {
            throw new RuntimeException("gb-issues branch does not exist!");
        }
        if (StringUtils.isEmpty(issueId)) {
            throw new RuntimeException("must specify an issue id!");
        }
        String issuePath = IssueUtils.getIssuePath(issueId);
        String message = "- " + issueId;
        try {
            ObjectId headId = repository.resolve("refs/heads/gb-issues^{commit}");
            ObjectInserter odi = repository.newObjectInserter();
            try {
                DirCache index = DirCache.newInCore();
                DirCacheBuilder dcBuilder = index.builder();
                TreeWalk treeWalk = new TreeWalk(repository);
                int hIdx = -1;
                if (headId != null) {
                    hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId));
                }
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String path = treeWalk.getPathString();
                    CanonicalTreeParser hTree = null;
                    if (hIdx != -1) {
                        hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    }
                    if (path.startsWith(issuePath) || hTree == null) continue;
                    DirCacheEntry dcEntry = new DirCacheEntry(path);
                    dcEntry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                    dcEntry.setFileMode(hTree.getEntryFileMode());
                    dcBuilder.add(dcEntry);
                }
                treeWalk.release();
                dcBuilder.finish();
                ObjectId indexTreeId = index.writeTree(odi);
                PersonIdent ident = new PersonIdent(author, "gitblit@localhost");
                CommitBuilder commit = new CommitBuilder();
                commit.setAuthor(ident);
                commit.setCommitter(ident);
                commit.setEncoding("UTF-8");
                commit.setMessage(message);
                commit.setParentId((AnyObjectId)headId);
                commit.setTreeId((AnyObjectId)indexTreeId);
                ObjectId commitId = odi.insert(commit);
                odi.flush();
                RevWalk revWalk = new RevWalk(repository);
                try {
                    RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                    RefUpdate ru = repository.updateRef(GB_ISSUES);
                    ru.setNewObjectId((AnyObjectId)commitId);
                    ru.setExpectedOldObjectId((AnyObjectId)headId);
                    ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                    RefUpdate.Result rc = ru.forceUpdate();
                    switch (rc) {
                        case NEW: 
                        case FORCED: 
                        case FAST_FORWARD: {
                            success = true;
                            return success;
                        }
                        case REJECTED: 
                        case LOCK_FAILURE: {
                            throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                        }
                        default: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, GB_ISSUES, commitId.toString(), rc));
                        }
                    }
                }
                finally {
                    revWalk.release();
                }
            }
            finally {
                odi.release();
            }
        }
        catch (Throwable t) {
            IssueUtils.error(t, repository, "Failed to delete issue {1} to {0}", issueId);
        }
        return success;
    }

    public static boolean changeComment(Repository repository, IssueModel issue, IssueModel.Change change, String author, String comment) {
        IssueModel.Change revision = new IssueModel.Change(author);
        revision.comment(comment);
        revision.comment.id = change.comment.id;
        return IssueUtils.updateIssue(repository, issue.id, revision);
    }

    public static boolean deleteComment(Repository repository, IssueModel issue, IssueModel.Change change, String author) {
        IssueModel.Change deletion = new IssueModel.Change(author);
        deletion.comment(change.comment.text);
        deletion.comment.id = change.comment.id;
        deletion.comment.deleted = true;
        return IssueUtils.updateIssue(repository, issue.id, deletion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean commit(Repository repository, String issueId, IssueModel.Change change) {
        boolean success = false;
        try {
            if (change.hasAttachments()) {
                for (IssueModel.Attachment attachment : change.attachments) {
                    if (ArrayUtils.isEmpty(attachment.content)) continue;
                    byte[] prefix = (change.created.toString() + change.author).getBytes();
                    byte[] bytes = new byte[prefix.length + attachment.content.length];
                    System.arraycopy(prefix, 0, bytes, 0, prefix.length);
                    System.arraycopy(attachment.content, 0, bytes, prefix.length, attachment.content.length);
                    attachment.id = "attachment-" + StringUtils.getSHA1(bytes);
                }
            }
            Gson gson = JsonUtils.gson(new JsonUtils.ExcludeField("com.gitblit.models.IssueModel$Attachment.content"));
            String json = gson.toJson((Object)change);
            String issuePath = IssueUtils.getIssuePath(issueId);
            String message = change.code + " " + issueId + "\n\n" + json;
            switch (change.code) {
                case '+': {
                    IssueModel.Attachment placeholder = new IssueModel.Attachment("issue");
                    placeholder.id = placeholder.name;
                    placeholder.content = "DO NOT REMOVE".getBytes("UTF-8");
                    change.addAttachment(placeholder);
                    break;
                }
                default: {
                    String changeId = StringUtils.getSHA1(json);
                    IssueModel.Attachment placeholder = new IssueModel.Attachment("change-" + changeId);
                    placeholder.id = placeholder.name;
                    placeholder.content = "REMOVABLE".getBytes("UTF-8");
                    change.addAttachment(placeholder);
                    break;
                }
            }
            ObjectId headId = repository.resolve("refs/heads/gb-issues^{commit}");
            ObjectInserter odi = repository.newObjectInserter();
            try {
                DirCache index = IssueUtils.createIndex(repository, headId, issuePath, change);
                ObjectId indexTreeId = index.writeTree(odi);
                PersonIdent ident = new PersonIdent(change.author, "gitblit@localhost");
                CommitBuilder commit = new CommitBuilder();
                commit.setAuthor(ident);
                commit.setCommitter(ident);
                commit.setEncoding("UTF-8");
                commit.setMessage(message);
                commit.setParentId((AnyObjectId)headId);
                commit.setTreeId((AnyObjectId)indexTreeId);
                ObjectId commitId = odi.insert(commit);
                odi.flush();
                RevWalk revWalk = new RevWalk(repository);
                try {
                    RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                    RefUpdate ru = repository.updateRef(GB_ISSUES);
                    ru.setNewObjectId((AnyObjectId)commitId);
                    ru.setExpectedOldObjectId((AnyObjectId)headId);
                    ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                    RefUpdate.Result rc = ru.forceUpdate();
                    switch (rc) {
                        case NEW: 
                        case FORCED: 
                        case FAST_FORWARD: {
                            success = true;
                            return success;
                        }
                        case REJECTED: 
                        case LOCK_FAILURE: {
                            throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                        }
                        default: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, GB_ISSUES, commitId.toString(), rc));
                        }
                    }
                }
                finally {
                    revWalk.release();
                }
            }
            finally {
                odi.release();
            }
        }
        catch (Throwable t) {
            IssueUtils.error(t, repository, "Failed to commit issue {1} to {0}", issueId);
        }
        return success;
    }

    static String getIssuePath(String issueId) {
        return issueId.substring(0, 2) + "/" + issueId.substring(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirCache createIndex(Repository repo, ObjectId headId, String issuePath, IssueModel.Change change) throws IOException {
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder dcBuilder = inCoreIndex.builder();
        ObjectInserter inserter = repo.newObjectInserter();
        TreeSet<String> ignorePaths = new TreeSet<String>();
        try {
            String path;
            if (change.hasAttachments()) {
                for (IssueModel.Attachment attachment : change.attachments) {
                    path = issuePath + "/" + attachment.id;
                    ignorePaths.add(path);
                    DirCacheEntry dcEntry = new DirCacheEntry(path);
                    dcEntry.setLength(attachment.content.length);
                    dcEntry.setLastModified(change.created.getTime());
                    dcEntry.setFileMode(FileMode.REGULAR_FILE);
                    dcEntry.setObjectId((AnyObjectId)inserter.insert(3, attachment.content));
                    dcBuilder.add(dcEntry);
                }
            }
            TreeWalk treeWalk = new TreeWalk(repo);
            int hIdx = -1;
            if (headId != null) {
                hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(repo).parseTree((AnyObjectId)headId));
            }
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                path = treeWalk.getPathString();
                CanonicalTreeParser hTree = null;
                if (hIdx != -1) {
                    hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                }
                if (ignorePaths.contains(path) || hTree == null) continue;
                DirCacheEntry dcEntry = new DirCacheEntry(path);
                dcEntry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                dcEntry.setFileMode(hTree.getEntryFileMode());
                dcBuilder.add(dcEntry);
            }
            treeWalk.release();
            dcBuilder.finish();
        }
        finally {
            inserter.release();
        }
        return inCoreIndex;
    }

    public static interface IssueFilter {
        public boolean accept(IssueModel var1);
    }
}

