/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.PathModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.TicketModel;
import com.gitblit.utils.JGitUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicgitUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(TicgitUtils.class);

    public static RefModel getTicketsBranch(Repository repository) {
        return JGitUtils.getBranch(repository, "ticgit");
    }

    public static List<TicketModel> getTickets(Repository repository) {
        RefModel ticgitBranch = TicgitUtils.getTicketsBranch(repository);
        if (ticgitBranch == null) {
            return null;
        }
        RevCommit commit = (RevCommit)ticgitBranch.referencedObject;
        List<PathModel> paths = JGitUtils.getFilesInPath(repository, null, commit);
        ArrayList<TicketModel> tickets = new ArrayList<TicketModel>();
        for (PathModel ticketFolder : paths) {
            if (!ticketFolder.isTree()) continue;
            try {
                TicketModel t = new TicketModel(ticketFolder.name);
                TicgitUtils.loadTicketContents(repository, ticgitBranch, t);
                tickets.add(t);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to get a ticket!", t);
            }
        }
        Collections.sort(tickets);
        Collections.reverse(tickets);
        return tickets;
    }

    public static TicketModel getTicket(Repository repository, String ticketFolder) {
        RefModel ticketsBranch = TicgitUtils.getTicketsBranch(repository);
        if (ticketsBranch != null) {
            try {
                TicketModel ticket = new TicketModel(ticketFolder);
                TicgitUtils.loadTicketContents(repository, ticketsBranch, ticket);
                return ticket;
            }
            catch (Throwable t) {
                LOGGER.error("Failed to get ticket " + ticketFolder, t);
            }
        }
        return null;
    }

    private static void loadTicketContents(Repository repository, RefModel ticketsBranch, TicketModel ticket) {
        RevCommit commit = (RevCommit)ticketsBranch.referencedObject;
        List<PathModel> ticketFiles = JGitUtils.getFilesInPath(repository, ticket.name, commit);
        for (PathModel file : ticketFiles) {
            String content = JGitUtils.getStringContent(repository, commit.getTree(), file.path, new String[0]).trim();
            if (file.name.equals("TICKET_ID")) {
                ticket.id = content;
                continue;
            }
            if (file.name.equals("TITLE")) {
                ticket.title = content;
                continue;
            }
            String[] chunks = file.name.split("_");
            if (chunks[0].equals("ASSIGNED")) {
                ticket.handler = content;
                continue;
            }
            if (chunks[0].equals("COMMENT")) {
                try {
                    TicketModel.Comment c = new TicketModel.Comment(file.name, content);
                    ticket.comments.add(c);
                }
                catch (ParseException e) {
                    LOGGER.error("Failed to parse ticket comment", (Throwable)e);
                }
                continue;
            }
            if (chunks[0].equals("TAG")) {
                if (content.startsWith("TAG_")) {
                    ticket.tags.add(content.substring(4));
                    continue;
                }
                ticket.tags.add(content);
                continue;
            }
            if (!chunks[0].equals("STATE")) continue;
            ticket.state = content;
        }
        Collections.sort(ticket.comments);
    }
}

