/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.StringUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;

public class TimeUtils {
    public static final long MIN = 60000L;
    public static final long HALFHOUR = 1800000L;
    public static final long ONEHOUR = 3600000L;
    public static final long ONEDAY = 86400000L;
    public static final long ONEYEAR = 31536000000L;
    private final ResourceBundle translation;

    public TimeUtils() {
        this(null);
    }

    public TimeUtils(ResourceBundle translation) {
        this.translation = translation;
    }

    public static boolean isToday(Date date) {
        return System.currentTimeMillis() - date.getTime() < 86400000L;
    }

    public static boolean isYesterday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(cal.getTime()).equals(df.format(date));
    }

    public String duration(int days) {
        String yearsString;
        if (days <= 60) {
            return days > 1 ? this.translate(days, "gb.duration.days", "{0} days") : this.translate("gb.duration.oneDay", "1 day");
        }
        if (days < 365) {
            int rem = days % 30;
            return this.translate(days / 30 + (rem >= 15 ? 1 : 0), "gb.duration.months", "{0} months");
        }
        int years = days / 365;
        int rem = days % 365;
        String string = yearsString = years > 1 ? this.translate(years, "gb.duration.years", "{0} years") : this.translate("gb.duration.oneYear", "1 year");
        if (rem < 30) {
            if (rem == 0) {
                return yearsString;
            }
            return yearsString + (rem >= 15 ? ", " + this.translate("gb.duration.oneMonth", "1 month") : "");
        }
        int months = rem / 30;
        int remDays = rem % 30;
        if (remDays >= 15) {
            ++months;
        }
        String monthsString = yearsString + ", " + (months > 1 ? this.translate(months, "gb.duration.months", "{0} months") : this.translate("gb.duration.oneMonth", "1 month"));
        return monthsString;
    }

    public static int minutesAgo(Date date, long endTime, boolean roundup) {
        long diff = endTime - date.getTime();
        int mins = (int)(diff / 60000L);
        if (roundup && diff % 60000L >= 30L) {
            ++mins;
        }
        return mins;
    }

    public static int minutesAgo(Date date, boolean roundup) {
        return TimeUtils.minutesAgo(date, System.currentTimeMillis(), roundup);
    }

    public static int hoursAgo(Date date, boolean roundup) {
        long diff = System.currentTimeMillis() - date.getTime();
        int hours = (int)(diff / 3600000L);
        if (roundup && diff % 3600000L >= 1800000L) {
            ++hours;
        }
        return hours;
    }

    public static int daysAgo(Date date) {
        long today = 86400000L * (System.currentTimeMillis() / 86400000L);
        long day = 86400000L * (date.getTime() / 86400000L);
        long diff = today - day;
        int days = (int)(diff / 86400000L);
        return days;
    }

    public String today() {
        return this.translate("gb.time.today", "today");
    }

    public String yesterday() {
        return this.translate("gb.time.yesterday", "yesterday");
    }

    public String timeAgo(Date date) {
        return this.timeAgo(date, false);
    }

    public String timeAgoCss(Date date) {
        return this.timeAgo(date, true);
    }

    private String timeAgo(Date date, boolean css) {
        if (TimeUtils.isToday(date) || TimeUtils.isYesterday(date)) {
            int mins = TimeUtils.minutesAgo(date, true);
            if (mins >= 120) {
                if (css) {
                    return "age1";
                }
                int hours = TimeUtils.hoursAgo(date, true);
                if (hours > 23) {
                    return this.yesterday();
                }
                return this.translate(hours, "gb.time.hoursAgo", "{0} hours ago");
            }
            if (css) {
                return "age0";
            }
            if (mins > 2) {
                return this.translate(mins, "gb.time.minsAgo", "{0} mins ago");
            }
            return this.translate("gb.time.justNow", "just now");
        }
        int days = TimeUtils.daysAgo(date);
        if (css) {
            if (days <= 7) {
                return "age2";
            }
            if (days <= 30) {
                return "age3";
            }
            return "age4";
        }
        if (days < 365) {
            if (days <= 30) {
                return this.translate(days, "gb.time.daysAgo", "{0} days ago");
            }
            if (days <= 90) {
                int weeks = days / 7;
                if (weeks == 12) {
                    return this.translate(3, "gb.time.monthsAgo", "{0} months ago");
                }
                return this.translate(weeks, "gb.time.weeksAgo", "{0} weeks ago");
            }
            int months = days / 30;
            int weeks = days % 30 / 7;
            if (weeks >= 2) {
                ++months;
            }
            return this.translate(months, "gb.time.monthsAgo", "{0} months ago");
        }
        if (days == 365) {
            return this.translate("gb.time.oneYearAgo", "1 year ago");
        }
        int yr = days / 365;
        int months = yr * 12 + (days %= 365) / 30;
        if (months > 23) {
            return this.translate(yr, "gb.time.yearsAgo", "{0} years ago");
        }
        return this.translate(months, "gb.time.monthsAgo", "{0} months ago");
    }

    public String inFuture(Date date) {
        long diff = date.getTime() - System.currentTimeMillis();
        if (diff > 86400000L) {
            double days = (double)diff / 8.64E7;
            return this.translate((int)Math.round(days), "gb.time.inDays", "in {0} days");
        }
        double hours = (double)diff / 3600000.0;
        if (hours > 2.0) {
            return this.translate((int)Math.round(hours), "gb.time.inHours", "in {0} hours");
        }
        int mins = (int)(diff / 60000L);
        return this.translate(mins, "gb.time.inMinutes", "in {0} minutes");
    }

    private String translate(String key, String defaultValue) {
        String aValue;
        String value = defaultValue;
        if (this.translation != null && this.translation.containsKey(key) && !StringUtils.isEmpty(aValue = this.translation.getString(key))) {
            value = aValue;
        }
        return value;
    }

    private String translate(int val, String key, String defaultPattern) {
        String aValue;
        String pattern = defaultPattern;
        if (this.translation != null && this.translation.containsKey(key) && !StringUtils.isEmpty(aValue = this.translation.getString(key))) {
            pattern = aValue;
        }
        return MessageFormat.format(pattern, val);
    }

    public static int convertFrequencyToMinutes(String frequency) {
        frequency = frequency.toLowerCase();
        int mins = 60;
        if (!StringUtils.isEmpty(frequency)) {
            try {
                String str = frequency.trim();
                if (frequency.indexOf(32) > -1) {
                    str = str.substring(0, str.indexOf(32)).trim();
                }
                mins = (int)Float.parseFloat(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (mins < 5) {
                mins = 5;
            }
        }
        if (frequency.indexOf("day") > -1) {
            mins *= 1440;
        } else if (frequency.indexOf("hour") > -1) {
            mins *= 60;
        }
        return mins;
    }
}

