/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.GitBlit;
import com.gitblit.wicket.AuthorizationStrategy;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitParamUrlCodingStrategy;
import com.gitblit.wicket.pages.ActivityPage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobDiffPage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.BranchesPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.DocsPage;
import com.gitblit.wicket.pages.FederationRegistrationPage;
import com.gitblit.wicket.pages.ForkPage;
import com.gitblit.wicket.pages.ForksPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.GravatarProfilePage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.LuceneSearchPage;
import com.gitblit.wicket.pages.MarkdownPage;
import com.gitblit.wicket.pages.MetricsPage;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.ProjectsPage;
import com.gitblit.wicket.pages.RawPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.ReviewProposalPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TagPage;
import com.gitblit.wicket.pages.TagsPage;
import com.gitblit.wicket.pages.TicketPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.pages.UsersPage;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;

public class GitBlitWebApp
extends WebApplication {
    public void init() {
        boolean useAuthentication;
        super.init();
        boolean bl = useAuthentication = GitBlit.getBoolean("web.authenticateViewPages", false) || GitBlit.getBoolean("web.authenticateAdminPages", false);
        if (useAuthentication) {
            AuthorizationStrategy authStrategy = new AuthorizationStrategy();
            this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)authStrategy);
            this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)authStrategy);
        }
        if (GitBlit.getBoolean("web.useClientTimezone", false)) {
            this.getRequestCycleSettings().setGatherExtendedBrowserInfo(true);
        }
        if (!GitBlit.isDebugMode()) {
            this.getResourceSettings().setDefaultCacheDuration(7776000);
        }
        this.mount("/summary", SummaryPage.class, "r");
        this.mount("/log", LogPage.class, "r", "h");
        this.mount("/tags", TagsPage.class, "r");
        this.mount("/branches", BranchesPage.class, "r");
        this.mount("/commit", CommitPage.class, "r", "h");
        this.mount("/tag", TagPage.class, "r", "h");
        this.mount("/tree", TreePage.class, "r", "h", "f");
        this.mount("/blob", BlobPage.class, "r", "h", "f");
        this.mount("/raw", RawPage.class, "r", "h", "f");
        this.mount("/blobdiff", BlobDiffPage.class, "r", "h", "f");
        this.mount("/commitdiff", CommitDiffPage.class, "r", "h");
        this.mount("/patch", PatchPage.class, "r", "h", "f");
        this.mount("/history", HistoryPage.class, "r", "h", "f");
        this.mount("/search", GitSearchPage.class, new String[0]);
        this.mount("/metrics", MetricsPage.class, "r");
        this.mount("/blame", BlamePage.class, "r", "h", "f");
        this.mount("/users", UsersPage.class, new String[0]);
        this.mount("/tickets", TicketsPage.class, "r");
        this.mount("/ticket", TicketPage.class, "r", "f");
        this.mount("/docs", DocsPage.class, "r");
        this.mount("/markdown", MarkdownPage.class, "r", "h", "f");
        this.mount("/proposal", ReviewProposalPage.class, "t");
        this.mount("/registration", FederationRegistrationPage.class, "u", "n");
        this.mount("/activity", ActivityPage.class, "r", "h");
        this.mount("/gravatar", GravatarProfilePage.class, "h");
        this.mount("/lucene", LuceneSearchPage.class, new String[0]);
        this.mount("/project", ProjectPage.class, "p");
        this.mount("/projects", ProjectsPage.class, new String[0]);
        this.mount("/user", UserPage.class, "user");
        this.mount("/forks", ForksPage.class, "r");
        this.mount("/fork", ForkPage.class, "r");
    }

    private void mount(String location, Class<? extends WebPage> clazz, String ... parameters) {
        if (parameters == null) {
            parameters = new String[]{};
        }
        if (!GitBlit.getBoolean("web.mountParameters", true)) {
            parameters = new String[]{};
        }
        this.mount((IRequestTargetUrlCodingStrategy)new GitblitParamUrlCodingStrategy(location, clazz, parameters));
    }

    public Class<? extends Page> getHomePage() {
        return RepositoriesPage.class;
    }

    public final Session newSession(Request request, Response response) {
        return new GitBlitWebSession(request);
    }

    public final String getConfigurationType() {
        if (GitBlit.isDebugMode()) {
            return "development";
        }
        return "deployment";
    }

    public static GitBlitWebApp get() {
        return (GitBlitWebApp)WebApplication.get();
    }
}

