/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.Constants;
import com.gitblit.models.UserModel;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RedirectToUrlException;
import org.apache.wicket.Request;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;

public final class GitBlitWebSession
extends WebSession {
    private static final long serialVersionUID = 1L;
    protected TimeZone timezone;
    private UserModel user;
    private String errorMessage;
    private String requestUrl;
    private AtomicBoolean isForking = new AtomicBoolean();
    public Constants.AuthenticationType authenticationType = Constants.AuthenticationType.CREDENTIALS;

    public GitBlitWebSession(Request request) {
        super(request);
    }

    public void invalidate() {
        super.invalidate();
        this.user = null;
    }

    public void cacheRequest(Class<? extends Page> pageClass) {
        Request req = WebRequestCycle.get().getRequest();
        Map params = req.getRequestParameters().getParameters();
        PageParameters pageParams = new PageParameters(params);
        String relativeUrl = ((Object)WebRequestCycle.get().urlFor(pageClass, pageParams)).toString();
        this.requestUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
        if (this.isTemporary()) {
            this.bind();
        }
    }

    public boolean continueRequest() {
        if (this.requestUrl != null) {
            String url = this.requestUrl;
            this.requestUrl = null;
            throw new RedirectToUrlException(url);
        }
        return false;
    }

    public boolean isLoggedIn() {
        return this.user != null;
    }

    public boolean canAdmin() {
        if (this.user == null) {
            return false;
        }
        return this.user.canAdmin();
    }

    public String getUsername() {
        return this.user == null ? "anonymous" : this.user.username;
    }

    public UserModel getUser() {
        return this.user;
    }

    public void setUser(UserModel user) {
        this.user = user;
    }

    public TimeZone getTimezone() {
        if (this.timezone == null) {
            this.timezone = ((WebClientInfo)this.getClientInfo()).getProperties().getTimeZone();
        }
        if (this.timezone == null) {
            this.timezone = TimeZone.getDefault();
        }
        return this.timezone;
    }

    public void cacheErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String clearErrorMessage() {
        String msg = this.errorMessage;
        this.errorMessage = null;
        return msg;
    }

    public boolean isForking() {
        return this.isForking.get();
    }

    public void isForking(boolean val) {
        this.isForking.set(val);
    }

    public static GitBlitWebSession get() {
        return (GitBlitWebSession)Session.get();
    }
}

