/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.GitBlit;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.MixedParamUrlCodingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitParamUrlCodingStrategy
extends MixedParamUrlCodingStrategy {
    private Logger logger = LoggerFactory.getLogger(GitblitParamUrlCodingStrategy.class);

    public <C extends Page> GitblitParamUrlCodingStrategy(String mountPath, Class<C> bookmarkablePageClass, String[] parameterNames) {
        super(mountPath, bookmarkablePageClass, parameterNames);
    }

    protected String urlEncodePathComponent(String string) {
        char altChar = GitBlit.getChar("web.forwardSlashCharacter", '/');
        if (altChar != '/') {
            string = string.replace('/', altChar);
        }
        return super.urlEncodePathComponent(string);
    }

    protected String urlDecodePathComponent(String value) {
        char altChar = GitBlit.getChar("web.forwardSlashCharacter", '/');
        if (altChar != '/') {
            value = value.replace(altChar, '/');
        }
        return super.urlDecodePathComponent(value);
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        String parametersFragment = requestParameters.getPath().substring(this.getMountPath().length());
        this.logger.debug(MessageFormat.format("REQ: {0} PARAMS {1}", this.getMountPath(), parametersFragment));
        PageParameters parameters = new PageParameters((Map)this.decodeParameters(parametersFragment, requestParameters.getParameters()));
        return super.decode(requestParameters);
    }
}

