/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.FederationModel;
import com.gitblit.models.Metric;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Request;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.resource.ContextRelativeResource;
import org.eclipse.jgit.diff.DiffEntry;
import org.wicketstuff.googlecharts.AbstractChartData;
import org.wicketstuff.googlecharts.IChartData;

public class WicketUtils {
    public static void setCssClass(Component container, String value) {
        container.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)value)});
    }

    public static void setCssStyle(Component container, String value) {
        container.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)value)});
    }

    public static void setCssBackground(Component container, String value) {
        String background = MessageFormat.format("background-color:{0};", StringUtils.getColor(value));
        container.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)background)});
    }

    public static void setHtmlTooltip(Component container, String value) {
        container.add(new IBehavior[]{new SimpleAttributeModifier("title", (CharSequence)value)});
    }

    public static void setInputPlaceholder(Component container, String value) {
        container.add(new IBehavior[]{new SimpleAttributeModifier("placeholder", (CharSequence)value)});
    }

    public static void setChangeTypeCssClass(Component container, DiffEntry.ChangeType type) {
        switch (type) {
            case ADD: {
                WicketUtils.setCssClass(container, "addition");
                break;
            }
            case COPY: 
            case RENAME: {
                WicketUtils.setCssClass(container, "rename");
                break;
            }
            case DELETE: {
                WicketUtils.setCssClass(container, "deletion");
                break;
            }
            case MODIFY: {
                WicketUtils.setCssClass(container, "modification");
            }
        }
    }

    public static void setTicketCssClass(Component container, String state) {
        String css = null;
        if (state.equals("open")) {
            css = "label label-important";
        } else if (state.equals("hold")) {
            css = "label label-warning";
        } else if (state.equals("resolved")) {
            css = "label label-success";
        } else if (state.equals("invalid")) {
            css = "label";
        }
        if (css != null) {
            WicketUtils.setCssClass(container, css);
        }
    }

    public static void setAlternatingBackground(Component c, int i) {
        String clazz = i % 2 == 0 ? "light" : "dark";
        WicketUtils.setCssClass(c, clazz);
    }

    public static Label createAuthorLabel(String wicketId, String author) {
        Label label = new Label(wicketId, author);
        WicketUtils.setHtmlTooltip((Component)label, author);
        return label;
    }

    public static ContextImage getPullStatusImage(String wicketId, Constants.FederationPullStatus status) {
        String filename = null;
        switch (status) {
            case MIRRORED: 
            case PULLED: {
                filename = "bullet_green.png";
                break;
            }
            case SKIPPED: {
                filename = "bullet_yellow.png";
                break;
            }
            case FAILED: {
                filename = "bullet_red.png";
                break;
            }
            case EXCLUDED: {
                filename = "bullet_white.png";
                break;
            }
            default: {
                filename = "bullet_black.png";
            }
        }
        return WicketUtils.newImage(wicketId, filename, status.name());
    }

    public static ContextImage getFileImage(String wicketId, String filename) {
        if ((filename = filename.toLowerCase()).endsWith(".java")) {
            return WicketUtils.newImage(wicketId, "file_java_16x16.png");
        }
        if (filename.endsWith(".rb")) {
            return WicketUtils.newImage(wicketId, "file_ruby_16x16.png");
        }
        if (filename.endsWith(".php")) {
            return WicketUtils.newImage(wicketId, "file_php_16x16.png");
        }
        if (filename.endsWith(".cs")) {
            return WicketUtils.newImage(wicketId, "file_cs_16x16.png");
        }
        if (filename.endsWith(".cpp")) {
            return WicketUtils.newImage(wicketId, "file_cpp_16x16.png");
        }
        if (filename.endsWith(".c")) {
            return WicketUtils.newImage(wicketId, "file_c_16x16.png");
        }
        if (filename.endsWith(".h")) {
            return WicketUtils.newImage(wicketId, "file_h_16x16.png");
        }
        if (filename.endsWith(".sln")) {
            return WicketUtils.newImage(wicketId, "file_vs_16x16.png");
        }
        if (filename.endsWith(".csv") || filename.endsWith(".xls") || filename.endsWith(".xlsx")) {
            return WicketUtils.newImage(wicketId, "file_excel_16x16.png");
        }
        if (filename.endsWith(".doc") || filename.endsWith(".docx")) {
            return WicketUtils.newImage(wicketId, "file_word_16x16.png");
        }
        if (filename.endsWith(".ppt")) {
            return WicketUtils.newImage(wicketId, "file_ppt_16x16.png");
        }
        if (filename.endsWith(".zip")) {
            return WicketUtils.newImage(wicketId, "file_zip_16x16.png");
        }
        if (filename.endsWith(".pdf")) {
            return WicketUtils.newImage(wicketId, "file_acrobat_16x16.png");
        }
        if (filename.endsWith(".htm") || filename.endsWith(".html")) {
            return WicketUtils.newImage(wicketId, "file_world_16x16.png");
        }
        if (filename.endsWith(".xml")) {
            return WicketUtils.newImage(wicketId, "file_code_16x16.png");
        }
        if (filename.endsWith(".properties")) {
            return WicketUtils.newImage(wicketId, "file_settings_16x16.png");
        }
        List<String> mdExtensions = GitBlit.getStrings("web.markdownExtensions");
        for (String ext : mdExtensions) {
            if (!filename.endsWith('.' + ext.toLowerCase())) continue;
            return WicketUtils.newImage(wicketId, "file_world_16x16.png");
        }
        return WicketUtils.newImage(wicketId, "file_16x16.png");
    }

    public static ContextImage getRegistrationImage(String wicketId, FederationModel registration, Component c) {
        if (registration.isResultData()) {
            return WicketUtils.newImage(wicketId, "information_16x16.png", c.getString("gb.federationResults"));
        }
        return WicketUtils.newImage(wicketId, "arrow_left.png", c.getString("gb.federationRegistration"));
    }

    public static ContextImage newClearPixel(String wicketId) {
        return WicketUtils.newImage(wicketId, "pixel.png");
    }

    public static ContextImage newBlankImage(String wicketId) {
        return WicketUtils.newImage(wicketId, "blank.png");
    }

    public static ContextImage newImage(String wicketId, String file) {
        return WicketUtils.newImage(wicketId, file, null);
    }

    public static ContextImage newImage(String wicketId, String file, String tooltip) {
        ContextImage img = new ContextImage(wicketId, file);
        if (!StringUtils.isEmpty(tooltip)) {
            WicketUtils.setHtmlTooltip((Component)img, tooltip);
        }
        return img;
    }

    public static Label newIcon(String wicketId, String css) {
        Label lbl = new Label(wicketId);
        WicketUtils.setCssClass((Component)lbl, css);
        return lbl;
    }

    public static Label newBlankIcon(String wicketId) {
        Label lbl = new Label(wicketId);
        WicketUtils.setCssClass((Component)lbl, "");
        lbl.setRenderBodyOnly(true);
        return lbl;
    }

    public static ContextRelativeResource getResource(String file) {
        return new ContextRelativeResource(file);
    }

    public static String getGitblitURL(Request request) {
        HttpServletRequest req = ((WebRequest)request).getHttpServletRequest();
        return HttpUtils.getGitblitURL(req);
    }

    public static HeaderContributor syndicationDiscoveryLink(final String feedTitle, final String url) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                String contentType = "application/rss+xml";
                StringBuilder buffer = new StringBuilder();
                buffer.append("<link rel=\"alternate\" ");
                buffer.append("type=\"").append(contentType).append("\" ");
                buffer.append("title=\"").append(feedTitle).append("\" ");
                buffer.append("href=\"").append(url).append("\" />");
                response.renderString((CharSequence)buffer.toString());
            }
        });
    }

    public static PageParameters newTokenParameter(String token) {
        return new PageParameters("t=" + token);
    }

    public static PageParameters newRegistrationParameter(String url, String name) {
        return new PageParameters("u=" + url + ",n=" + name);
    }

    public static PageParameters newUsernameParameter(String username) {
        return new PageParameters("user=" + username);
    }

    public static PageParameters newTeamnameParameter(String teamname) {
        return new PageParameters("team=" + teamname);
    }

    public static PageParameters newProjectParameter(String projectName) {
        return new PageParameters("p=" + projectName);
    }

    public static PageParameters newRepositoryParameter(String repositoryName) {
        return new PageParameters("r=" + repositoryName);
    }

    public static PageParameters newObjectParameter(String objectId) {
        return new PageParameters("h=" + objectId);
    }

    public static PageParameters newObjectParameter(String repositoryName, String objectId) {
        if (StringUtils.isEmpty(objectId)) {
            return WicketUtils.newRepositoryParameter(repositoryName);
        }
        return new PageParameters("r=" + repositoryName + ",h=" + objectId);
    }

    public static PageParameters newPathParameter(String repositoryName, String objectId, String path) {
        if (StringUtils.isEmpty(path)) {
            return WicketUtils.newObjectParameter(repositoryName, objectId);
        }
        if (StringUtils.isEmpty(objectId)) {
            return new PageParameters("r=" + repositoryName + ",f=" + path);
        }
        return new PageParameters("r=" + repositoryName + ",h=" + objectId + ",f=" + path);
    }

    public static PageParameters newLogPageParameter(String repositoryName, String objectId, int pageNumber) {
        if (pageNumber <= 1) {
            return WicketUtils.newObjectParameter(repositoryName, objectId);
        }
        if (StringUtils.isEmpty(objectId)) {
            return new PageParameters("r=" + repositoryName + ",pg=" + pageNumber);
        }
        return new PageParameters("r=" + repositoryName + ",h=" + objectId + ",pg=" + pageNumber);
    }

    public static PageParameters newHistoryPageParameter(String repositoryName, String objectId, String path, int pageNumber) {
        if (pageNumber <= 1) {
            return WicketUtils.newObjectParameter(repositoryName, objectId);
        }
        if (StringUtils.isEmpty(objectId)) {
            return new PageParameters("r=" + repositoryName + ",f=" + path + ",pg=" + pageNumber);
        }
        return new PageParameters("r=" + repositoryName + ",h=" + objectId + ",f=" + path + ",pg=" + pageNumber);
    }

    public static PageParameters newBlobDiffParameter(String repositoryName, String baseCommitId, String commitId, String path) {
        if (StringUtils.isEmpty(commitId)) {
            return new PageParameters("r=" + repositoryName + ",f=" + path + ",hb=" + baseCommitId);
        }
        return new PageParameters("r=" + repositoryName + ",h=" + commitId + ",f=" + path + ",hb=" + baseCommitId);
    }

    public static PageParameters newSearchParameter(String repositoryName, String commitId, String search, Constants.SearchType type) {
        if (StringUtils.isEmpty(commitId)) {
            return new PageParameters("r=" + repositoryName + ",s=" + search + ",st=" + type.name());
        }
        return new PageParameters("r=" + repositoryName + ",h=" + commitId + ",s=" + search + ",st=" + type.name());
    }

    public static PageParameters newSearchParameter(String repositoryName, String commitId, String search, Constants.SearchType type, int pageNumber) {
        if (StringUtils.isEmpty(commitId)) {
            return new PageParameters("r=" + repositoryName + ",s=" + search + ",st=" + type.name() + ",pg=" + pageNumber);
        }
        return new PageParameters("r=" + repositoryName + ",h=" + commitId + ",s=" + search + ",st=" + type.name() + ",pg=" + pageNumber);
    }

    public static String getProjectName(PageParameters params) {
        return params.getString("p", "");
    }

    public static String getRepositoryName(PageParameters params) {
        return params.getString("r", "");
    }

    public static String getObject(PageParameters params) {
        return params.getString("h", null);
    }

    public static String getPath(PageParameters params) {
        return params.getString("f", null);
    }

    public static String getBaseObjectId(PageParameters params) {
        return params.getString("hb", null);
    }

    public static String getSearchString(PageParameters params) {
        return params.getString("s", null);
    }

    public static String getSearchType(PageParameters params) {
        return params.getString("st", null);
    }

    public static int getPage(PageParameters params) {
        return params.getInt("pg", 1);
    }

    public static String getRegEx(PageParameters params) {
        return params.getString("x", "");
    }

    public static String getSet(PageParameters params) {
        return params.getString("set", "");
    }

    public static String getTeam(PageParameters params) {
        return params.getString("team", "");
    }

    public static int getDaysBack(PageParameters params) {
        return params.getInt("db", 14);
    }

    public static String getUsername(PageParameters params) {
        return params.getString("user", "");
    }

    public static String getTeamname(PageParameters params) {
        return params.getString("team", "");
    }

    public static String getToken(PageParameters params) {
        return params.getString("t", "");
    }

    public static String getUrlParameter(PageParameters params) {
        return params.getString("u", "");
    }

    public static String getNameParameter(PageParameters params) {
        return params.getString("n", "");
    }

    public static Label createDateLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        String format = GitBlit.getString("web.datestampShortFormat", "MM/dd/yy");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlit.getTimezone();
        }
        df.setTimeZone(timeZone);
        String dateString = date.getTime() == 0L ? "--" : df.format(date);
        String title = null;
        if (date.getTime() <= System.currentTimeMillis()) {
            title = timeUtils.timeAgo(date);
        }
        if (System.currentTimeMillis() - date.getTime() < 864000000L) {
            String tmp = dateString;
            dateString = title;
            title = tmp;
        }
        Label label = new Label(wicketId, dateString);
        WicketUtils.setCssClass((Component)label, timeUtils.timeAgoCss(date));
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static Label createTimeLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        String format = GitBlit.getString("web.timeFormat", "HH:mm");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlit.getTimezone();
        }
        df.setTimeZone(timeZone);
        String timeString = date.getTime() == 0L ? "--" : df.format(date);
        String title = timeUtils.timeAgo(date);
        Label label = new Label(wicketId, timeString);
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static Label createDatestampLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        String format = GitBlit.getString("web.datestampLongFormat", "EEEE, MMMM d, yyyy");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlit.getTimezone();
        }
        df.setTimeZone(timeZone);
        String dateString = date.getTime() == 0L ? "--" : df.format(date);
        String title = null;
        if (TimeUtils.isToday(date)) {
            title = timeUtils.today();
        } else if (TimeUtils.isYesterday(date)) {
            title = timeUtils.yesterday();
        } else if (date.getTime() <= System.currentTimeMillis()) {
            title = timeUtils.timeAgo(date);
        }
        if (System.currentTimeMillis() - date.getTime() < 864000000L) {
            String tmp = dateString;
            dateString = title;
            title = tmp;
        }
        Label label = new Label(wicketId, dateString);
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static Label createTimestampLabel(String wicketId, Date date, TimeZone timeZone, TimeUtils timeUtils) {
        String format = GitBlit.getString("web.datetimestampLongFormat", "EEEE, MMMM d, yyyy HH:mm Z");
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timeZone == null) {
            timeZone = GitBlit.getTimezone();
        }
        df.setTimeZone(timeZone);
        String dateString = date.getTime() == 0L ? "--" : df.format(date);
        String title = null;
        if (date.getTime() <= System.currentTimeMillis()) {
            title = timeUtils.timeAgo(date);
        }
        Label label = new Label(wicketId, dateString);
        if (!StringUtils.isEmpty(title)) {
            WicketUtils.setHtmlTooltip((Component)label, title);
        }
        return label;
    }

    public static IChartData getChartData(Collection<Metric> metrics) {
        final double[] commits = new double[metrics.size()];
        final double[] tags = new double[metrics.size()];
        int i = 0;
        double max = 0.0;
        for (Metric m : metrics) {
            commits[i] = m.count;
            tags[i] = m.tag > 0.0 ? m.count : -1.0;
            max = Math.max(max, m.count);
            ++i;
        }
        AbstractChartData data = new AbstractChartData(max){
            private static final long serialVersionUID = 1L;

            public double[][] getData() {
                return new double[][]{commits, tags};
            }
        };
        return data;
    }

    public static double maxValue(Collection<Metric> metrics) {
        double max = Double.MIN_VALUE;
        for (Metric m : metrics) {
            if (!(m.count > max)) continue;
            max = m.count;
        }
        return max;
    }

    public static IChartData getScatterData(Collection<Metric> metrics) {
        final double[] y = new double[metrics.size()];
        final double[] x = new double[metrics.size()];
        int i = 0;
        double max = 0.0;
        for (Metric m : metrics) {
            y[i] = m.count;
            x[i] = m.duration > 0 ? (double)m.duration : -1.0;
            max = Math.max(max, m.count);
            ++i;
        }
        AbstractChartData data = new AbstractChartData(max){
            private static final long serialVersionUID = 1L;

            public double[][] getData() {
                return new double[][]{x, y};
            }
        };
        return data;
    }
}

