/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.Activity;
import com.gitblit.models.Metric;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.ActivityUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.charting.GoogleChart;
import com.gitblit.wicket.charting.GoogleCharts;
import com.gitblit.wicket.charting.GoogleLineChart;
import com.gitblit.wicket.charting.GooglePieChart;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.panels.ActivityPanel;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;

public class ActivityPage
extends RootPage {
    public ActivityPage(PageParameters params) {
        super(params);
        this.setupPage("", "");
        int daysBack = WicketUtils.getDaysBack(params);
        if (daysBack < 1) {
            daysBack = 14;
        }
        String objectId = WicketUtils.getObject(params);
        List<RepositoryModel> models = this.getRepositories(params);
        List<Activity> recentActivity = ActivityUtils.getRecentActivity(models, daysBack, objectId, this.getTimeZone());
        if (recentActivity.size() == 0) {
            this.add(new Component[]{new Label("subheader", MessageFormat.format(this.getString("gb.recentActivityNone"), daysBack))});
            this.add(new Component[]{new Label("activityPanel")});
        } else {
            int totalCommits = 0;
            HashSet<String> uniqueAuthors = new HashSet<String>();
            for (Activity activity : recentActivity) {
                totalCommits += activity.getCommitCount();
                uniqueAuthors.addAll(activity.getAuthorMetrics().keySet());
            }
            int totalAuthors = uniqueAuthors.size();
            this.add(new Component[]{new Label("subheader", MessageFormat.format(this.getString("gb.recentActivityStats"), daysBack, totalCommits, totalAuthors))});
            GoogleCharts charts = this.createCharts(recentActivity);
            this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)charts)});
            this.add(new Component[]{new ActivityPanel("activityPanel", recentActivity)});
        }
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    @Override
    protected void addDropDownMenus(List<PageRegistration> pages) {
        PageRegistration.DropDownMenuRegistration filters = new PageRegistration.DropDownMenuRegistration("gb.filters", ActivityPage.class);
        PageParameters currentParameters = this.getPageParameters();
        int daysBack = GitBlit.getInteger("web.activityDuration", 14);
        if (currentParameters != null && !currentParameters.containsKey((Object)"db")) {
            currentParameters.put("db", (Object)daysBack);
        }
        filters.menuItems.addAll(this.getRepositoryFilterItems(currentParameters));
        filters.menuItems.addAll(this.getTimeFilterItems(currentParameters));
        if (filters.menuItems.size() > 0) {
            filters.menuItems.add(new PageRegistration.DropDownMenuItem(this.getString("gb.reset"), null, null));
        }
        pages.add(filters);
    }

    private GoogleCharts createCharts(List<Activity> recentActivity) {
        HashMap<String, Metric> repositoryMetrics = new HashMap<String, Metric>();
        HashMap<String, Metric> authorMetrics = new HashMap<String, Metric>();
        for (Activity activity : recentActivity) {
            for (Map.Entry<String, Metric> entry : activity.getAuthorMetrics().entrySet()) {
                String author = entry.getKey();
                if (!authorMetrics.containsKey(author)) {
                    authorMetrics.put(author, new Metric(author));
                }
                ((Metric)authorMetrics.get((Object)author)).count += entry.getValue().count;
            }
            for (Map.Entry<String, Metric> entry : activity.getRepositoryMetrics().entrySet()) {
                String repository = StringUtils.stripDotGit(entry.getKey());
                if (!repositoryMetrics.containsKey(repository)) {
                    repositoryMetrics.put(repository, new Metric(repository));
                }
                ((Metric)repositoryMetrics.get((Object)repository)).count += entry.getValue().count;
            }
        }
        int w = 310;
        int h = 150;
        GoogleCharts charts = new GoogleCharts();
        Collections.sort(recentActivity);
        Collections.reverse(recentActivity);
        GoogleChart chart = new GoogleLineChart("chartDaily", this.getString("gb.dailyActivity"), "day", this.getString("gb.commits"));
        SimpleDateFormat df = new SimpleDateFormat("MMM dd");
        df.setTimeZone(this.getTimeZone());
        for (Comparable<Activity> metric : recentActivity) {
            chart.addValue(df.format(metric.startDate), metric.getCommitCount());
        }
        chart.setWidth(w);
        chart.setHeight(h);
        charts.addChart(chart);
        chart = new GooglePieChart("chartRepositories", this.getString("gb.activeRepositories"), this.getString("gb.repository"), this.getString("gb.commits"));
        for (Comparable<Activity> metric : repositoryMetrics.values()) {
            chart.addValue(((Metric)metric).name, ((Metric)metric).count);
        }
        chart.setWidth(w);
        chart.setHeight(h);
        charts.addChart(chart);
        chart = new GooglePieChart("chartAuthors", this.getString("gb.activeAuthors"), this.getString("gb.author"), this.getString("gb.commits"));
        for (Comparable<Activity> metric : authorMetrics.values()) {
            chart.addValue(((Metric)metric).name, ((Metric)metric).count);
        }
        chart.setWidth(w);
        chart.setHeight(h);
        charts.addChart(chart);
        return charts;
    }
}

