/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ChangePasswordPage;
import com.gitblit.wicket.pages.LogoutPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RedirectToUrlException;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePage
extends WebPage {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private transient TimeUtils timeUtils;

    public BasePage() {
        this.customizeHeader();
        this.login();
    }

    public BasePage(PageParameters params) {
        super(params);
        this.customizeHeader();
        this.login();
    }

    private void customizeHeader() {
        if (GitBlit.getBoolean("web.useResponsiveLayout", true)) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((String)"bootstrap/css/bootstrap-responsive.css")});
        }
    }

    protected String getLanguageCode() {
        return GitBlitWebSession.get().getLocale().getLanguage();
    }

    protected String getCountryCode() {
        return GitBlitWebSession.get().getLocale().getCountry().toLowerCase();
    }

    protected TimeUtils getTimeUtils() {
        if (this.timeUtils == null) {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp", GitBlitWebSession.get().getLocale());
            }
            catch (Throwable t) {
                bundle = ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp");
            }
            this.timeUtils = new TimeUtils(bundle);
        }
        return this.timeUtils;
    }

    protected void onBeforeRender() {
        if (GitBlit.isDebugMode()) {
            Application.get().getMarkupSettings().setStripWicketTags(true);
        }
        super.onBeforeRender();
    }

    protected void onAfterRender() {
        if (GitBlit.isDebugMode()) {
            Application.get().getMarkupSettings().setStripWicketTags(false);
        }
        super.onAfterRender();
    }

    private void login() {
        GitBlitWebSession session = GitBlitWebSession.get();
        if (session.isLoggedIn() && !session.isSessionInvalidated()) {
            return;
        }
        HttpServletRequest httpRequest = ((WebRequest)this.getRequestCycle().getRequest()).getHttpServletRequest();
        UserModel user = GitBlit.self().authenticate(httpRequest);
        if (user != null) {
            session.replaceSession();
            session.setUser(user);
            WebResponse response = (WebResponse)this.getRequestCycle().getResponse();
            GitBlit.self().setCookie(response, user);
            session.continueRequest();
        }
    }

    protected void setupPage(String repositoryName, String pageName) {
        if (repositoryName != null && repositoryName.trim().length() > 0) {
            this.add(new Component[]{new Label("title", this.getServerName() + " - " + repositoryName)});
        } else {
            this.add(new Component[]{new Label("title", this.getServerName())});
        }
        ExternalLink rootLink = new ExternalLink("rootLink", ((Object)this.urlFor(RepositoriesPage.class, null)).toString());
        WicketUtils.setHtmlTooltip((Component)rootLink, GitBlit.getString("web.siteName", "Gitblit"));
        this.add(new Component[]{rootLink});
        this.add(new Component[]{new FeedbackPanel("feedback")});
        if (GitBlit.getBoolean("web.authenticateViewPages", true) || GitBlit.getBoolean("web.authenticateAdminPages", true)) {
            UserFragment userFragment = new UserFragment("userPanel", "userFragment", (MarkupContainer)this);
            this.add(new Component[]{userFragment});
        } else {
            this.add(new Component[]{new Label("userPanel", "")});
        }
        this.add(new Component[]{new Label("gbVersion", "v1.2.0")});
        if (GitBlit.getBoolean("web.aggressiveHeapManagement", false)) {
            System.gc();
        }
    }

    protected Map<Constants.AccessRestrictionType, String> getAccessRestrictions() {
        LinkedHashMap<Constants.AccessRestrictionType, String> map = new LinkedHashMap<Constants.AccessRestrictionType, String>();
        block6: for (Constants.AccessRestrictionType type : Constants.AccessRestrictionType.values()) {
            switch (type) {
                case NONE: {
                    map.put(type, this.getString("gb.notRestricted"));
                    continue block6;
                }
                case PUSH: {
                    map.put(type, this.getString("gb.pushRestricted"));
                    continue block6;
                }
                case CLONE: {
                    map.put(type, this.getString("gb.cloneRestricted"));
                    continue block6;
                }
                case VIEW: {
                    map.put(type, this.getString("gb.viewRestricted"));
                }
            }
        }
        return map;
    }

    protected Map<Constants.AccessPermission, String> getAccessPermissions() {
        LinkedHashMap<Constants.AccessPermission, String> map = new LinkedHashMap<Constants.AccessPermission, String>();
        block10: for (Constants.AccessPermission type : Constants.AccessPermission.values()) {
            switch (type) {
                case NONE: {
                    map.put(type, MessageFormat.format(this.getString("gb.noPermission"), type.code));
                    continue block10;
                }
                case EXCLUDE: {
                    map.put(type, MessageFormat.format(this.getString("gb.excludePermission"), type.code));
                    continue block10;
                }
                case VIEW: {
                    map.put(type, MessageFormat.format(this.getString("gb.viewPermission"), type.code));
                    continue block10;
                }
                case CLONE: {
                    map.put(type, MessageFormat.format(this.getString("gb.clonePermission"), type.code));
                    continue block10;
                }
                case PUSH: {
                    map.put(type, MessageFormat.format(this.getString("gb.pushPermission"), type.code));
                    continue block10;
                }
                case CREATE: {
                    map.put(type, MessageFormat.format(this.getString("gb.createPermission"), type.code));
                    continue block10;
                }
                case DELETE: {
                    map.put(type, MessageFormat.format(this.getString("gb.deletePermission"), type.code));
                    continue block10;
                }
                case REWIND: {
                    map.put(type, MessageFormat.format(this.getString("gb.rewindPermission"), type.code));
                }
            }
        }
        return map;
    }

    protected Map<Constants.FederationStrategy, String> getFederationTypes() {
        LinkedHashMap<Constants.FederationStrategy, String> map = new LinkedHashMap<Constants.FederationStrategy, String>();
        block5: for (Constants.FederationStrategy type : Constants.FederationStrategy.values()) {
            switch (type) {
                case EXCLUDE: {
                    map.put(type, this.getString("gb.excludeFromFederation"));
                    continue block5;
                }
                case FEDERATE_THIS: {
                    map.put(type, this.getString("gb.federateThis"));
                    continue block5;
                }
                case FEDERATE_ORIGIN: {
                    map.put(type, this.getString("gb.federateOrigin"));
                }
            }
        }
        return map;
    }

    protected Map<Constants.AuthorizationControl, String> getAuthorizationControls() {
        LinkedHashMap<Constants.AuthorizationControl, String> map = new LinkedHashMap<Constants.AuthorizationControl, String>();
        block4: for (Constants.AuthorizationControl type : Constants.AuthorizationControl.values()) {
            switch (type) {
                case AUTHENTICATED: {
                    map.put(type, this.getString("gb.allowAuthenticatedDescription"));
                    continue block4;
                }
                case NAMED: {
                    map.put(type, this.getString("gb.allowNamedDescription"));
                }
            }
        }
        return map;
    }

    protected TimeZone getTimeZone() {
        return GitBlit.getBoolean("web.useClientTimezone", false) ? GitBlitWebSession.get().getTimezone() : GitBlit.getTimezone();
    }

    protected String getServerName() {
        ServletWebRequest servletWebRequest = (ServletWebRequest)this.getRequest();
        HttpServletRequest req = servletWebRequest.getHttpServletRequest();
        return req.getServerName();
    }

    public static String getRepositoryUrl(RepositoryModel repository) {
        StringBuilder sb = new StringBuilder();
        sb.append(WicketUtils.getGitblitURL(RequestCycle.get().getRequest()));
        sb.append("/git/");
        sb.append(repository.name);
        if (repository.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE) && GitBlitWebSession.get().isLoggedIn()) {
            String username = GitBlitWebSession.get().getUsername();
            sb.insert(sb.indexOf("://") + 3, username + "@");
        }
        return sb.toString();
    }

    protected List<ProjectModel> getProjectModels() {
        UserModel user = GitBlitWebSession.get().getUser();
        List<ProjectModel> projects = GitBlit.self().getProjectModels(user, true);
        return projects;
    }

    protected List<ProjectModel> getProjects(PageParameters params) {
        if (params == null) {
            return this.getProjectModels();
        }
        boolean hasParameter = false;
        String regex2 = WicketUtils.getRegEx(params);
        String team = WicketUtils.getTeam(params);
        int daysBack = params.getInt("db", 0);
        List<ProjectModel> availableModels = this.getProjectModels();
        HashSet<ProjectModel> models = new HashSet<ProjectModel>();
        if (!StringUtils.isEmpty(regex2)) {
            hasParameter = true;
            Pattern pattern = Pattern.compile(regex2);
            for (ProjectModel model : availableModels) {
                if (!pattern.matcher(model.name).find()) continue;
                models.add(model);
            }
        }
        if (!StringUtils.isEmpty(team)) {
            hasParameter = true;
            List<String> teams = StringUtils.getStringsFromValue(team, ",");
            ArrayList<TeamModel> teamModels = new ArrayList<TeamModel>();
            for (String name : teams) {
                TeamModel teamModel = GitBlit.self().getTeamModel(name);
                if (teamModel == null) continue;
                teamModels.add(teamModel);
            }
            for (ProjectModel projectModel : availableModels) {
                for (String repositoryName : projectModel.repositories) {
                    for (TeamModel teamModel : teamModels) {
                        if (!teamModel.hasRepositoryPermission(repositoryName)) continue;
                        models.add(projectModel);
                    }
                }
            }
        }
        if (!hasParameter) {
            models.addAll(availableModels);
        }
        if (daysBack > 0) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, -1 * daysBack);
            Date threshold = cal.getTime();
            HashSet<ProjectModel> timeFiltered = new HashSet<ProjectModel>();
            for (ProjectModel model : models) {
                if (!model.lastChange.after(threshold)) continue;
                timeFiltered.add(model);
            }
            models = timeFiltered;
        }
        ArrayList<ProjectModel> list = new ArrayList<ProjectModel>(models);
        Collections.sort(list);
        return list;
    }

    public void warn(String message, Throwable t) {
        this.logger.warn(message, t);
    }

    public void error(String message, boolean redirect) {
        this.logger.error(message + " for " + GitBlitWebSession.get().getUsername());
        if (redirect) {
            GitBlitWebSession.get().cacheErrorMessage(message);
            String relativeUrl = ((Object)this.urlFor(RepositoriesPage.class, null)).toString();
            String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
            throw new RedirectToUrlException(absoluteUrl);
        }
        super.error((Serializable)((Object)message));
    }

    public void error(String message, Throwable t, boolean redirect) {
        this.logger.error(message, t);
        if (redirect) {
            GitBlitWebSession.get().cacheErrorMessage(message);
            throw new RestartResponseException(this.getApplication().getHomePage());
        }
        super.error((Serializable)((Object)message));
    }

    public void authenticationError(String message) {
        this.logger.error(this.getRequest().getURL() + " for " + GitBlitWebSession.get().getUsername());
        if (!GitBlitWebSession.get().isLoggedIn()) {
            GitBlitWebSession.get().cacheRequest(((Object)((Object)this)).getClass());
        }
        this.error(message, true);
    }

    static class UserFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public UserFragment(String id, String markupId, MarkupContainer markupProvider) {
            super(id, markupId, markupProvider);
            GitBlitWebSession session = GitBlitWebSession.get();
            if (session.isLoggedIn()) {
                UserModel user = session.getUser();
                boolean editCredentials = GitBlit.self().supportsCredentialChanges();
                boolean standardLogin = session.authenticationType.isStandard();
                this.add(new Component[]{new Label("username", user.getDisplayName() + ":")});
                this.add(new Component[]{new LinkPanel("loginLink", null, markupProvider.getString("gb.logout"), LogoutPage.class).setVisible(standardLogin)});
                this.add(new Component[]{new Label("separator", "|").setVisible(standardLogin && editCredentials)});
                this.add(new Component[]{new BookmarkablePageLink("changePasswordLink", ChangePasswordPage.class).setVisible(editCredentials)});
            } else {
                this.add(new Component[]{new Label("username").setVisible(false)});
                this.add(new Component[]{new Label("loginLink").setVisible(false)});
                this.add(new Component[]{new Label("separator").setVisible(false)});
                this.add(new Component[]{new Label("changePasswordLink").setVisible(false)});
            }
        }
    }
}

