/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.AnnotatedLine;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.revwalk.RevCommit;

public class BlamePage
extends RepositoryPage {
    public BlamePage(PageParameters params) {
        super(params);
        String blobPath = WicketUtils.getPath(params);
        RevCommit commit = this.getCommit();
        this.add(new Component[]{new BookmarkablePageLink("blobLink", BlobPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        this.add(new Component[]{new BookmarkablePageLink("commitLink", CommitPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("commitDiffLink", CommitDiffPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("headLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, "HEAD", blobPath))});
        this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
        this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
        String format = GitBlit.getString("web.datetimestampLongFormat", "EEEE, MMMM d, yyyy HH:mm Z");
        final SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(this.getTimeZone());
        List<AnnotatedLine> lines = DiffUtils.blame(this.getRepository(), blobPath, this.objectId);
        ListDataProvider blameDp = new ListDataProvider(lines);
        DataView<AnnotatedLine> blameView = new DataView<AnnotatedLine>("annotation", (IDataProvider)blameDp){
            private static final long serialVersionUID = 1L;
            private int count;
            private String lastCommitId;
            private boolean showInitials;
            {
                super(x0, x1);
                this.lastCommitId = "";
                this.showInitials = true;
            }

            public void populateItem(Item<AnnotatedLine> item) {
                AnnotatedLine entry = (AnnotatedLine)item.getModelObject();
                item.add(new Component[]{new Label("line", "" + entry.lineNumber)});
                item.add(new Component[]{new Label("data", StringUtils.escapeForHtml(entry.data, true)).setEscapeModelStrings(false)});
                if (!this.lastCommitId.equals(entry.commitId)) {
                    this.lastCommitId = entry.commitId;
                    ++this.count;
                    LinkPanel commitLink = new LinkPanel("commit", null, BlamePage.this.getShortObjectId(entry.commitId), CommitPage.class, BlamePage.this.newCommitParameter(entry.commitId));
                    WicketUtils.setHtmlTooltip((Component)commitLink, MessageFormat.format("{0}, {1}", entry.author, df.format(entry.when)));
                    item.add(new Component[]{commitLink});
                    this.showInitials = true;
                } else if (this.showInitials) {
                    this.showInitials = false;
                    item.add(new Component[]{new Label("commit", BlamePage.this.getInitials(entry.author))});
                } else {
                    item.add(new Component[]{new Label("commit").setVisible(false)});
                }
                if (this.count % 2 == 0) {
                    WicketUtils.setCssClass(item, "even");
                } else {
                    WicketUtils.setCssClass(item, "odd");
                }
            }
        };
        this.add(new Component[]{blameView});
    }

    private String getInitials(String author) {
        String[] chunks;
        StringBuilder sb = new StringBuilder();
        for (String chunk : chunks = author.split(" ")) {
            sb.append(chunk.charAt(0));
        }
        return sb.toString().toUpperCase();
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.blame");
    }
}

