/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.ExternalImage;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.MarkdownPage;
import com.gitblit.wicket.pages.RawPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class BlobPage
extends RepositoryPage {
    public BlobPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        String blobPath = WicketUtils.getPath(params);
        String[] encodings = GitBlit.getEncodings();
        if (StringUtils.isEmpty(blobPath)) {
            this.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath)).setEnabled(false)});
            this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class).setEnabled(false)});
            this.add(new Component[]{new BookmarkablePageLink("rawLink", RawPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
            this.add(new Component[]{new BookmarkablePageLink("headLink", BlobPage.class).setEnabled(false)});
            this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.objectId)});
            this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
            Label c = new Label("blobText", JGitUtils.getStringContent(r, this.objectId, encodings));
            WicketUtils.setCssClass((Component)c, "plainprint");
            this.add(new Component[]{c});
        } else {
            String extension = null;
            if (blobPath.lastIndexOf(46) > -1) {
                extension = blobPath.substring(blobPath.lastIndexOf(46) + 1).toLowerCase();
            }
            for (String ext : GitBlit.getStrings("web.markdownExtensions")) {
                if (!ext.equals(extension)) continue;
                this.setResponsePage(MarkdownPage.class, params);
                return;
            }
            RevCommit commit = JGitUtils.getCommit(r, this.objectId);
            this.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
            this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
            this.add(new Component[]{new BookmarkablePageLink("rawLink", RawPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
            this.add(new Component[]{new BookmarkablePageLink("headLink", BlobPage.class, WicketUtils.newPathParameter(this.repositoryName, "HEAD", blobPath))});
            this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
            this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String ext : GitBlit.getStrings("web.prettyPrintExtensions")) {
                map.put(ext.toLowerCase(), 1);
            }
            for (String ext : GitBlit.getStrings("web.imageExtensions")) {
                map.put(ext.toLowerCase(), 2);
            }
            for (String ext : GitBlit.getStrings("web.binaryExtensions")) {
                map.put(ext.toLowerCase(), 3);
            }
            if (extension != null) {
                int type = 0;
                if (map.containsKey(extension)) {
                    type = (Integer)map.get(extension);
                }
                switch (type) {
                    case 2: {
                        this.add(new Component[]{new Label("blobText").setVisible(false)});
                        this.add(new Component[]{new ExternalImage("blobImage", ((Object)this.urlFor(RawPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))).toString())});
                        break;
                    }
                    case 3: {
                        this.add(new Component[]{new Label("blobText", "Binary File")});
                        this.add(new Component[]{new Image("blobImage").setVisible(false)});
                        break;
                    }
                    default: {
                        String source = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                        String table = this.generateSourceView(source, type == 1);
                        this.add(new Component[]{new Label("blobText", table).setEscapeModelStrings(false)});
                        this.add(new Component[]{new Image("blobImage").setVisible(false)});
                        break;
                    }
                }
            } else {
                String source = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                String table = this.generateSourceView(source, false);
                this.add(new Component[]{new Label("blobText", table).setEscapeModelStrings(false)});
                this.add(new Component[]{new Image("blobImage").setVisible(false)});
            }
        }
    }

    protected String generateSourceView(String source, boolean prettyPrint) {
        String[] lines = source.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("<!-- start blob table -->");
        sb.append("<table width=\"100%\"><tbody><tr>");
        sb.append("<!-- start nums column -->");
        sb.append("<td id=\"nums\">");
        sb.append("<pre>");
        String numPattern = "<span id=\"L{0}\" class=\"num\">{0}</span>\n";
        for (int i = 0; i < lines.length; ++i) {
            sb.append(MessageFormat.format(numPattern, "" + (i + 1)));
        }
        sb.append("</pre>");
        sb.append("<!-- end nums column -->");
        sb.append("</td>");
        sb.append("<!-- start lines column -->");
        sb.append("<td id=\"lines\">");
        sb.append("<div class=\"sourceview\">");
        if (prettyPrint) {
            sb.append("<pre class=\"prettyprint\">");
        } else {
            sb.append("<pre class=\"plainprint\">");
        }
        lines = StringUtils.escapeForHtml(source, true).split("\n");
        sb.append("<table width=\"100%\"><tbody>");
        String linePattern = "<tr class=\"{0}\"><td><a href=\"#L{2}\">{1}</a>\r</tr>";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].replace('\r', ' ');
            String cssClass = i % 2 == 0 ? "even" : "odd";
            sb.append(MessageFormat.format(linePattern, cssClass, line, "" + (i + 1)));
        }
        sb.append("</tbody></table></pre>");
        sb.append("</pre>");
        sb.append("</div>");
        sb.append("</td>");
        sb.append("<!-- end lines column -->");
        sb.append("</tr></tbody></table>");
        sb.append("<!-- end blob table -->");
        return sb.toString();
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.view");
    }
}

