/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.PathModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.CommitLegendPanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitDiffPage
extends RepositoryPage {
    public CommitDiffPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        DiffUtils.DiffOutputType diffType = DiffUtils.DiffOutputType.forName(GitBlit.getString("web.diffStyle", DiffUtils.DiffOutputType.GITBLIT.name()));
        RevCommit commit = null;
        RevCommit otherCommit = null;
        if (this.objectId.contains("..")) {
            String[] parts = this.objectId.split("\\.\\.");
            commit = this.getCommit(r, parts[0]);
            otherCommit = this.getCommit(r, parts[1]);
        } else {
            commit = this.getCommit();
        }
        String diff = otherCommit == null ? DiffUtils.getCommitDiff(r, commit, diffType) : DiffUtils.getDiff(r, commit, otherCommit, diffType);
        ArrayList<String> parents = new ArrayList<String>();
        if (commit.getParentCount() > 0) {
            for (RevCommit parent : commit.getParents()) {
                parents.add(parent.name());
            }
        }
        if (parents.size() == 0) {
            this.add(new Component[]{new Label("parentLink", this.getString("gb.none"))});
        } else {
            this.add(new Component[]{new LinkPanel("parentLink", null, ((String)parents.get(0)).substring(0, 8), CommitDiffPage.class, this.newCommitParameter((String)parents.get(0)))});
        }
        this.add(new Component[]{new BookmarkablePageLink("patchLink", PatchPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("commitLink", CommitPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
        List<PathModel.PathChangeModel> paths = otherCommit == null ? JGitUtils.getFilesInCommit(r, commit) : JGitUtils.getFilesInCommit(r, otherCommit);
        this.add(new Component[]{new CommitLegendPanel("commitLegend", paths)});
        ListDataProvider pathsDp = new ListDataProvider(paths);
        DataView<PathModel.PathChangeModel> pathsView = new DataView<PathModel.PathChangeModel>("changedPath", (IDataProvider)pathsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<PathModel.PathChangeModel> item) {
                PathModel.PathChangeModel entry = (PathModel.PathChangeModel)item.getModelObject();
                Label changeType = new Label("changeType", "");
                WicketUtils.setChangeTypeCssClass((Component)changeType, entry.changeType);
                CommitDiffPage.this.setChangeTypeTooltip((Component)changeType, entry.changeType);
                item.add(new Component[]{changeType});
                boolean hasSubmodule = false;
                String submodulePath = null;
                if (entry.isTree()) {
                    item.add(new Component[]{new LinkPanel("pathName", null, entry.path, TreePage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path))});
                } else if (entry.isSubmodule()) {
                    String submoduleId = entry.objectId;
                    SubmoduleModel submodule = CommitDiffPage.this.getSubmodule(entry.path);
                    submodulePath = submodule.gitblitPath;
                    hasSubmodule = submodule.hasSubmodule;
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.path + " @ " + CommitDiffPage.this.getShortObjectId(submoduleId), TreePage.class, WicketUtils.newPathParameter(submodulePath, submoduleId, "")).setEnabled(hasSubmodule)});
                } else {
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.path, BlobPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path))});
                }
                if (entry.isSubmodule()) {
                    item.add(new Component[]{new BookmarkablePageLink("patch", PatchPage.class, WicketUtils.newPathParameter(submodulePath, entry.objectId, entry.path)).setEnabled(false)});
                    item.add(new Component[]{new BookmarkablePageLink("view", CommitPage.class, WicketUtils.newObjectParameter(submodulePath, entry.objectId)).setEnabled(hasSubmodule)});
                    item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(submodulePath, entry.objectId, entry.path)).setEnabled(false)});
                    item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(submodulePath, entry.objectId, entry.path)).setEnabled(hasSubmodule)});
                } else {
                    item.add(new Component[]{new BookmarkablePageLink("patch", PatchPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path))});
                    item.add(new Component[]{new BookmarkablePageLink("view", BlobPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path))});
                    item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path))});
                    item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{pathsView});
        this.add(new Component[]{new Label("diffText", diff).setEscapeModelStrings(false)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.commitdiff");
    }

    private RevCommit getCommit(Repository r, String rev) {
        RevCommit otherCommit = JGitUtils.getCommit(r, rev);
        if (otherCommit == null) {
            this.error(MessageFormat.format(this.getString("gb.failedToFindCommit"), rev, this.repositoryName, this.getPageName()), true);
        }
        return otherCommit;
    }
}

