/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.GitBlitException;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.StringChoiceRenderer;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.panels.BulletListPanel;
import com.gitblit.wicket.panels.RegistrantPermissionsPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;

public class EditRepositoryPage
extends RootSubPage {
    private final boolean isCreate;
    private boolean isAdmin;
    RepositoryModel repositoryModel;
    private IModel<String> mailingLists;

    public EditRepositoryPage() {
        this.isCreate = true;
        RepositoryModel model = new RepositoryModel();
        String restriction = GitBlit.getString("git.defaultAccessRestriction", null);
        model.accessRestriction = Constants.AccessRestrictionType.fromName(restriction);
        String authorization = GitBlit.getString("git.defaultAuthorizationControl", null);
        model.authorizationControl = Constants.AuthorizationControl.fromName(authorization);
        GitBlitWebSession session = GitBlitWebSession.get();
        UserModel user = session.getUser();
        if (user != null && user.canCreate() && !user.canAdmin()) {
            model.name = user.getPersonalPath() + "/";
            model.projectPath = user.getPersonalPath();
            model.owner = user.username;
            model.accessRestriction = Constants.AccessRestrictionType.VIEW;
            model.authorizationControl = Constants.AuthorizationControl.NAMED;
        }
        this.setupPage(model);
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    public EditRepositoryPage(PageParameters params) {
        super(params);
        this.isCreate = false;
        String name = WicketUtils.getRepositoryName(params);
        RepositoryModel model = GitBlit.self().getRepositoryModel(name);
        this.setupPage(model);
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    @Override
    protected boolean requiresPageMap() {
        return true;
    }

    protected void setupPage(RepositoryModel model) {
        boolean allowEditName;
        this.repositoryModel = model;
        this.checkPermissions(this.repositoryModel);
        ArrayList<String> indexedBranches = new ArrayList<String>();
        ArrayList<String> federationSets = new ArrayList<String>();
        ArrayList<RegistrantAccessPermission> repositoryUsers = new ArrayList<RegistrantAccessPermission>();
        ArrayList<RegistrantAccessPermission> repositoryTeams = new ArrayList<RegistrantAccessPermission>();
        ArrayList<String> preReceiveScripts = new ArrayList<String>();
        ArrayList<String> postReceiveScripts = new ArrayList<String>();
        GitBlitWebSession session = GitBlitWebSession.get();
        final UserModel user = session.getUser() == null ? UserModel.ANONYMOUS : session.getUser();
        boolean bl = allowEditName = this.isCreate || this.isAdmin || this.repositoryModel.isUsersPersonalRepository(user.username);
        if (this.isCreate) {
            if (user.canAdmin()) {
                super.setupPage(this.getString("gb.newRepository"), "");
            } else {
                super.setupPage(this.getString("gb.newRepository"), user.getDisplayName());
            }
        } else {
            super.setupPage(this.getString("gb.edit"), this.repositoryModel.name);
            repositoryUsers.addAll(GitBlit.self().getUserAccessPermissions(this.repositoryModel));
            repositoryTeams.addAll(GitBlit.self().getTeamAccessPermissions(this.repositoryModel));
            Collections.sort(repositoryUsers);
            Collections.sort(repositoryTeams);
            federationSets.addAll(this.repositoryModel.federationSets);
            if (!ArrayUtils.isEmpty(this.repositoryModel.indexedBranches)) {
                indexedBranches.addAll(this.repositoryModel.indexedBranches);
            }
        }
        String oldName = this.repositoryModel.name;
        final RegistrantPermissionsPanel usersPalette = new RegistrantPermissionsPanel("users", Constants.RegistrantType.USER, GitBlit.self().getAllUsernames(), repositoryUsers, this.getAccessPermissions());
        final RegistrantPermissionsPanel teamsPalette = new RegistrantPermissionsPanel("teams", Constants.RegistrantType.TEAM, GitBlit.self().getAllTeamnames(), repositoryTeams, this.getAccessPermissions());
        ArrayList<String> allLocalBranches = new ArrayList<String>();
        allLocalBranches.add("default");
        allLocalBranches.addAll(this.repositoryModel.getLocalBranches());
        boolean luceneEnabled = GitBlit.getBoolean("web.allowLuceneIndexing", true);
        final Palette indexedBranchesPalette = new Palette("indexedBranches", (IModel)new ListModel(indexedBranches), (IModel)new CollectionModel(allLocalBranches), (IChoiceRenderer)new StringChoiceRenderer(), 8, false);
        indexedBranchesPalette.setEnabled(luceneEnabled);
        List<String> sets = GitBlit.getStrings("federation.sets");
        final Palette federationSetsPalette = new Palette("federationSets", (IModel)new ListModel(federationSets), (IModel)new CollectionModel(sets), (IChoiceRenderer)new StringChoiceRenderer(), 8, false);
        if (!ArrayUtils.isEmpty(this.repositoryModel.preReceiveScripts)) {
            preReceiveScripts.addAll(this.repositoryModel.preReceiveScripts);
        }
        final Palette preReceivePalette = new Palette("preReceiveScripts", (IModel)new ListModel(preReceiveScripts), (IModel)new CollectionModel(GitBlit.self().getPreReceiveScriptsUnused(this.repositoryModel)), (IChoiceRenderer)new StringChoiceRenderer(), 12, true);
        if (!ArrayUtils.isEmpty(this.repositoryModel.postReceiveScripts)) {
            postReceiveScripts.addAll(this.repositoryModel.postReceiveScripts);
        }
        final Palette postReceivePalette = new Palette("postReceiveScripts", (IModel)new ListModel(postReceiveScripts), (IModel)new CollectionModel(GitBlit.self().getPostReceiveScriptsUnused(this.repositoryModel)), (IChoiceRenderer)new StringChoiceRenderer(), 12, true);
        final Map<String, String> customFieldsMap = GitBlit.getMap("groovy.customFields");
        ArrayList<String> customKeys = new ArrayList<String>(customFieldsMap.keySet());
        ListView<String> customFieldsListView = new ListView<String>("customFieldsListView", customKeys){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                String key = (String)item.getModelObject();
                item.add(new Component[]{new Label("customFieldLabel", (String)customFieldsMap.get(key))});
                String value = "";
                if (EditRepositoryPage.this.repositoryModel.customFields != null && EditRepositoryPage.this.repositoryModel.customFields.containsKey(key)) {
                    value = EditRepositoryPage.this.repositoryModel.customFields.get(key);
                }
                TextField field = new TextField("customFieldValue", (IModel)new Model((Serializable)((Object)value)));
                item.add(new Component[]{field});
            }
        };
        customFieldsListView.setReuseItems(true);
        CompoundPropertyModel rModel = new CompoundPropertyModel((Object)this.repositoryModel);
        Form<RepositoryModel> form = new Form<RepositoryModel>("editForm", (IModel)rModel, (ListView)customFieldsListView, oldName, repositoryUsers, repositoryTeams){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ ListView val$customFieldsListView;
            final /* synthetic */ String val$oldName;
            final /* synthetic */ List val$repositoryUsers;
            final /* synthetic */ List val$repositoryTeams;
            {
                this.val$customFieldsListView = listView;
                this.val$oldName = string;
                this.val$repositoryUsers = list;
                this.val$repositoryTeams = list2;
                super(x0, x1);
            }

            protected void onSubmit() {
                try {
                    String ml;
                    Character c;
                    if (EditRepositoryPage.this.repositoryModel.name == null && StringUtils.isEmpty(EditRepositoryPage.this.repositoryModel.name)) {
                        this.error((Serializable)((Object)this.getString("gb.pleaseSetRepositoryName")));
                        return;
                    }
                    EditRepositoryPage.this.repositoryModel.name = EditRepositoryPage.this.repositoryModel.name.trim();
                    EditRepositoryPage.this.repositoryModel.name = EditRepositoryPage.this.repositoryModel.name.replace('\\', '/');
                    EditRepositoryPage.this.repositoryModel.name = EditRepositoryPage.this.repositoryModel.name.replace("//", "/");
                    if (EditRepositoryPage.this.repositoryModel.name.startsWith("/")) {
                        this.error((Serializable)((Object)this.getString("gb.illegalLeadingSlash")));
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.name.startsWith("../")) {
                        this.error((Serializable)((Object)this.getString("gb.illegalRelativeSlash")));
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.name.contains("/../")) {
                        this.error((Serializable)((Object)this.getString("gb.illegalRelativeSlash")));
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.name.endsWith("/")) {
                        EditRepositoryPage.this.repositoryModel.name = EditRepositoryPage.this.repositoryModel.name.substring(0, EditRepositoryPage.this.repositoryModel.name.length() - 1);
                    }
                    if ((c = StringUtils.findInvalidCharacter(EditRepositoryPage.this.repositoryModel.name)) != null) {
                        this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.illegalCharacterRepositoryName"), c)));
                        return;
                    }
                    if (user.canCreate() && !user.canAdmin() && allowEditName) {
                        if (!EditRepositoryPage.this.repositoryModel.name.startsWith(user.getPersonalPath())) {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.illegalPersonalRepositoryLocation"), user.getPersonalPath())));
                            return;
                        }
                        if (EditRepositoryPage.this.repositoryModel.name.equals(user.getPersonalPath())) {
                            EditRepositoryPage.this.repositoryModel.name = user.getPersonalPath() + "/";
                            this.error((Serializable)((Object)this.getString("gb.pleaseSetRepositoryName")));
                            return;
                        }
                    }
                    if (EditRepositoryPage.this.repositoryModel.accessRestriction == null) {
                        this.error((Serializable)((Object)this.getString("gb.selectAccessRestriction")));
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.federationStrategy == null) {
                        this.error((Serializable)((Object)this.getString("gb.selectFederationStrategy")));
                        return;
                    }
                    if (EditRepositoryPage.this.repositoryModel.federationStrategy.exceeds(Constants.FederationStrategy.EXCLUDE)) {
                        EditRepositoryPage.this.repositoryModel.federationSets.clear();
                        Iterator sets = federationSetsPalette.getSelectedChoices();
                        while (sets.hasNext()) {
                            EditRepositoryPage.this.repositoryModel.federationSets.add((String)sets.next());
                        }
                    }
                    if (!StringUtils.isEmpty(ml = (String)EditRepositoryPage.this.mailingLists.getObject())) {
                        HashSet<String> list = new HashSet<String>();
                        for (String address : ml.split("(,|\\s)")) {
                            if (StringUtils.isEmpty(address)) continue;
                            list.add(address.toLowerCase());
                        }
                        EditRepositoryPage.this.repositoryModel.mailingLists = new ArrayList<String>(list);
                    }
                    ArrayList<String> indexedBranches = new ArrayList<String>();
                    Iterator branches = indexedBranchesPalette.getSelectedChoices();
                    while (branches.hasNext()) {
                        indexedBranches.add((String)branches.next());
                    }
                    EditRepositoryPage.this.repositoryModel.indexedBranches = indexedBranches;
                    ArrayList<String> preReceiveScripts = new ArrayList<String>();
                    Iterator pres = preReceivePalette.getSelectedChoices();
                    while (pres.hasNext()) {
                        preReceiveScripts.add((String)pres.next());
                    }
                    EditRepositoryPage.this.repositoryModel.preReceiveScripts = preReceiveScripts;
                    ArrayList<String> postReceiveScripts = new ArrayList<String>();
                    Iterator post = postReceivePalette.getSelectedChoices();
                    while (post.hasNext()) {
                        postReceiveScripts.add((String)post.next());
                    }
                    EditRepositoryPage.this.repositoryModel.postReceiveScripts = postReceiveScripts;
                    EditRepositoryPage.this.repositoryModel.customFields = new LinkedHashMap<String, String>();
                    for (int i = 0; i < this.val$customFieldsListView.size(); ++i) {
                        ListItem child = (ListItem)this.val$customFieldsListView.get(i);
                        String key = (String)child.getModelObject();
                        TextField field = (TextField)child.get("customFieldValue");
                        String value = field.getValue();
                        EditRepositoryPage.this.repositoryModel.customFields.put(key, value);
                    }
                    GitBlit.self().updateRepositoryModel(this.val$oldName, EditRepositoryPage.this.repositoryModel, EditRepositoryPage.this.isCreate);
                    if (EditRepositoryPage.this.repositoryModel.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE)) {
                        GitBlit.self().setUserAccessPermissions(EditRepositoryPage.this.repositoryModel, this.val$repositoryUsers);
                        GitBlit.self().setTeamAccessPermissions(EditRepositoryPage.this.repositoryModel, this.val$repositoryTeams);
                    }
                }
                catch (GitBlitException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    return;
                }
                this.setRedirect(false);
                this.setResponsePage(RepositoriesPage.class);
            }
        };
        form.add(new IBehavior[]{new SimpleAttributeModifier("autocomplete", (CharSequence)"off")});
        form.add(new Component[]{new TextField("name").setEnabled(allowEditName)});
        form.add(new Component[]{new TextField("description")});
        form.add(new Component[]{new DropDownChoice("owner", GitBlit.self().getAllUsernames()).setEnabled(GitBlitWebSession.get().canAdmin() && !this.repositoryModel.isPersonalRepository())});
        form.add(new Component[]{new CheckBox("allowForks").setEnabled(GitBlit.getBoolean("web.allowForking", true))});
        DropDownChoice accessRestriction = new DropDownChoice("accessRestriction", Arrays.asList(Constants.AccessRestrictionType.values()), (IChoiceRenderer)new AccessRestrictionRenderer());
        form.add(new Component[]{accessRestriction});
        form.add(new Component[]{new CheckBox("isFrozen")});
        form.add(new Component[]{new TextField("origin").setEnabled(false)});
        ArrayList<String> availableRefs = new ArrayList<String>();
        if (!ArrayUtils.isEmpty(this.repositoryModel.availableRefs)) {
            availableRefs.addAll(this.repositoryModel.availableRefs);
        }
        form.add(new Component[]{new DropDownChoice("HEAD", availableRefs).setEnabled(availableRefs.size() > 0)});
        boolean gcEnabled = GitBlit.getBoolean("git.enableGarbageCollection", false);
        List<Integer> gcPeriods = Arrays.asList(1, 2, 3, 4, 5, 7, 10, 14);
        form.add(new Component[]{new DropDownChoice("gcPeriod", gcPeriods, (IChoiceRenderer)new GCPeriodRenderer()).setEnabled(gcEnabled)});
        form.add(new Component[]{new TextField("gcThreshold").setEnabled(gcEnabled)});
        ArrayList<Constants.FederationStrategy> federationStrategies = new ArrayList<Constants.FederationStrategy>(Arrays.asList(Constants.FederationStrategy.values()));
        if (StringUtils.isEmpty(this.repositoryModel.origin)) {
            federationStrategies.remove((Object)Constants.FederationStrategy.FEDERATE_ORIGIN);
        }
        form.add(new Component[]{new DropDownChoice("federationStrategy", federationStrategies, (IChoiceRenderer)new FederationTypeRenderer())});
        form.add(new Component[]{new CheckBox("useTickets")});
        form.add(new Component[]{new CheckBox("useDocs")});
        form.add(new Component[]{new CheckBox("showRemoteBranches")});
        form.add(new Component[]{new CheckBox("showReadme")});
        form.add(new Component[]{new CheckBox("skipSizeCalculation")});
        form.add(new Component[]{new CheckBox("skipSummaryMetrics")});
        List<Integer> maxActivityCommits = Arrays.asList(-1, 0, 25, 50, 75, 100, 150, 200, 250, 500);
        form.add(new Component[]{new DropDownChoice("maxActivityCommits", maxActivityCommits, (IChoiceRenderer)new MaxActivityCommitsRenderer())});
        this.mailingLists = new Model((Serializable)((Object)(ArrayUtils.isEmpty(this.repositoryModel.mailingLists) ? "" : StringUtils.flattenStrings(this.repositoryModel.mailingLists, " "))));
        form.add(new Component[]{new TextField("mailingLists", this.mailingLists)});
        form.add(new Component[]{indexedBranchesPalette});
        List<Constants.AuthorizationControl> acList = Arrays.asList(Constants.AuthorizationControl.values());
        final RadioChoice authorizationControl = new RadioChoice("authorizationControl", acList, (IChoiceRenderer)new AuthorizationControlRenderer());
        form.add(new Component[]{authorizationControl});
        final CheckBox verifyCommitter = new CheckBox("verifyCommitter");
        verifyCommitter.setOutputMarkupId(true);
        form.add(new Component[]{verifyCommitter});
        form.add(new Component[]{usersPalette});
        form.add(new Component[]{teamsPalette});
        form.add(new Component[]{federationSetsPalette});
        form.add(new Component[]{preReceivePalette});
        form.add(new Component[]{new BulletListPanel("inheritedPreReceive", this.getString("gb.inherited"), GitBlit.self().getPreReceiveScriptsInherited(this.repositoryModel))});
        form.add(new Component[]{postReceivePalette});
        form.add(new Component[]{new BulletListPanel("inheritedPostReceive", this.getString("gb.inherited"), GitBlit.self().getPostReceiveScriptsInherited(this.repositoryModel))});
        WebMarkupContainer customFieldsSection = new WebMarkupContainer("customFieldsSection");
        customFieldsSection.add(new Component[]{customFieldsListView});
        form.add(new Component[]{customFieldsSection.setVisible(!GitBlit.getString("groovy.customFields", "").isEmpty())});
        if (this.repositoryModel.accessRestriction.equals((Object)Constants.AccessRestrictionType.NONE)) {
            usersPalette.setEnabled(false);
            teamsPalette.setEnabled(false);
            authorizationControl.setEnabled(false);
            verifyCommitter.setEnabled(false);
        } else {
            authorizationControl.setEnabled(true);
            verifyCommitter.setEnabled(true);
            boolean allowFineGrainedControls = this.repositoryModel.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED);
            usersPalette.setEnabled(allowFineGrainedControls);
            teamsPalette.setEnabled(allowFineGrainedControls);
        }
        accessRestriction.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean allowAuthorizationControl = EditRepositoryPage.this.repositoryModel.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE);
                authorizationControl.setEnabled(allowAuthorizationControl);
                verifyCommitter.setEnabled(allowAuthorizationControl);
                boolean allowFineGrainedControls = allowAuthorizationControl && EditRepositoryPage.this.repositoryModel.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED);
                usersPalette.setEnabled(allowFineGrainedControls);
                teamsPalette.setEnabled(allowFineGrainedControls);
                if (allowFineGrainedControls) {
                    EditRepositoryPage.this.repositoryModel.authorizationControl = Constants.AuthorizationControl.NAMED;
                }
                target.addComponent((Component)authorizationControl);
                target.addComponent((Component)verifyCommitter);
                target.addComponent((Component)usersPalette);
                target.addComponent((Component)teamsPalette);
            }
        }});
        authorizationControl.add(new IBehavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean allowAuthorizationControl = EditRepositoryPage.this.repositoryModel.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE);
                authorizationControl.setEnabled(allowAuthorizationControl);
                boolean allowFineGrainedControls = allowAuthorizationControl && EditRepositoryPage.this.repositoryModel.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED);
                usersPalette.setEnabled(allowFineGrainedControls);
                teamsPalette.setEnabled(allowFineGrainedControls);
                if (allowFineGrainedControls) {
                    EditRepositoryPage.this.repositoryModel.authorizationControl = Constants.AuthorizationControl.NAMED;
                }
                target.addComponent((Component)authorizationControl);
                target.addComponent((Component)usersPalette);
                target.addComponent((Component)teamsPalette);
            }
        }});
        form.add(new Component[]{new Button("save")});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(RepositoriesPage.class);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }

    private void checkPermissions(RepositoryModel model) {
        boolean authenticateAdmin = GitBlit.getBoolean("web.authenticateAdminPages", true);
        boolean allowAdmin = GitBlit.getBoolean("web.allowAdministration", true);
        GitBlitWebSession session = GitBlitWebSession.get();
        UserModel user = session.getUser();
        if (allowAdmin) {
            if (authenticateAdmin) {
                if (user == null) {
                    this.error(this.getString("gb.errorAdminLoginRequired"), true);
                }
                if (this.isCreate) {
                    if (!user.canCreate() && !user.canAdmin()) {
                        this.error(this.getString("gb.errorOnlyAdminMayCreateRepository"), true);
                    }
                } else {
                    if (user.canAdmin()) {
                        this.isAdmin = true;
                        return;
                    }
                    if (!model.owner.equalsIgnoreCase(user.username)) {
                        this.error(this.getString("gb.errorOnlyAdminOrOwnerMayEditRepository"), true);
                    }
                }
            }
        } else {
            this.error(this.getString("gb.errorAdministrationDisabled"), true);
        }
    }

    private class MaxActivityCommitsRenderer
    implements IChoiceRenderer<Integer> {
        private static final long serialVersionUID = 1L;

        public String getDisplayValue(Integer value) {
            if (value == -1) {
                return EditRepositoryPage.this.getString("gb.excludeFromActivity");
            }
            if (value == 0) {
                return EditRepositoryPage.this.getString("gb.noMaximum");
            }
            return value + " " + EditRepositoryPage.this.getString("gb.commits");
        }

        public String getIdValue(Integer value, int index) {
            return Integer.toString(index);
        }
    }

    private class GCPeriodRenderer
    implements IChoiceRenderer<Integer> {
        private static final long serialVersionUID = 1L;

        public String getDisplayValue(Integer value) {
            if (value == 1) {
                return EditRepositoryPage.this.getString("gb.duration.oneDay");
            }
            return MessageFormat.format(EditRepositoryPage.this.getString("gb.duration.days"), value);
        }

        public String getIdValue(Integer value, int index) {
            return Integer.toString(index);
        }
    }

    private class AuthorizationControlRenderer
    implements IChoiceRenderer<Constants.AuthorizationControl> {
        private static final long serialVersionUID = 1L;
        private final Map<Constants.AuthorizationControl, String> map;

        public AuthorizationControlRenderer() {
            this.map = EditRepositoryPage.this.getAuthorizationControls();
        }

        public String getDisplayValue(Constants.AuthorizationControl type) {
            return this.map.get((Object)type);
        }

        public String getIdValue(Constants.AuthorizationControl type, int index) {
            return Integer.toString(index);
        }
    }

    private class FederationTypeRenderer
    implements IChoiceRenderer<Constants.FederationStrategy> {
        private static final long serialVersionUID = 1L;
        private final Map<Constants.FederationStrategy, String> map;

        public FederationTypeRenderer() {
            this.map = EditRepositoryPage.this.getFederationTypes();
        }

        public String getDisplayValue(Constants.FederationStrategy type) {
            return this.map.get((Object)type);
        }

        public String getIdValue(Constants.FederationStrategy type, int index) {
            return Integer.toString(index);
        }
    }

    private class AccessRestrictionRenderer
    implements IChoiceRenderer<Constants.AccessRestrictionType> {
        private static final long serialVersionUID = 1L;
        private final Map<Constants.AccessRestrictionType, String> map;

        public AccessRestrictionRenderer() {
            this.map = EditRepositoryPage.this.getAccessRestrictions();
        }

        public String getDisplayValue(Constants.AccessRestrictionType type) {
            return this.map.get((Object)type);
        }

        public String getIdValue(Constants.AccessRestrictionType type, int index) {
            return Integer.toString(index);
        }
    }
}

