/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.GitBlitException;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.RequiresAdminRole;
import com.gitblit.wicket.StringChoiceRenderer;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.pages.UsersPage;
import com.gitblit.wicket.panels.RegistrantPermissionsPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;

@RequiresAdminRole
public class EditUserPage
extends RootSubPage {
    private final boolean isCreate;

    public EditUserPage() {
        if (!GitBlit.self().supportsCredentialChanges()) {
            this.error(MessageFormat.format(this.getString("gb.userServiceDoesNotPermitAddUser"), GitBlit.getString("realm.userService", "users.conf")), true);
        }
        this.isCreate = true;
        this.setupPage(new UserModel(""));
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    public EditUserPage(PageParameters params) {
        super(params);
        this.isCreate = false;
        String name = WicketUtils.getUsername(params);
        UserModel model = GitBlit.self().getUserModel(name);
        this.setupPage(model);
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
    }

    @Override
    protected boolean requiresPageMap() {
        return true;
    }

    protected void setupPage(final UserModel userModel) {
        if (this.isCreate) {
            super.setupPage(this.getString("gb.newUser"), "");
        } else {
            super.setupPage(this.getString("gb.edit"), userModel.username);
        }
        final Model confirmPassword = new Model((Serializable)((Object)(StringUtils.isEmpty(userModel.password) ? "" : userModel.password)));
        CompoundPropertyModel model = new CompoundPropertyModel((Object)userModel);
        List<String> repos = this.getAccessRestrictedRepositoryList(true, userModel);
        ArrayList<String> userTeams = new ArrayList<String>();
        for (TeamModel team : userModel.teams) {
            userTeams.add(team.name);
        }
        Collections.sort(userTeams);
        final String oldName = userModel.username;
        final List<RegistrantAccessPermission> permissions = GitBlit.self().getUserAccessPermissions(userModel);
        final Palette teams = new Palette("teams", (IModel)new ListModel(new ArrayList(userTeams)), (IModel)new CollectionModel(GitBlit.self().getAllTeamnames()), (IChoiceRenderer)new StringChoiceRenderer(), 10, false);
        Form<UserModel> form = new Form<UserModel>("editForm", (IModel)model){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                boolean rename;
                UserModel model;
                if (StringUtils.isEmpty(userModel.username)) {
                    this.error((Serializable)((Object)this.getString("gb.pleaseSetUsername")));
                    return;
                }
                String username = userModel.username = userModel.username.toLowerCase();
                if (EditUserPage.this.isCreate && (model = GitBlit.self().getUserModel(username)) != null) {
                    this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.usernameUnavailable"), username)));
                    return;
                }
                boolean bl = rename = !StringUtils.isEmpty(oldName) && !oldName.equalsIgnoreCase(username);
                if (GitBlit.self().supportsCredentialChanges()) {
                    if (!userModel.password.equals(confirmPassword.getObject())) {
                        this.error((Serializable)((Object)this.getString("gb.passwordsDoNotMatch")));
                        return;
                    }
                    String password = userModel.password;
                    if (!password.toUpperCase().startsWith("MD5:") && !password.toUpperCase().startsWith("CMD5:")) {
                        int minLength = GitBlit.getInteger("realm.minPasswordLength", 5);
                        if (minLength < 4) {
                            minLength = 4;
                        }
                        if (password.trim().length() < minLength) {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.passwordTooShort"), minLength)));
                            return;
                        }
                        String type = GitBlit.getString("realm.passwordStorage", "md5");
                        if (type.equalsIgnoreCase("md5")) {
                            userModel.password = "MD5:" + StringUtils.getMD5(userModel.password);
                        } else if (type.equalsIgnoreCase("combined-md5")) {
                            userModel.password = "CMD5:" + StringUtils.getMD5(username + userModel.password);
                        }
                    } else if (rename && password.toUpperCase().startsWith("CMD5:")) {
                        this.error((Serializable)((Object)this.getString("gb.combinedMd5Rename")));
                        return;
                    }
                }
                for (RegistrantAccessPermission repositoryPermission : permissions) {
                    userModel.setRepositoryPermission(repositoryPermission.registrant, repositoryPermission.permission);
                }
                Iterator selectedTeams = teams.getSelectedChoices();
                userModel.teams.clear();
                while (selectedTeams.hasNext()) {
                    TeamModel team = GitBlit.self().getTeamModel((String)selectedTeams.next());
                    if (team == null) continue;
                    userModel.teams.add(team);
                }
                try {
                    GitBlit.self().updateUserModel(oldName, userModel, EditUserPage.this.isCreate);
                }
                catch (GitBlitException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    return;
                }
                this.setRedirect(false);
                if (EditUserPage.this.isCreate) {
                    this.info(MessageFormat.format(this.getString("gb.userCreated"), userModel.username));
                    this.setResponsePage(EditUserPage.class);
                } else {
                    this.setResponsePage(UsersPage.class);
                }
            }
        };
        form.add(new IBehavior[]{new SimpleAttributeModifier("autocomplete", (CharSequence)"off")});
        boolean editCredentials = GitBlit.self().supportsCredentialChanges();
        boolean editDisplayName = GitBlit.self().supportsDisplayNameChanges();
        boolean editEmailAddress = GitBlit.self().supportsEmailAddressChanges();
        boolean editTeams = GitBlit.self().supportsTeamMembershipChanges();
        form.add(new Component[]{new TextField("username").setEnabled(editCredentials)});
        PasswordTextField passwordField = new PasswordTextField("password");
        passwordField.setResetPassword(false);
        form.add(new Component[]{passwordField.setEnabled(editCredentials)});
        PasswordTextField confirmPasswordField = new PasswordTextField("confirmPassword", (IModel)confirmPassword);
        confirmPasswordField.setResetPassword(false);
        form.add(new Component[]{confirmPasswordField.setEnabled(editCredentials)});
        form.add(new Component[]{new TextField("displayName").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("emailAddress").setEnabled(editEmailAddress)});
        form.add(new Component[]{new CheckBox("canAdmin")});
        form.add(new Component[]{new CheckBox("canFork").setEnabled(GitBlit.getBoolean("web.allowForking", true))});
        form.add(new Component[]{new CheckBox("canCreate")});
        form.add(new Component[]{new CheckBox("excludeFromFederation")});
        form.add(new Component[]{new RegistrantPermissionsPanel("repositories", Constants.RegistrantType.REPOSITORY, repos, permissions, this.getAccessPermissions())});
        form.add(new Component[]{teams.setEnabled(editTeams)});
        form.add(new Component[]{new TextField("organizationalUnit").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("organization").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("locality").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("stateProvince").setEnabled(editDisplayName)});
        form.add(new Component[]{new TextField("countryCode").setEnabled(editDisplayName)});
        form.add(new Component[]{new Button("save")});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(UsersPage.class);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

