/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.panels.RepositoryUrlPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;

public class EmptyRepositoryPage
extends RootPage {
    public EmptyRepositoryPage(PageParameters params) {
        super(params);
        this.setVersioned(false);
        String repositoryName = WicketUtils.getRepositoryName(params);
        RepositoryModel repository = GitBlit.self().getRepositoryModel(repositoryName);
        if (repository == null) {
            this.error(this.getString("gb.canNotLoadRepository") + " " + repositoryName, true);
        }
        if (repository.hasCommits) {
            throw new GitblitRedirectException(SummaryPage.class, params);
        }
        this.setupPage(repositoryName, this.getString("gb.emptyRepository"));
        ArrayList<String> repositoryUrls = new ArrayList<String>();
        if (GitBlit.getBoolean("git.enableGitServlet", true)) {
            repositoryUrls.add(EmptyRepositoryPage.getRepositoryUrl(repository));
        }
        repositoryUrls.addAll(GitBlit.self().getOtherCloneUrls(repositoryName));
        String primaryUrl = ArrayUtils.isEmpty(repositoryUrls) ? "" : (String)repositoryUrls.get(0);
        this.add(new Component[]{new Label("repository", repositoryName)});
        this.add(new Component[]{new RepositoryUrlPanel("pushurl", primaryUrl)});
        this.add(new Component[]{new Label("cloneSyntax", MessageFormat.format("git clone {0}", repositoryUrls.get(0)))});
        this.add(new Component[]{new Label("remoteSyntax", MessageFormat.format("git remote add gitblit {0}\ngit push gitblit master", primaryUrl))});
    }
}

