/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.FederationModel;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RootSubPage;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class FederationRegistrationPage
extends RootSubPage {
    public FederationRegistrationPage(PageParameters params) {
        super(params);
        this.setStatelessHint(true);
        String url = WicketUtils.getUrlParameter(params);
        String name = WicketUtils.getNameParameter(params);
        FederationModel registration = GitBlit.self().getFederationRegistration(url, name);
        if (registration == null) {
            this.error(this.getString("gb.couldNotFindFederationRegistration"), true);
        }
        this.setupPage(registration.isResultData() ? this.getString("gb.federationResults") : this.getString("gb.federationRegistration"), registration.url);
        this.add(new Component[]{new Label("url", registration.url)});
        this.add(new Component[]{WicketUtils.getRegistrationImage("typeIcon", registration, (Component)this)});
        this.add(new Component[]{new Label("frequency", registration.frequency)});
        this.add(new Component[]{new Label("folder", registration.folder)});
        this.add(new Component[]{new Label("token", this.showAdmin ? registration.token : "--")});
        this.add(new Component[]{WicketUtils.createTimestampLabel("lastPull", registration.lastPull, this.getTimeZone(), this.getTimeUtils())});
        this.add(new Component[]{WicketUtils.createTimestampLabel("nextPull", registration.nextPull, this.getTimeZone(), this.getTimeUtils())});
        StringBuilder inclusions = new StringBuilder();
        for (String inc : registration.inclusions) {
            inclusions.append(inc).append("<br/>");
        }
        StringBuilder exclusions = new StringBuilder();
        for (String ex : registration.exclusions) {
            exclusions.append(ex).append("<br/>");
        }
        this.add(new Component[]{new Label("inclusions", inclusions.toString()).setEscapeModelStrings(false)});
        this.add(new Component[]{new Label("exclusions", exclusions.toString()).setEscapeModelStrings(false)});
        List<FederationModel.RepositoryStatus> list = registration.getStatusList();
        Collections.sort(list);
        DataView<FederationModel.RepositoryStatus> dataView = new DataView<FederationModel.RepositoryStatus>("row", (IDataProvider)new ListDataProvider(list)){
            private static final long serialVersionUID = 1L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<FederationModel.RepositoryStatus> item) {
                FederationModel.RepositoryStatus entry = (FederationModel.RepositoryStatus)item.getModelObject();
                item.add(new Component[]{WicketUtils.getPullStatusImage("statusIcon", entry.status)});
                item.add(new Component[]{new Label("name", entry.name)});
                item.add(new Component[]{new Label("status", entry.status.name())});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{dataView});
    }
}

