/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.SearchPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;

public class GitSearchPage
extends RepositoryPage {
    public GitSearchPage(PageParameters params) {
        super(params);
        String value = WicketUtils.getSearchString(params);
        String type = WicketUtils.getSearchType(params);
        Constants.SearchType searchType = Constants.SearchType.forName(type);
        int pageNumber = WicketUtils.getPage(params);
        int prevPage = Math.max(0, pageNumber - 1);
        int nextPage = pageNumber + 1;
        SearchPanel search = new SearchPanel("searchPanel", this.repositoryName, this.objectId, value, searchType, this.getRepository(), -1, pageNumber - 1, this.getRepositoryModel().showRemoteBranches);
        boolean hasMore = search.hasMore();
        this.add(new Component[]{search});
        this.add(new Component[]{new BookmarkablePageLink("firstPageTop", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageTop", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageTop", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType, nextPage)).setEnabled(hasMore)});
        this.add(new Component[]{new BookmarkablePageLink("firstPageBottom", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageBottom", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageBottom", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType, nextPage)).setEnabled(hasMore)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.search");
    }
}

