/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.Metric;
import com.gitblit.utils.MetricUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import java.awt.Color;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.eclipse.jgit.lib.Repository;
import org.wicketstuff.googlecharts.Chart;
import org.wicketstuff.googlecharts.ChartAxis;
import org.wicketstuff.googlecharts.ChartAxisType;
import org.wicketstuff.googlecharts.ChartProvider;
import org.wicketstuff.googlecharts.ChartType;
import org.wicketstuff.googlecharts.IChartAxis;
import org.wicketstuff.googlecharts.IChartData;
import org.wicketstuff.googlecharts.IChartProvider;
import org.wicketstuff.googlecharts.ILineStyle;
import org.wicketstuff.googlecharts.IShapeMarker;
import org.wicketstuff.googlecharts.LineStyle;
import org.wicketstuff.googlecharts.MarkerType;
import org.wicketstuff.googlecharts.ShapeMarker;

public class MetricsPage
extends RepositoryPage {
    public MetricsPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        if (StringUtils.isEmpty(this.objectId)) {
            this.add(new Component[]{new Label("branchTitle", this.getRepositoryModel().HEAD)});
        } else {
            this.add(new Component[]{new Label("branchTitle", this.objectId)});
        }
        Metric metricsTotal = null;
        List<Metric> metrics = MetricUtils.getDateMetrics(r, this.objectId, true, null, this.getTimeZone());
        metricsTotal = metrics.remove(0);
        if (metricsTotal == null) {
            this.add(new Component[]{new Label("branchStats", "")});
        } else {
            this.add(new Component[]{new Label("branchStats", MessageFormat.format(this.getString("gb.branchStats"), metricsTotal.count, metricsTotal.tag, this.getTimeUtils().duration(metricsTotal.duration)))});
        }
        this.insertLinePlot("commitsChart", metrics);
        this.insertBarPlot("dayOfWeekChart", this.getDayOfWeekMetrics(r, this.objectId));
        this.insertPieChart("authorsChart", this.getAuthorMetrics(r, this.objectId));
    }

    private void insertLinePlot(String wicketId, List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0) {
            IChartData data = WicketUtils.getChartData(metrics);
            ChartProvider provider = new ChartProvider(new Dimension(400, 100), ChartType.LINE, data);
            ChartAxis dateAxis = new ChartAxis(ChartAxisType.BOTTOM);
            dateAxis.setLabels(new String[]{metrics.get((int)0).name, metrics.get((int)(metrics.size() / 2)).name, metrics.get((int)(metrics.size() - 1)).name});
            provider.addAxis((IChartAxis)dateAxis);
            ChartAxis commitAxis = new ChartAxis(ChartAxisType.LEFT);
            commitAxis.setLabels(new String[]{"", String.valueOf((int)WicketUtils.maxValue(metrics))});
            provider.addAxis((IChartAxis)commitAxis);
            provider.setLineStyles((ILineStyle[])new LineStyle[]{new LineStyle(2, 4, 0), new LineStyle(0, 4, 1)});
            provider.addShapeMarker((IShapeMarker)new ShapeMarker(MarkerType.CIRCLE, Color.BLUE, 1, -1.0, 5));
            this.add(new Component[]{new Chart(wicketId, (IChartProvider)provider)});
        } else {
            this.add(new Component[]{WicketUtils.newBlankImage(wicketId)});
        }
    }

    private void insertBarPlot(String wicketId, List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0) {
            IChartData data = WicketUtils.getChartData(metrics);
            ChartProvider provider = new ChartProvider(new Dimension(400, 100), ChartType.BAR_VERTICAL_SET, data);
            ChartAxis dateAxis = new ChartAxis(ChartAxisType.BOTTOM);
            ArrayList<String> labels = new ArrayList<String>();
            for (Metric metric : metrics) {
                labels.add(metric.name);
            }
            dateAxis.setLabels(labels.toArray(new String[labels.size()]));
            provider.addAxis((IChartAxis)dateAxis);
            ChartAxis commitAxis = new ChartAxis(ChartAxisType.LEFT);
            commitAxis.setLabels(new String[]{"", String.valueOf((int)WicketUtils.maxValue(metrics))});
            provider.addAxis((IChartAxis)commitAxis);
            this.add(new Component[]{new Chart(wicketId, (IChartProvider)provider)});
        } else {
            this.add(new Component[]{WicketUtils.newBlankImage(wicketId)});
        }
    }

    private void insertPieChart(String wicketId, List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0) {
            IChartData data = WicketUtils.getChartData(metrics);
            ArrayList<String> labels = new ArrayList<String>();
            for (Metric metric : metrics) {
                labels.add(metric.name);
            }
            ChartProvider provider = new ChartProvider(new Dimension(800, 200), ChartType.PIE, data);
            provider.setPieLabels(labels.toArray(new String[labels.size()]));
            this.add(new Component[]{new Chart(wicketId, (IChartProvider)provider)});
        } else {
            this.add(new Component[]{WicketUtils.newBlankImage(wicketId)});
        }
    }

    private List<Metric> getDayOfWeekMetrics(Repository repository, String objectId) {
        List<Metric> list = MetricUtils.getDateMetrics(repository, objectId, false, "E", this.getTimeZone());
        SimpleDateFormat sdf = new SimpleDateFormat("E");
        Calendar cal = Calendar.getInstance();
        ArrayList<Metric> sorted = new ArrayList<Metric>();
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        int dayOfWeek = cal.get(7);
        cal.add(5, firstDayOfWeek - dayOfWeek);
        for (int i = 0; i < 7; ++i) {
            String day = sdf.format(cal.getTime());
            for (Metric metric : list) {
                if (!metric.name.equals(day)) continue;
                sorted.add(metric);
                list.remove(metric);
                break;
            }
            cal.add(5, 1);
        }
        return sorted;
    }

    private List<Metric> getAuthorMetrics(Repository repository, String objectId) {
        List<Metric> authors = MetricUtils.getAuthorMetrics(repository, objectId, true);
        Collections.sort(authors, new Comparator<Metric>(){

            @Override
            public int compare(Metric o1, Metric o2) {
                if (o1.count > o2.count) {
                    return -1;
                }
                if (o1.count < o2.count) {
                    return 1;
                }
                return 0;
            }
        });
        if (authors.size() > 10) {
            return authors.subList(0, 9);
        }
        return authors;
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.metrics");
    }
}

