/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoriesPage;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class PatchPage
extends WebPage {
    public PatchPage(PageParameters params) {
        super(params);
        if (!params.containsKey((Object)"r")) {
            GitBlitWebSession.get().cacheErrorMessage(this.getString("gb.repositoryNotSpecified"));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
            return;
        }
        String repositoryName = WicketUtils.getRepositoryName(params);
        String baseObjectId = WicketUtils.getBaseObjectId(params);
        String objectId = WicketUtils.getObject(params);
        String blobPath = WicketUtils.getPath(params);
        Repository r = GitBlit.self().getRepository(repositoryName);
        if (r == null) {
            GitBlitWebSession.get().cacheErrorMessage(this.getString("gb.canNotLoadRepository") + " " + repositoryName);
            this.redirectToInterceptPage((Page)new RepositoriesPage());
            return;
        }
        RevCommit commit = JGitUtils.getCommit(r, objectId);
        if (commit == null) {
            GitBlitWebSession.get().cacheErrorMessage(this.getString("gb.commitIsNull"));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
            return;
        }
        RevCommit baseCommit = null;
        if (!StringUtils.isEmpty(baseObjectId)) {
            baseCommit = JGitUtils.getCommit(r, baseObjectId);
        }
        String patch = DiffUtils.getCommitPatch(r, baseCommit, commit, blobPath);
        this.add(new Component[]{new Label("patchText", patch)});
        r.close();
    }
}

