/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.SyndicationServlet;
import com.gitblit.models.Activity;
import com.gitblit.models.Metric;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ActivityUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.charting.GoogleChart;
import com.gitblit.wicket.charting.GoogleCharts;
import com.gitblit.wicket.charting.GoogleLineChart;
import com.gitblit.wicket.charting.GooglePieChart;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.panels.ActivityPanel;
import com.gitblit.wicket.panels.ProjectRepositoryPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class ProjectPage
extends RootPage {
    List<ProjectModel> projectModels = new ArrayList<ProjectModel>();

    public ProjectPage() {
        throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
    }

    public ProjectPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    private void setup(PageParameters params) {
        String objectId;
        List<Activity> recentActivity;
        this.setupPage("", "");
        boolean authenticateView = GitBlit.getBoolean("web.authenticateViewPages", true);
        if (authenticateView && !GitBlitWebSession.get().isLoggedIn()) {
            this.authenticationError("Please login");
            return;
        }
        String projectName = WicketUtils.getProjectName(params);
        if (StringUtils.isEmpty(projectName)) {
            throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
        }
        ProjectModel project = this.getProjectModel(projectName);
        if (project == null) {
            throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
        }
        this.add(new Component[]{new Label("projectTitle", project.getDisplayName())});
        this.add(new Component[]{new Label("projectDescription", project.description)});
        String feedLink = SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), projectName, null, 0);
        this.add(new Component[]{new ExternalLink("syndication", feedLink)});
        this.add(new IBehavior[]{WicketUtils.syndicationDiscoveryLink(SyndicationServlet.getTitle(project.getDisplayName(), null), feedLink)});
        String projectPath = project.isRoot ? "" : projectName + "/";
        File pmkd = new File(GitBlit.getRepositoriesFolder(), projectPath + "project.mkd");
        String pmessage = this.readMarkdown(projectName, pmkd);
        Component projectMessage = new Label("projectMessage", pmessage).setEscapeModelStrings(false).setVisible(pmessage.length() > 0);
        this.add(new Component[]{projectMessage});
        File rmkd = new File(GitBlit.getRepositoriesFolder(), projectPath + "repositories.mkd");
        String rmessage = this.readMarkdown(projectName, rmkd);
        Component repositoriesMessage = new Label("repositoriesMessage", rmessage).setEscapeModelStrings(false).setVisible(rmessage.length() > 0);
        this.add(new Component[]{repositoriesMessage});
        List<RepositoryModel> repositories = this.getRepositories(params);
        Collections.sort(repositories, new Comparator<RepositoryModel>(){

            @Override
            public int compare(RepositoryModel o1, RepositoryModel o2) {
                return o2.lastChange.compareTo(o1.lastChange);
            }
        });
        ListDataProvider dp = new ListDataProvider(repositories);
        DataView<RepositoryModel> dataView = new DataView<RepositoryModel>("repositoryList", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<RepositoryModel> item) {
                RepositoryModel entry = (RepositoryModel)item.getModelObject();
                ProjectRepositoryPanel row = new ProjectRepositoryPanel("repository", this.getLocalizer(), (Component)this, ProjectPage.this.showAdmin, entry, ProjectPage.this.getAccessRestrictions());
                item.add(new Component[]{row});
            }
        };
        this.add(new Component[]{dataView});
        int daysBack = WicketUtils.getDaysBack(params);
        if (daysBack < 1) {
            daysBack = 14;
        }
        if ((recentActivity = ActivityUtils.getRecentActivity(repositories, daysBack, objectId = WicketUtils.getObject(params), this.getTimeZone())).size() == 0) {
            this.add(new Component[]{new Label("subheader", MessageFormat.format(this.getString("gb.recentActivityNone"), daysBack))});
            this.add(new Component[]{new Label("activityPanel")});
        } else {
            int totalCommits = 0;
            HashSet<String> uniqueAuthors = new HashSet<String>();
            for (Activity activity : recentActivity) {
                totalCommits += activity.getCommitCount();
                uniqueAuthors.addAll(activity.getAuthorMetrics().keySet());
            }
            int totalAuthors = uniqueAuthors.size();
            this.add(new Component[]{new Label("subheader", MessageFormat.format(this.getString("gb.recentActivityStats"), daysBack, totalCommits, totalAuthors))});
            GoogleCharts charts = this.createCharts(recentActivity);
            this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)charts)});
            this.add(new Component[]{new ActivityPanel("activityPanel", recentActivity)});
        }
    }

    private GoogleCharts createCharts(List<Activity> recentActivity) {
        HashMap<String, Metric> repositoryMetrics = new HashMap<String, Metric>();
        HashMap<String, Metric> authorMetrics = new HashMap<String, Metric>();
        for (Activity activity : recentActivity) {
            for (Map.Entry<String, Metric> entry : activity.getAuthorMetrics().entrySet()) {
                String author = entry.getKey();
                if (!authorMetrics.containsKey(author)) {
                    authorMetrics.put(author, new Metric(author));
                }
                ((Metric)authorMetrics.get((Object)author)).count += entry.getValue().count;
            }
            for (Map.Entry<String, Metric> entry : activity.getRepositoryMetrics().entrySet()) {
                String repository = StringUtils.stripDotGit(entry.getKey());
                if (!repositoryMetrics.containsKey(repository)) {
                    repositoryMetrics.put(repository, new Metric(repository));
                }
                ((Metric)repositoryMetrics.get((Object)repository)).count += entry.getValue().count;
            }
        }
        int w = 310;
        int h = 150;
        GoogleCharts charts = new GoogleCharts();
        Collections.sort(recentActivity);
        Collections.reverse(recentActivity);
        GoogleChart chart = new GoogleLineChart("chartDaily", this.getString("gb.dailyActivity"), "day", this.getString("gb.commits"));
        SimpleDateFormat df = new SimpleDateFormat("MMM dd");
        df.setTimeZone(this.getTimeZone());
        for (Comparable<Activity> metric : recentActivity) {
            chart.addValue(df.format(metric.startDate), metric.getCommitCount());
        }
        chart.setWidth(w);
        chart.setHeight(h);
        charts.addChart(chart);
        chart = new GooglePieChart("chartRepositories", this.getString("gb.activeRepositories"), this.getString("gb.repository"), this.getString("gb.commits"));
        for (Comparable<Activity> metric : repositoryMetrics.values()) {
            chart.addValue(((Metric)metric).name, ((Metric)metric).count);
        }
        chart.setWidth(w);
        chart.setHeight(h);
        charts.addChart(chart);
        chart = new GooglePieChart("chartAuthors", this.getString("gb.activeAuthors"), this.getString("gb.author"), this.getString("gb.commits"));
        for (Comparable<Activity> metric : authorMetrics.values()) {
            chart.addValue(((Metric)metric).name, ((Metric)metric).count);
        }
        chart.setWidth(w);
        chart.setHeight(h);
        charts.addChart(chart);
        return charts;
    }

    @Override
    protected void addDropDownMenus(List<PageRegistration> pages) {
        PageParameters params = this.getPageParameters();
        PageRegistration.DropDownMenuRegistration projects = new PageRegistration.DropDownMenuRegistration("gb.projects", ProjectPage.class);
        projects.menuItems.addAll(this.getProjectsMenu());
        pages.add(0, projects);
        PageRegistration.DropDownMenuRegistration menu = new PageRegistration.DropDownMenuRegistration("gb.filters", ProjectPage.class);
        menu.menuItems.addAll(this.getRepositoryFilterItems(params));
        menu.menuItems.addAll(this.getTimeFilterItems(params));
        if (menu.menuItems.size() > 0) {
            menu.menuItems.add(new PageRegistration.DropDownMenuItem(this.getString("gb.reset"), null, null));
        }
        pages.add(menu);
    }

    @Override
    protected List<ProjectModel> getProjectModels() {
        if (this.projectModels.isEmpty()) {
            UserModel user = GitBlitWebSession.get().getUser();
            List<ProjectModel> projects = GitBlit.self().getProjectModels(user, false);
            this.projectModels.addAll(projects);
        }
        return this.projectModels;
    }

    private ProjectModel getProjectModel(String name) {
        for (ProjectModel project : this.getProjectModels()) {
            if (!name.equalsIgnoreCase(project.name)) continue;
            return project;
        }
        return null;
    }

    protected List<PageRegistration.DropDownMenuItem> getProjectsMenu() {
        boolean showAllProjects;
        ArrayList<PageRegistration.DropDownMenuItem> menu = new ArrayList<PageRegistration.DropDownMenuItem>();
        List<ProjectModel> projects = new ArrayList<ProjectModel>();
        for (ProjectModel model : this.getProjectModels()) {
            if (model.isUserProject()) continue;
            projects.add(model);
        }
        int maxProjects = 15;
        boolean bl = showAllProjects = projects.size() > maxProjects;
        if (showAllProjects) {
            Collections.sort(projects, new Comparator<ProjectModel>(){

                @Override
                public int compare(ProjectModel o1, ProjectModel o2) {
                    return o2.lastChange.compareTo(o1.lastChange);
                }
            });
            projects = projects.subList(0, maxProjects);
            Collections.sort(projects);
        }
        for (ProjectModel project : projects) {
            menu.add(new PageRegistration.DropDownMenuItem(project.getDisplayName(), "p", project.name));
        }
        if (showAllProjects) {
            menu.add(new PageRegistration.DropDownMenuItem());
            menu.add(new PageRegistration.DropDownMenuItem("all projects", null, null));
        }
        return menu;
    }

    private String readMarkdown(String projectName, File projectMessage) {
        String message = "";
        if (projectMessage.exists()) {
            try {
                FileInputStream fis = new FileInputStream(projectMessage);
                InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
                message = MarkdownUtils.transformMarkdown(reader);
                reader.close();
            }
            catch (Throwable t) {
                message = this.getString("gb.failedToRead") + " " + projectMessage;
                this.warn(message, t);
            }
        }
        return message;
    }
}

