/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoriesPage;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebResponse;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawPage
extends WebPage {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getSimpleName());

    public RawPage(final PageParameters params) {
        super(params);
        if (!params.containsKey((Object)"r")) {
            this.error((Serializable)((Object)this.getString("gb.repositoryNotSpecified")));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
        }
        this.getRequestCycle().setRequestTarget(new IRequestTarget(){

            public void detach(RequestCycle requestCycle) {
            }

            public void respond(RequestCycle requestCycle) {
                WebResponse response = (WebResponse)requestCycle.getResponse();
                String repositoryName = WicketUtils.getRepositoryName(params);
                String objectId = WicketUtils.getObject(params);
                String blobPath = WicketUtils.getPath(params);
                String[] encodings = GitBlit.getEncodings();
                Repository r = GitBlit.self().getRepository(repositoryName);
                if (r == null) {
                    RawPage.this.error((Serializable)((Object)(RawPage.this.getString("gb.canNotLoadRepository") + " " + repositoryName)));
                    RawPage.this.redirectToInterceptPage((Page)new RepositoriesPage());
                    return;
                }
                if (StringUtils.isEmpty(blobPath)) {
                    byte[] binary = JGitUtils.getByteContent(r, objectId);
                    response.setContentType("application/octet-stream");
                    response.setContentLength((long)binary.length);
                    try {
                        response.getOutputStream().write(binary);
                    }
                    catch (Exception e) {
                        RawPage.this.logger.error("Failed to write binary response", (Throwable)e);
                    }
                } else {
                    RevCommit commit = JGitUtils.getCommit(r, objectId);
                    String filename = blobPath;
                    if (blobPath.indexOf(47) > -1) {
                        filename = blobPath.substring(blobPath.lastIndexOf(47) + 1);
                    }
                    String extension = null;
                    if (blobPath.lastIndexOf(46) > -1) {
                        extension = blobPath.substring(blobPath.lastIndexOf(46) + 1);
                    }
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    for (String ext : GitBlit.getStrings("web.imageExtensions")) {
                        map.put(ext.toLowerCase(), 2);
                    }
                    for (String ext : GitBlit.getStrings("web.binaryExtensions")) {
                        map.put(ext.toLowerCase(), 3);
                    }
                    if (extension != null) {
                        int type = 0;
                        if (map.containsKey(extension)) {
                            type = (Integer)map.get(extension);
                        }
                        switch (type) {
                            case 2: {
                                byte[] image = JGitUtils.getByteContent(r, commit.getTree(), blobPath);
                                response.setContentType("image/" + extension.toLowerCase());
                                response.setContentLength((long)image.length);
                                try {
                                    response.getOutputStream().write(image);
                                }
                                catch (IOException e) {
                                    RawPage.this.logger.error("Failed to write image response", (Throwable)e);
                                }
                                break;
                            }
                            case 3: {
                                byte[] binary = JGitUtils.getByteContent(r, commit.getTree(), blobPath);
                                response.setContentLength((long)binary.length);
                                response.setContentType("application/octet-stream");
                                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                                try {
                                    response.getOutputStream().write(binary);
                                }
                                catch (IOException e) {
                                    RawPage.this.logger.error("Failed to write binary response", (Throwable)e);
                                }
                                break;
                            }
                            default: {
                                String content = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                                response.setContentType("text/plain; charset=UTF-8");
                                try {
                                    response.getOutputStream().write(content.getBytes("UTF-8"));
                                }
                                catch (Exception e) {
                                    RawPage.this.logger.error("Failed to write text response", (Throwable)e);
                                }
                                break;
                            }
                        }
                    } else {
                        String content = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                        response.setContentType("text/plain; charset=UTF-8");
                        try {
                            response.getOutputStream().write(content.getBytes("UTF-8"));
                        }
                        catch (Exception e) {
                            RawPage.this.logger.error("Failed to write text response", (Throwable)e);
                        }
                    }
                }
                r.close();
            }
        });
    }
}

