/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.SessionlessForm;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ActivityPage;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.FederationPage;
import com.gitblit.wicket.pages.LuceneSearchPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.UsersPage;
import com.gitblit.wicket.panels.NavigationPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebResponse;

public abstract class RootPage
extends BasePage {
    boolean showAdmin;
    IModel<String> username = new Model((Serializable)((Object)""));
    IModel<String> password = new Model((Serializable)((Object)""));
    List<RepositoryModel> repositoryModels = new ArrayList<RepositoryModel>();

    public RootPage() {
    }

    public RootPage(PageParameters params) {
        super(params);
    }

    @Override
    protected void setupPage(String repositoryName, String pageName) {
        boolean authenticateView = GitBlit.getBoolean("web.authenticateViewPages", false);
        boolean authenticateAdmin = GitBlit.getBoolean("web.authenticateAdminPages", true);
        boolean allowAdmin = GitBlit.getBoolean("web.allowAdministration", true);
        if (authenticateAdmin) {
            this.showAdmin = allowAdmin && GitBlitWebSession.get().canAdmin();
            this.setStatelessHint(false);
        } else {
            this.showAdmin = allowAdmin;
            if (authenticateView) {
                this.setStatelessHint(false);
            } else {
                this.setStatelessHint(true);
            }
        }
        boolean showRegistrations = GitBlit.canFederate() && GitBlit.getBoolean("web.showFederationRegistrations", false);
        ArrayList<PageRegistration> pages = new ArrayList<PageRegistration>();
        pages.add(new PageRegistration("gb.repositories", RepositoriesPage.class, this.getRootPageParameters()));
        pages.add(new PageRegistration("gb.activity", ActivityPage.class, this.getRootPageParameters()));
        if (GitBlit.getBoolean("web.allowLuceneIndexing", true)) {
            pages.add(new PageRegistration("gb.search", LuceneSearchPage.class));
        }
        if (this.showAdmin) {
            pages.add(new PageRegistration("gb.users", UsersPage.class));
        }
        if (this.showAdmin || showRegistrations) {
            pages.add(new PageRegistration("gb.federation", FederationPage.class));
        }
        if (!authenticateView || authenticateView && GitBlitWebSession.get().isLoggedIn()) {
            this.addDropDownMenus(pages);
        }
        NavigationPanel navPanel = new NavigationPanel("navPanel", ((Object)((Object)this)).getClass(), pages);
        this.add(new Component[]{navPanel});
        SessionlessForm<Void> loginForm = new SessionlessForm<Void>("loginForm", ((Object)((Object)this)).getClass(), this.getPageParameters()){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                String username = (String)RootPage.this.username.getObject();
                char[] password = ((String)RootPage.this.password.getObject()).toCharArray();
                UserModel user = GitBlit.self().authenticate(username, password);
                if (user == null) {
                    this.error((Serializable)((Object)this.getString("gb.invalidUsernameOrPassword")));
                } else if (user.username.equals("$gitblit")) {
                    this.error((Serializable)((Object)this.getString("gb.invalidUsernameOrPassword")));
                    user = null;
                } else {
                    RootPage.this.loginUser(user);
                }
            }
        };
        TextField unameField = new TextField("username", this.username);
        WicketUtils.setInputPlaceholder((Component)unameField, this.getString("gb.username"));
        loginForm.add(new Component[]{unameField});
        PasswordTextField pwField = new PasswordTextField("password", this.password);
        WicketUtils.setInputPlaceholder((Component)pwField, this.getString("gb.password"));
        loginForm.add(new Component[]{pwField});
        this.add(new Component[]{loginForm});
        if (authenticateView || authenticateAdmin) {
            loginForm.setVisible(!GitBlitWebSession.get().isLoggedIn());
        } else {
            loginForm.setVisible(false);
        }
        String cachedMessage = GitBlitWebSession.get().clearErrorMessage();
        if (!StringUtils.isEmpty(cachedMessage)) {
            this.error((Serializable)((Object)cachedMessage));
        } else if (this.showAdmin) {
            int pendingProposals = GitBlit.self().getPendingFederationProposals().size();
            if (pendingProposals == 1) {
                this.info(this.getString("gb.OneProposalToReview"));
            } else if (pendingProposals > 1) {
                this.info(MessageFormat.format(this.getString("gb.nFederationProposalsToReview"), pendingProposals));
            }
        }
        super.setupPage(repositoryName, pageName);
    }

    private PageParameters getRootPageParameters() {
        PageParameters pp;
        if (this.reusePageParameters() && (pp = this.getPageParameters()) != null) {
            PageParameters params = new PageParameters((Map)pp);
            params.remove((Object)"p");
            params.remove((Object)"r");
            params.remove((Object)"user");
            if (params.containsKey((Object)"db") && params.getInt("db") == GitBlit.getInteger("web.activityDuration", 14)) {
                params.remove((Object)"db");
            }
            return params;
        }
        return null;
    }

    protected boolean reusePageParameters() {
        return false;
    }

    private void loginUser(UserModel user) {
        if (user != null) {
            GitBlitWebSession session = GitBlitWebSession.get();
            session.replaceSession();
            session.setUser(user);
            if (GitBlit.getBoolean("web.allowCookieAuthentication", false)) {
                WebResponse response = (WebResponse)this.getRequestCycle().getResponse();
                GitBlit.self().setCookie(response, user);
            }
            if (!session.continueRequest()) {
                PageParameters params = this.getPageParameters();
                if (params == null) {
                    this.setResponsePage(((Object)((Object)this)).getClass());
                } else {
                    params.remove((Object)"username");
                    params.remove((Object)"password");
                    this.setResponsePage(((Object)((Object)this)).getClass(), params);
                }
            }
        }
    }

    protected List<RepositoryModel> getRepositoryModels() {
        if (this.repositoryModels.isEmpty()) {
            UserModel user = GitBlitWebSession.get().getUser();
            List<RepositoryModel> repositories = GitBlit.self().getRepositoryModels(user);
            this.repositoryModels.addAll(repositories);
            Collections.sort(this.repositoryModels);
        }
        return this.repositoryModels;
    }

    protected void addDropDownMenus(List<PageRegistration> pages) {
    }

    protected List<PageRegistration.DropDownMenuItem> getRepositoryFilterItems(PageParameters params) {
        String customFilters;
        UserModel user = GitBlitWebSession.get().getUser();
        LinkedHashSet<PageRegistration.DropDownMenuItem> filters = new LinkedHashSet<PageRegistration.DropDownMenuItem>();
        List<RepositoryModel> repositories = this.getRepositoryModels();
        HashMap<String, AtomicInteger> setMap = new HashMap<String, AtomicInteger>();
        for (RepositoryModel repository : repositories) {
            for (String set : repository.federationSets) {
                String key = set.toLowerCase();
                if (setMap.containsKey(key)) {
                    ((AtomicInteger)setMap.get(key)).incrementAndGet();
                    continue;
                }
                setMap.put(key, new AtomicInteger(1));
            }
        }
        if (setMap.size() > 0) {
            ArrayList sets = new ArrayList(setMap.keySet());
            Collections.sort(sets);
            for (String set : sets) {
                filters.add(new PageRegistration.DropDownMenuItem(MessageFormat.format("{0} ({1})", set, ((AtomicInteger)setMap.get(set)).get()), "set", set, params));
            }
            filters.add(new PageRegistration.DropDownMenuItem());
        }
        if (user != null && user.teams.size() > 0) {
            ArrayList<TeamModel> teams = new ArrayList<TeamModel>(user.teams);
            Collections.sort(teams);
            for (TeamModel team : teams) {
                filters.add(new PageRegistration.DropDownMenuItem(MessageFormat.format("{0} ({1})", team.name, team.repositories.size()), "team", team.name, params));
            }
            filters.add(new PageRegistration.DropDownMenuItem());
        }
        if (!StringUtils.isEmpty(customFilters = GitBlit.getString("web.customFilters", null))) {
            boolean addedExpression = false;
            List<String> expressions = StringUtils.getStringsFromValue(customFilters, "!!!");
            for (String expression : expressions) {
                if (StringUtils.isEmpty(expression)) continue;
                addedExpression = true;
                filters.add(new PageRegistration.DropDownMenuItem(null, "x", expression, params));
            }
            if (addedExpression) {
                filters.add(new PageRegistration.DropDownMenuItem());
            }
        }
        return new ArrayList<PageRegistration.DropDownMenuItem>(filters);
    }

    protected List<PageRegistration.DropDownMenuItem> getTimeFilterItems(PageParameters params) {
        int daysBack = GitBlit.getInteger("web.activityDuration", 14);
        if (daysBack < 1) {
            daysBack = 14;
        }
        ArrayList<PageRegistration.DropDownMenuItem> items = new ArrayList<PageRegistration.DropDownMenuItem>();
        HashSet<Integer> choicesSet = new HashSet<Integer>(Arrays.asList(daysBack, 14, 28, 60, 90, 180));
        ArrayList<Integer> choices = new ArrayList<Integer>(choicesSet);
        Collections.sort(choices);
        String lastDaysPattern = this.getString("gb.lastNDays");
        for (Integer db : choices) {
            String txt = MessageFormat.format(lastDaysPattern, db);
            items.add(new PageRegistration.DropDownMenuItem(txt, "db", db.toString(), params));
        }
        items.add(new PageRegistration.DropDownMenuItem());
        return items;
    }

    protected List<RepositoryModel> getRepositories(PageParameters params) {
        if (params == null) {
            return this.getRepositoryModels();
        }
        boolean hasParameter = false;
        String projectName = WicketUtils.getProjectName(params);
        String userName = WicketUtils.getUsername(params);
        if (StringUtils.isEmpty(projectName) && !StringUtils.isEmpty(userName)) {
            projectName = "~" + userName;
        }
        String repositoryName = WicketUtils.getRepositoryName(params);
        String set = WicketUtils.getSet(params);
        String regex2 = WicketUtils.getRegEx(params);
        String team = WicketUtils.getTeam(params);
        int daysBack = params.getInt("db", 0);
        List<RepositoryModel> availableModels = this.getRepositoryModels();
        HashSet<RepositoryModel> models = new HashSet<RepositoryModel>();
        if (!StringUtils.isEmpty(repositoryName)) {
            hasParameter = true;
            for (RepositoryModel model : availableModels) {
                if (!model.name.equalsIgnoreCase(repositoryName)) continue;
                models.add(model);
                break;
            }
        }
        if (!StringUtils.isEmpty(projectName)) {
            hasParameter = true;
            if (projectName.equalsIgnoreCase(GitBlit.getString("web.repositoryRootGroupName", "main"))) {
                for (RepositoryModel model : availableModels) {
                    if (model.name.indexOf(47) != -1) continue;
                    models.add(model);
                }
            } else {
                String group = projectName.toLowerCase() + "/";
                for (RepositoryModel model : availableModels) {
                    if (!model.name.toLowerCase().startsWith(group)) continue;
                    models.add(model);
                }
            }
        }
        if (!StringUtils.isEmpty(regex2)) {
            hasParameter = true;
            Pattern pattern = Pattern.compile(regex2);
            for (RepositoryModel model : availableModels) {
                if (!pattern.matcher(model.name).find()) continue;
                models.add(model);
            }
        }
        if (!StringUtils.isEmpty(set)) {
            hasParameter = true;
            List<String> sets = StringUtils.getStringsFromValue(set, ",");
            for (RepositoryModel model : availableModels) {
                for (String curr : sets) {
                    if (!model.federationSets.contains(curr)) continue;
                    models.add(model);
                }
            }
        }
        if (!StringUtils.isEmpty(team)) {
            hasParameter = true;
            List<String> teams = StringUtils.getStringsFromValue(team, ",");
            ArrayList<TeamModel> teamModels = new ArrayList<TeamModel>();
            for (String name : teams) {
                TeamModel teamModel = GitBlit.self().getTeamModel(name);
                if (teamModel == null) continue;
                teamModels.add(teamModel);
            }
            for (RepositoryModel repositoryModel : availableModels) {
                for (TeamModel teamModel : teamModels) {
                    if (!teamModel.hasRepositoryPermission(repositoryModel.name)) continue;
                    models.add(repositoryModel);
                }
            }
        }
        if (!hasParameter) {
            models.addAll(availableModels);
        }
        if (daysBack > 0) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, -1 * daysBack);
            Date threshold = cal.getTime();
            HashSet<RepositoryModel> timeFiltered = new HashSet<RepositoryModel>();
            for (RepositoryModel model : models) {
                if (!model.lastChange.after(threshold)) continue;
                timeFiltered.add(model);
            }
            models = timeFiltered;
        }
        ArrayList<RepositoryModel> list = new ArrayList<RepositoryModel>(models);
        Collections.sort(list);
        return list;
    }
}

