/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.Metric;
import com.gitblit.models.PathModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.MetricsPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.BranchesPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.LogPanel;
import com.gitblit.wicket.panels.RepositoryUrlPanel;
import com.gitblit.wicket.panels.TagsPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.wicketstuff.googlecharts.Chart;
import org.wicketstuff.googlecharts.ChartAxis;
import org.wicketstuff.googlecharts.ChartAxisType;
import org.wicketstuff.googlecharts.ChartProvider;
import org.wicketstuff.googlecharts.ChartType;
import org.wicketstuff.googlecharts.IChartAxis;
import org.wicketstuff.googlecharts.IChartData;
import org.wicketstuff.googlecharts.IChartProvider;
import org.wicketstuff.googlecharts.ILineStyle;
import org.wicketstuff.googlecharts.IShapeMarker;
import org.wicketstuff.googlecharts.LineStyle;
import org.wicketstuff.googlecharts.MarkerType;
import org.wicketstuff.googlecharts.ShapeMarker;

public class SummaryPage
extends RepositoryPage {
    public SummaryPage(PageParameters params) {
        super(params);
        int numberCommits = GitBlit.getInteger("web.summaryCommitCount", 20);
        if (numberCommits <= 0) {
            numberCommits = 20;
        }
        int numberRefs = GitBlit.getInteger("web.summaryRefsCount", 5);
        Repository r = this.getRepository();
        RepositoryModel model = this.getRepositoryModel();
        List<Metric> metrics = null;
        Metric metricsTotal = null;
        if (!model.skipSummaryMetrics && GitBlit.getBoolean("web.generateActivityGraph", true)) {
            metrics = GitBlit.self().getRepositoryDefaultMetrics(model, r);
            metricsTotal = metrics.remove(0);
        }
        this.addSyndicationDiscoveryLink();
        this.add(new Component[]{new Label("repositoryDescription", this.getRepositoryModel().description)});
        String owner = this.getRepositoryModel().owner;
        if (StringUtils.isEmpty(owner)) {
            this.add(new Component[]{new Label("repositoryOwner").setVisible(false)});
        } else {
            UserModel ownerModel = GitBlit.self().getUserModel(owner);
            if (ownerModel != null) {
                this.add(new Component[]{new LinkPanel("repositoryOwner", null, ownerModel.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(owner))});
            } else {
                this.add(new Component[]{new Label("repositoryOwner", owner)});
            }
        }
        this.add(new Component[]{WicketUtils.createTimestampLabel("repositoryLastChange", JGitUtils.getLastChange(r), this.getTimeZone(), this.getTimeUtils())});
        if (metricsTotal == null) {
            this.add(new Component[]{new Label("branchStats", "")});
        } else {
            this.add(new Component[]{new Label("branchStats", MessageFormat.format(this.getString("gb.branchStats"), metricsTotal.count, metricsTotal.tag, this.getTimeUtils().duration(metricsTotal.duration)))});
        }
        this.add(new Component[]{new BookmarkablePageLink("metrics", MetricsPage.class, WicketUtils.newRepositoryParameter(this.repositoryName))});
        ArrayList<String> repositoryUrls = new ArrayList<String>();
        if (GitBlit.getBoolean("git.enableGitServlet", true)) {
            Constants.AccessRestrictionType accessRestriction = this.getRepositoryModel().accessRestriction;
            switch (accessRestriction) {
                case NONE: {
                    this.add(new Component[]{WicketUtils.newClearPixel("accessRestrictionIcon").setVisible(false)});
                    break;
                }
                case PUSH: {
                    this.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_go_16x16.png", this.getAccessRestrictions().get((Object)accessRestriction))});
                    break;
                }
                case CLONE: {
                    this.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_pull_16x16.png", this.getAccessRestrictions().get((Object)accessRestriction))});
                    break;
                }
                case VIEW: {
                    this.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "shield_16x16.png", this.getAccessRestrictions().get((Object)accessRestriction))});
                    break;
                }
                default: {
                    this.add(new Component[]{WicketUtils.newClearPixel("accessRestrictionIcon").setVisible(false)});
                }
            }
            repositoryUrls.add(SummaryPage.getRepositoryUrl(this.getRepositoryModel()));
        } else {
            this.add(new Component[]{WicketUtils.newClearPixel("accessRestrictionIcon").setVisible(false)});
        }
        repositoryUrls.addAll(GitBlit.self().getOtherCloneUrls(this.repositoryName));
        String primaryUrl = ArrayUtils.isEmpty(repositoryUrls) ? "" : (String)repositoryUrls.remove(0);
        this.add(new Component[]{new RepositoryUrlPanel("repositoryCloneUrl", primaryUrl)});
        this.add(new Component[]{new Label("otherUrls", StringUtils.flattenStrings(repositoryUrls, "<br/>")).setEscapeModelStrings(false)});
        this.add(new Component[]{new LogPanel("commitsPanel", this.repositoryName, this.getRepositoryModel().HEAD, r, numberCommits, 0, this.getRepositoryModel().showRemoteBranches)});
        this.add(new Component[]{new TagsPanel("tagsPanel", this.repositoryName, r, numberRefs).hideIfEmpty()});
        this.add(new Component[]{new BranchesPanel("branchesPanel", this.getRepositoryModel(), r, numberRefs, false).hideIfEmpty()});
        if (this.getRepositoryModel().showReadme) {
            String htmlText = null;
            String markdownText = null;
            String readme = null;
            try {
                RevCommit head = JGitUtils.getCommit(r, null);
                List<String> markdownExtensions = GitBlit.getStrings("web.markdownExtensions");
                List<PathModel> paths = JGitUtils.getFilesInPath(r, null, head);
                for (PathModel path : paths) {
                    String ext;
                    String name;
                    if (path.isTree() || !(name = path.name.toLowerCase()).startsWith("readme") || name.indexOf(46) <= -1 || !markdownExtensions.contains(ext = name.substring(name.lastIndexOf(46) + 1))) continue;
                    readme = path.name;
                    break;
                }
                if (!StringUtils.isEmpty(readme)) {
                    String[] encodings = GitBlit.getEncodings();
                    markdownText = JGitUtils.getStringContent(r, head.getTree(), readme, encodings);
                    htmlText = MarkdownUtils.transformMarkdown(markdownText);
                }
            }
            catch (ParseException p) {
                markdownText = MessageFormat.format("<div class=\"alert alert-error\"><strong>{0}:</strong> {1}</div>{2}", this.getString("gb.error"), this.getString("gb.markdownFailure"), markdownText);
                htmlText = StringUtils.breakLinesForHtml(markdownText);
            }
            Fragment fragment = new Fragment("readme", "markdownPanel");
            fragment.add(new Component[]{new Label("readmeFile", readme)});
            Component content = new Label("readmeContent", htmlText).setEscapeModelStrings(false);
            fragment.add(new Component[]{content.setVisible(!StringUtils.isEmpty(htmlText))});
            this.add(new Component[]{fragment});
        } else {
            this.add(new Component[]{new Label("readme").setVisible(false)});
        }
        this.insertActivityGraph(metrics);
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.summary");
    }

    private void insertActivityGraph(List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0 && GitBlit.getBoolean("web.generateActivityGraph", true)) {
            IChartData data = WicketUtils.getChartData(metrics);
            ChartProvider provider = new ChartProvider(new Dimension(290, 100), ChartType.LINE, data);
            ChartAxis dateAxis = new ChartAxis(ChartAxisType.BOTTOM);
            dateAxis.setLabels(new String[]{metrics.get((int)0).name, metrics.get((int)(metrics.size() / 2)).name, metrics.get((int)(metrics.size() - 1)).name});
            provider.addAxis((IChartAxis)dateAxis);
            ChartAxis commitAxis = new ChartAxis(ChartAxisType.LEFT);
            commitAxis.setLabels(new String[]{"", String.valueOf((int)WicketUtils.maxValue(metrics))});
            provider.addAxis((IChartAxis)commitAxis);
            provider.setLineStyles((ILineStyle[])new LineStyle[]{new LineStyle(2, 4, 0), new LineStyle(0, 4, 1)});
            provider.addShapeMarker((IShapeMarker)new ShapeMarker(MarkerType.CIRCLE, Color.BLUE, 1, -1.0, 5));
            this.add(new Component[]{new Chart("commitsChart", (IChartProvider)provider)});
        } else {
            this.add(new Component[]{WicketUtils.newBlankImage("commitsChart")});
        }
    }
}

