/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.RefModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.GravatarImage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.eclipse.jgit.lib.Repository;

public class TagPage
extends RepositoryPage {
    public TagPage(PageParameters params) {
        super(params);
        Class linkClass;
        String typeKey;
        Repository r = this.getRepository();
        List<RefModel> tags = JGitUtils.getTags(r, true, -1);
        RefModel tagRef = null;
        for (RefModel tag : tags) {
            if (!tag.getName().equals(this.objectId) && !tag.getObjectId().getName().equals(this.objectId)) continue;
            tagRef = tag;
            break;
        }
        if (tagRef == null) {
            this.error(MessageFormat.format(this.getString("gb.couldNotFindTag"), this.objectId), true);
        }
        PageParameters linkParameters = this.newCommitParameter(tagRef.getReferencedObjectId().getName());
        switch (tagRef.getReferencedObjectType()) {
            case 3: {
                typeKey = "gb.blob";
                linkClass = BlobPage.class;
                break;
            }
            case 2: {
                typeKey = "gb.tree";
                linkClass = TreePage.class;
                break;
            }
            default: {
                typeKey = "gb.commit";
                linkClass = CommitPage.class;
            }
        }
        this.add(new Component[]{new LinkPanel("commit", "title", tagRef.displayName, linkClass, linkParameters)});
        this.add(new Component[]{new GravatarImage("taggerAvatar", tagRef.getAuthorIdent())});
        this.add(new Component[]{new RefsPanel("tagName", this.repositoryName, Arrays.asList(tagRef))});
        this.add(new Component[]{new Label("tagId", tagRef.getObjectId().getName())});
        this.add(new Component[]{new LinkPanel("taggedObject", "list", tagRef.getReferencedObjectId().getName(), linkClass, linkParameters)});
        this.add(new Component[]{new Label("taggedObjectType", this.getString(typeKey))});
        this.add(new Component[]{this.createPersonPanel("tagger", tagRef.getAuthorIdent(), Constants.SearchType.AUTHOR)});
        Date when = new Date(0L);
        if (tagRef.getAuthorIdent() != null) {
            when = tagRef.getAuthorIdent().getWhen();
        }
        this.add(new Component[]{WicketUtils.createTimestampLabel("tagDate", when, this.getTimeZone(), this.getTimeUtils())});
        this.addFullText("fullMessage", tagRef.getFullMessage(), true);
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.tag");
    }
}

