/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.TicketModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TicgitUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.Repository;

public class TicketPage
extends RepositoryPage {
    public TicketPage(PageParameters params) {
        super(params);
        String ticketFolder = WicketUtils.getPath(params);
        Repository r = this.getRepository();
        TicketModel t = TicgitUtils.getTicket(r, ticketFolder);
        this.add(new Component[]{new Label("ticketTitle", t.title)});
        this.add(new Component[]{new Label("ticketId", t.id)});
        this.add(new Component[]{new Label("ticketHandler", t.handler.toLowerCase())});
        this.add(new Component[]{WicketUtils.createTimestampLabel("ticketOpenDate", t.date, this.getTimeZone(), this.getTimeUtils())});
        Label stateLabel = new Label("ticketState", t.state);
        WicketUtils.setTicketCssClass((Component)stateLabel, t.state);
        this.add(new Component[]{stateLabel});
        this.add(new Component[]{new Label("ticketTags", StringUtils.flattenStrings(t.tags))});
        ListDataProvider commentsDp = new ListDataProvider(t.comments);
        DataView<TicketModel.Comment> commentsView = new DataView<TicketModel.Comment>("comment", (IDataProvider)commentsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<TicketModel.Comment> item) {
                TicketModel.Comment entry = (TicketModel.Comment)item.getModelObject();
                item.add(new Component[]{WicketUtils.createDateLabel("commentDate", entry.date, GitBlitWebSession.get().getTimezone(), TicketPage.this.getTimeUtils())});
                item.add(new Component[]{new Label("commentAuthor", entry.author.toLowerCase())});
                item.add(new Component[]{new Label("commentText", TicketPage.this.prepareComment(entry.text)).setEscapeModelStrings(false)});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{commentsView});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.ticket");
    }

    private String prepareComment(String comment) {
        String html = StringUtils.escapeForHtml(comment, false);
        html = StringUtils.breakLinesForHtml(comment).trim();
        return html.replaceAll("\\bcommit\\s*([A-Za-z0-9]*)\\b", "<a href=\"/commit/" + this.repositoryName + "/$1\">commit $1</a>");
    }
}

