/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.GravatarImage;
import com.gitblit.wicket.panels.LinkPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitHeaderPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public CommitHeaderPanel(String id, String title) {
        super(id);
        this.add(new Component[]{new Label("shortmessage", title)});
        this.add(new Component[]{new Label("commitid")});
        this.add(new Component[]{new Label("author")});
        this.add(new Component[]{new Label("date")});
    }

    public CommitHeaderPanel(String id, String repositoryName, RevCommit c) {
        super(id);
        this.add(new Component[]{new LinkPanel("shortmessage", "title", StringUtils.trimString(c.getShortMessage(), 78), CommitPage.class, WicketUtils.newObjectParameter(repositoryName, c.getName()))});
        this.add(new Component[]{new Label("commitid", c.getName())});
        this.add(new Component[]{new Label("author", c.getAuthorIdent().getName())});
        this.add(new Component[]{WicketUtils.createDateLabel("date", c.getAuthorIdent().getWhen(), this.getTimeZone(), this.getTimeUtils())});
        this.add(new Component[]{new GravatarImage("authorAvatar", c.getAuthorIdent())});
    }
}

