/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.utils.FederationUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.SendProposalPage;
import com.gitblit.wicket.panels.BasePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class FederationTokensPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public FederationTokensPanel(String wicketId, boolean showFederation) {
        super(wicketId);
        final String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
        this.add(new Component[]{new ExternalLink("federatedUsers", FederationUtils.asLink(baseUrl, GitBlit.self().getFederationToken(Constants.FederationToken.USERS_AND_REPOSITORIES), Constants.FederationRequest.PULL_USERS))});
        this.add(new Component[]{new ExternalLink("federatedSettings", FederationUtils.asLink(baseUrl, GitBlit.self().getFederationToken(Constants.FederationToken.ALL), Constants.FederationRequest.PULL_SETTINGS))});
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Constants.FederationToken token : Constants.FederationToken.values()) {
            data.add(new String[]{token.name(), GitBlit.self().getFederationToken(token), null});
        }
        List<String> sets = GitBlit.getStrings("federation.sets");
        Collections.sort(sets);
        for (String set : sets) {
            data.add(new String[]{Constants.FederationToken.REPOSITORIES.name(), GitBlit.self().getFederationToken(set), set});
        }
        DataView<String[]> dataView = new DataView<String[]>("row", (IDataProvider)new ListDataProvider(data)){
            private static final long serialVersionUID = 1L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<String[]> item) {
                String[] entry = (String[])item.getModelObject();
                Constants.FederationToken token = Constants.FederationToken.fromName(entry[0]);
                if (entry[2] == null) {
                    item.add(new Component[]{new Label("description", FederationTokensPanel.this.describeToken(token))});
                } else {
                    item.add(new Component[]{new Label("description", entry[2])});
                }
                item.add(new Component[]{new Label("value", entry[1])});
                item.add(new Component[]{new ExternalLink("repositoryDefinitions", FederationUtils.asLink(baseUrl, entry[1], Constants.FederationRequest.PULL_REPOSITORIES))});
                item.add(new Component[]{new BookmarkablePageLink("send", SendProposalPage.class, WicketUtils.newTokenParameter(entry[1]))});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{dataView.setVisible(showFederation)});
    }

    private String describeToken(Constants.FederationToken token) {
        switch (token) {
            case ALL: {
                return this.getString("gb.tokenAllDescription");
            }
            case USERS_AND_REPOSITORIES: {
                return this.getString("gb.tokenUnrDescription");
            }
        }
        return this.getString("gb.tokenJurDescription");
    }
}

