/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.PathModel;
import com.gitblit.models.RefModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlobDiffPage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class HistoryPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private boolean hasMore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryPanel(String wicketId, final String repositoryName, final String objectId, final String path, Repository r, int limit, int pageOffset, boolean showRemoteRefs) {
        super(wicketId);
        boolean pageResults = limit <= 0;
        int itemsPerPage = GitBlit.getInteger("web.itemsPerPage", 50);
        if (itemsPerPage <= 1) {
            itemsPerPage = 50;
        }
        RevCommit commit = JGitUtils.getCommit(r, objectId);
        List<PathModel.PathChangeModel> paths = JGitUtils.getFilesInCommit(r, commit);
        PathModel matchingPath = null;
        for (PathModel.PathChangeModel p : paths) {
            if (!p.path.equals(path)) continue;
            matchingPath = p;
            break;
        }
        if (matchingPath == null) {
            TreeWalk tw = new TreeWalk(r);
            tw.reset();
            tw.setRecursive(true);
            try {
                tw.addTree((AnyObjectId)commit.getTree());
                tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(path)));
                while (tw.next()) {
                    if (!tw.getPathString().equals(path)) continue;
                    matchingPath = new PathModel.PathChangeModel(tw.getPathString(), tw.getPathString(), 0L, tw.getRawMode(0), tw.getObjectId(0).getName(), commit.getId().getName(), DiffEntry.ChangeType.MODIFY);
                }
            }
            catch (Exception e) {
            }
            finally {
                tw.release();
            }
        }
        final boolean isTree = matchingPath == null ? true : matchingPath.isTree();
        final Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(r, showRemoteRefs);
        List<RevCommit> commits = pageResults ? JGitUtils.getRevLog(r, objectId, path, pageOffset * itemsPerPage, itemsPerPage) : JGitUtils.getRevLog(r, objectId, path, 0, limit);
        this.hasMore = commits.size() >= itemsPerPage;
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", repositoryName, commit)});
        this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", repositoryName, path, objectId)});
        final int hashLen = GitBlit.getInteger("web.shortCommitIdLength", 6);
        ListDataProvider dp = new ListDataProvider(commits);
        DataView<RevCommit> logView = new DataView<RevCommit>("commit", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<RevCommit> item) {
                String shortMessage;
                RevCommit entry = (RevCommit)item.getModelObject();
                Date date = JGitUtils.getCommitDate(entry);
                item.add(new Component[]{WicketUtils.createDateLabel("commitDate", date, HistoryPanel.this.getTimeZone(), HistoryPanel.this.getTimeUtils())});
                String author = entry.getAuthorIdent().getName();
                LinkPanel authorLink = new LinkPanel("commitAuthor", "list", author, GitSearchPage.class, WicketUtils.newSearchParameter(repositoryName, objectId, author, Constants.SearchType.AUTHOR));
                HistoryPanel.this.setPersonSearchTooltip((Component)authorLink, author, Constants.SearchType.AUTHOR);
                item.add(new Component[]{authorLink});
                if (entry.getParentCount() > 1) {
                    item.add(new Component[]{WicketUtils.newImage("commitIcon", "commit_merge_16x16.png")});
                } else {
                    item.add(new Component[]{WicketUtils.newBlankImage("commitIcon")});
                }
                String trimmedMessage = shortMessage = entry.getShortMessage();
                trimmedMessage = allRefs.containsKey(entry.getId()) ? StringUtils.trimString(shortMessage, 60) : StringUtils.trimString(shortMessage, 78);
                LinkPanel shortlog = new LinkPanel("commitShortMessage", "list subject", trimmedMessage, CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()));
                if (!shortMessage.equals(trimmedMessage)) {
                    WicketUtils.setHtmlTooltip((Component)shortlog, shortMessage);
                }
                item.add(new Component[]{shortlog});
                item.add(new Component[]{new RefsPanel("commitRefs", repositoryName, entry, allRefs)});
                if (isTree) {
                    item.add(new Component[]{new Label("hashLabel", this.getString("gb.tree") + "@")});
                    LinkPanel commitHash = new LinkPanel("hashLink", null, entry.getName().substring(0, hashLen), TreePage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()));
                    WicketUtils.setCssClass((Component)commitHash, "shortsha1");
                    WicketUtils.setHtmlTooltip((Component)commitHash, entry.getName());
                    item.add(new Component[]{commitHash});
                    Fragment links = new Fragment("historyLinks", "treeLinks", (MarkupContainer)this);
                    links.add(new Component[]{new BookmarkablePageLink("commitdiff", CommitDiffPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                    item.add(new Component[]{links});
                } else {
                    item.add(new Component[]{new Label("hashLabel", this.getString("gb.blob") + "@")});
                    LinkPanel commitHash = new LinkPanel("hashLink", null, entry.getName().substring(0, hashLen), BlobPage.class, WicketUtils.newPathParameter(repositoryName, entry.getName(), path));
                    WicketUtils.setCssClass((Component)commitHash, "sha1");
                    WicketUtils.setHtmlTooltip((Component)commitHash, entry.getName());
                    item.add(new Component[]{commitHash});
                    Fragment links = new Fragment("historyLinks", "blobLinks", (MarkupContainer)this);
                    links.add(new Component[]{new BookmarkablePageLink("commitdiff", CommitDiffPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                    links.add(new Component[]{new BookmarkablePageLink("difftocurrent", BlobDiffPage.class, WicketUtils.newBlobDiffParameter(repositoryName, entry.getName(), objectId, path)).setEnabled(this.counter > 0)});
                    item.add(new Component[]{links});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{logView});
        if (limit <= 0) {
            this.add(new Component[]{new Label("moreHistory", "").setVisible(false)});
        } else if (pageResults) {
            this.add(new Component[]{new Label("moreHistory", "").setVisible(false)});
        } else if (commits.size() == limit) {
            this.add(new Component[]{new LinkPanel("moreHistory", "link", (IModel<String>)new StringResourceModel("gb.moreHistory", (Component)this, null), HistoryPage.class, WicketUtils.newPathParameter(repositoryName, objectId, path))});
        } else {
            this.add(new Component[]{new Label("moreHistory", "").setVisible(false)});
        }
    }

    public boolean hasMore() {
        return this.hasMore;
    }
}

